/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.xlt.agent.AbstractExecutionTimer;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;

public class RandomExecutionTimer
extends AbstractExecutionTimer {
    private final UserCountControllerTimerTask timerTask;
    private int permitsToSwallow;
    private final int thinkTime;
    private final int thinkTimeDeviation;
    private final Timer timer;
    private final ThreadLocal<Boolean> waitsTheFirstTime = new ThreadLocal();

    public RandomExecutionTimer(String userTypeName, long initialDelay, long duration, int shutdownPeriod, int[][] users, int agentIndex) {
        super(userTypeName, initialDelay, duration, shutdownPeriod);
        this.thinkTime = XltProperties.getInstance().getProperty("com.xceptance.xlt.thinktime.transaction", 0);
        this.thinkTimeDeviation = XltProperties.getInstance().getProperty("com.xceptance.xlt.thinktime.transaction.deviation", 0);
        this.timer = new Timer("RandomExecutionTimer-" + userTypeName, true);
        this.timerTask = new UserCountControllerTimerTask(users, this, initialDelay);
        this.timer.scheduleAtFixedRate((TimerTask)this.timerTask, initialDelay, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeWait() throws InterruptedException {
        long resultingThinkTime = Math.max(0, XltRandom.nextIntWithDeviation(this.thinkTime, this.thinkTimeDeviation));
        Logger logger = XltLogger.runTimeLogger;
        if (logger.isInfoEnabled()) {
            logger.info("Executing transaction think time wait (" + resultingThinkTime + " ms)...");
        }
        if (resultingThinkTime > 0L) {
            Thread.sleep(resultingThinkTime);
        }
        boolean doAcquire = false;
        if (this.waitsTheFirstTime.get() == null) {
            this.waitsTheFirstTime.set(false);
            doAcquire = true;
        } else {
            RandomExecutionTimer randomExecutionTimer = this;
            synchronized (randomExecutionTimer) {
                if (this.permitsToSwallow > 0) {
                    --this.permitsToSwallow;
                    doAcquire = true;
                }
            }
        }
        if (doAcquire) {
            this.timerTask.semaphore.acquire();
        }
    }

    @Override
    public void stop() {
        this.timer.cancel();
        super.stop();
    }

    private synchronized void addToPermits(int permits) {
        this.permitsToSwallow += permits;
    }

    public static class UserCountControllerTimerTask
    extends TimerTask {
        private final RandomExecutionTimer executionTimer;
        private final Semaphore semaphore;
        private final long startTimeMsec;
        private final int[][] users;
        private int lastTotal;
        private int idx = 0;

        public UserCountControllerTimerTask(int[][] users, RandomExecutionTimer executionTimer, long initialDelay) {
            this.users = users;
            this.semaphore = new Semaphore(0, true);
            this.executionTimer = executionTimer;
            this.startTimeMsec = TimerUtils.getTime() + initialDelay;
        }

        @Override
        public void run() {
            long elapsedTimeSec = Math.round((double)(TimerUtils.getTime() - this.startTimeMsec) / 1000.0);
            this.run(elapsedTimeSec);
        }

        public void run(long elapsedTimeSec) {
            int totalUsers = this.lastTotal;
            while (this.idx < this.users.length && (long)this.users[this.idx][0] <= elapsedTimeSec) {
                totalUsers = this.users[this.idx++][1];
            }
            if (totalUsers == this.lastTotal) {
                return;
            }
            int usersToRelease = totalUsers - this.lastTotal;
            this.lastTotal = totalUsers;
            if (usersToRelease < 0) {
                this.executionTimer.addToPermits(-usersToRelease);
            } else {
                this.semaphore.release(usersToRelease);
            }
        }

        public int getLastTotal() {
            return this.lastTotal;
        }
    }
}

