/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.net.InetAddressUtils;
import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;

public class AgentControllerConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.agentcontroller.";
    private static final String PROP_AGENTS_DIR = "com.xceptance.xlt.agentcontroller.agentsdir";
    private static final String PROP_KEYSTORE_PASSWORD = "com.xceptance.xlt.agentcontroller.keystore.password";
    private static final String PROP_KEY_PASSWORD = "com.xceptance.xlt.agentcontroller.keystore.key.password";
    private static final String PROP_PASSWORD = "com.xceptance.xlt.agentcontroller.password";
    private static final String PROP_HOST = "com.xceptance.xlt.agentcontroller.host";
    private static final String PROP_PORT = "com.xceptance.xlt.agentcontroller.port";
    private static final String PROP_TEMP_DIR = "com.xceptance.xlt.agentcontroller.tempdir";
    private final File agentBinDirectory;
    private final String[] agentCommand;
    private File agentsDirectory;
    private final File configDirectory;
    private final File homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
    private final String keyPassword;
    private final File keyStoreFile;
    private final String keyStorePassword;
    private final String userName;
    private final String password;
    private InetAddress host = null;
    private final int port;
    private File tempDir;

    public AgentControllerConfiguration(Properties commandLineProperties) throws IOException {
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        File propFile = new File(this.configDirectory, "agentcontroller.properties");
        this.loadProperties(propFile);
        if (commandLineProperties != null) {
            this.addProperties(commandLineProperties);
        }
        this.agentsDirectory = this.getFileProperty(PROP_AGENTS_DIR, new File("agent"));
        if (!this.agentsDirectory.isAbsolute()) {
            this.agentsDirectory = new File(this.homeDirectory, this.agentsDirectory.getPath());
        }
        this.tempDir = this.getFileProperty(PROP_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")));
        if (!this.tempDir.isAbsolute()) {
            this.tempDir = new File(this.homeDirectory, this.tempDir.getPath());
        }
        if (!this.tempDir.exists()) {
            FileUtils.forceMkdir((File)this.tempDir);
        } else if (!this.tempDir.isDirectory() || !this.tempDir.canWrite()) {
            String msg = "Temp directory does not exist or is not writable: " + this.tempDir.getCanonicalPath();
            System.out.println(msg);
            throw new IOException(msg);
        }
        this.agentBinDirectory = new File(this.homeDirectory, "bin");
        this.port = this.getIntProperty(PROP_PORT, 8500);
        this.keyStoreFile = new File(this.configDirectory, "keystore");
        this.keyStorePassword = this.getStringProperty(PROP_KEYSTORE_PASSWORD);
        this.keyPassword = this.getStringProperty(PROP_KEY_PASSWORD);
        this.userName = "xlt";
        this.password = this.getStringProperty(PROP_PASSWORD, null);
        String hostName = this.getStringProperty(PROP_HOST, "");
        if (!hostName.isEmpty()) {
            InetAddress tempHost = InetAddress.getByName(hostName);
            if (InetAddressUtils.isLocalAddress(tempHost)) {
                this.host = tempHost;
            } else {
                throw new XltException("The value '" + hostName + "' of property 'com.xceptance.xlt.agentcontroller.host' does not denote a valid local address");
            }
        }
        String scriptName = SystemUtils.IS_OS_WINDOWS ? "agent.cmd" : "agent.sh";
        this.agentCommand = new String[]{new File(this.agentBinDirectory, scriptName).getAbsolutePath(), Integer.toString(this.port), "<agentControllerName>", "<agentControllerHost>", "<agentNumber>", "<totalAgentCount>", "<acRemoteAddress>"};
    }

    public File getAgentBinDirectory() {
        return this.agentBinDirectory;
    }

    public String[] getAgentCommandLine() {
        return this.agentCommand;
    }

    public File getAgentsDirectory() {
        return this.agentsDirectory;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public InetAddress getHostAddress() {
        return this.host;
    }

    public String getHostName() {
        return this.host != null ? this.host.getHostName() : null;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public File getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public File getTempDir() {
        return this.tempDir;
    }
}

