/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.common.net.UrlConnectionFactory;
import com.xceptance.xlt.agentcontroller.FileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileManagerProxy
implements FileManager {
    private static final Logger log = LoggerFactory.getLogger(FileManagerProxy.class);
    private final URL url;
    private final UrlConnectionFactory urlConnectionFactory;

    public FileManagerProxy(URL url, UrlConnectionFactory urlConnectionFactory) throws MalformedURLException {
        this.url = new URL(url + "/fileManager/");
        this.urlConnectionFactory = urlConnectionFactory;
    }

    @Override
    public void deleteFile(String remoteFileName) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(File localFile, String remoteFileName) throws IOException {
        InputStream cin = null;
        FileOutputStream fout = null;
        try {
            URL downloadUrl = new URL(this.url + remoteFileName);
            log.debug("Downloading file from '" + downloadUrl + "' to '" + localFile + "' ...");
            FileUtils.forceMkdir((File)localFile.getParentFile());
            fout = new FileOutputStream(localFile);
            URLConnection conn = this.urlConnectionFactory.open(downloadUrl);
            cin = conn.getInputStream();
            IOUtils.copy((InputStream)cin, (OutputStream)fout);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fout);
            IOUtils.closeQuietly(cin);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fout);
        IOUtils.closeQuietly((InputStream)cin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFile(File localFile, String remoteFileName) throws IOException {
        FileInputStream fin = null;
        OutputStream cout = null;
        try {
            URL uploadUrl = new URL(this.url + remoteFileName);
            log.debug("Uploading file '" + localFile + "' to '" + uploadUrl + "' ...");
            HttpURLConnection conn = (HttpURLConnection)this.urlConnectionFactory.open(uploadUrl);
            conn.setDoOutput(true);
            conn.setRequestMethod("PUT");
            conn.setChunkedStreamingMode(4096);
            fin = new FileInputStream(localFile);
            cout = conn.getOutputStream();
            IOUtils.copy((InputStream)fin, (OutputStream)cout);
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new IOException(String.format("Server returned HTTP response code: %d for URL: %s", responseCode, uploadUrl));
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fin);
            IOUtils.closeQuietly(cout);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)fin);
        IOUtils.closeQuietly((OutputStream)cout);
    }
}

