/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import com.xceptance.xlt.api.engine.GlobalClock;
import java.io.Serializable;

public class TestUserStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long elapsedTime;
    private long endDate;
    private int errors;
    private int events;
    private Exception exception;
    private int iterations;
    private long lastModifiedDate;
    private long lastRuntime;
    private Mode mode;
    private int percentageComplete;
    private long startDate = GlobalClock.getInstance().getTime();
    private State state = State.Waiting;
    private long totalRuntime;
    private String userName;

    public void addToTotalRuntime(long millis) {
        this.totalRuntime += millis;
    }

    public long getAverageRuntime() {
        return this.iterations == 0 ? 0L : this.totalRuntime / (long)this.iterations;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public long getEndDate() {
        return this.endDate;
    }

    public int getErrors() {
        return this.errors;
    }

    public int getEvents() {
        return this.events;
    }

    public Exception getException() {
        return this.exception;
    }

    public int getIterations() {
        return this.iterations;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public long getLastRuntime() {
        return this.lastRuntime;
    }

    public Mode getMode() {
        return this.mode;
    }

    public int getPercentageComplete() {
        return this.percentageComplete;
    }

    public long getStartDate() {
        return this.startDate;
    }

    public State getState() {
        return this.state;
    }

    public long getTotalRuntime() {
        return this.totalRuntime;
    }

    public String getUserName() {
        return this.userName;
    }

    public void incrementErrors() {
        ++this.errors;
    }

    public void incrementEvents() {
        ++this.events;
    }

    public void incrementIterations() {
        ++this.iterations;
    }

    public boolean isCompleted() {
        return this.percentageComplete == 100;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public void setEndDate(long endDate) {
        this.endDate = endDate;
    }

    public void setErrors(int errors) {
        this.errors = errors;
    }

    public void setEvents(int events) {
        this.events = events;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setLastRuntime(long lastRuntime) {
        this.lastRuntime = lastRuntime;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public void setPercentageComplete(int percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    public void setStartDate(long startDate) {
        this.startDate = startDate;
    }

    public void setState(State state) {
        this.state = state;
    }

    public void setTotalRuntime(long totalRuntime) {
        this.totalRuntime = totalRuntime;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String toString() {
        return String.format("[user=%s, iterations=%d, lastRuntime=%d ms, averageRuntime=%d ms, totalRuntime=%d ms, errors=%d, progress=%d%%]", this.getUserName(), this.getIterations(), this.getLastRuntime(), this.getAverageRuntime(), this.getTotalRuntime(), this.getErrors(), this.getPercentageComplete());
    }

    public static enum State {
        Aborted,
        Failed,
        Finished,
        Running,
        Waiting;

    }

    public static enum Mode {
        ITERATION,
        TIME_PERIOD;

    }
}

