/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.TimerData;
import java.util.List;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class TransactionData
extends TimerData {
    private static final String TYPE_CODE = "T";
    private String directoryName;
    private String failedActionName;
    private String stackTrace;
    private String testUserNumber;

    public TransactionData() {
        this(null);
    }

    public TransactionData(String name) {
        super(name, TYPE_CODE);
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public String getTestUserNumber() {
        return this.testUserNumber;
    }

    public void setTestUserNumber(String testUserNumber) {
        this.testUserNumber = testUserNumber;
    }

    public String getFailedActionName() {
        return this.failedActionName;
    }

    public void setFailedActionName(String actionName) {
        this.failedActionName = actionName;
    }

    public String getDumpDirectoryPath() {
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.testUserNumber, this.directoryName})) {
            return null;
        }
        return this.getAgentName() + "/" + this.getName() + "/" + this.testUserNumber + "/output/" + this.directoryName;
    }

    public String getFailureMessage() {
        String messageWithClassPrefix = StringUtils.substringBefore((String)this.stackTrace, (String)"\n");
        String plainMessage = StringUtils.substringAfter((String)messageWithClassPrefix, (String)": ");
        if (plainMessage.isEmpty()) {
            plainMessage = messageWithClassPrefix;
        }
        return plainMessage;
    }

    public String getFailureStackTrace() {
        return this.stackTrace;
    }

    public void setFailureStackTrace(String trace) {
        this.stackTrace = trace;
    }

    public void setFailureStackTrace(Throwable throwable) {
        this.stackTrace = throwable == null ? null : ThrowableUtils.getMinifiedStackTrace(throwable);
    }

    @Override
    protected List<String> addValues() {
        List<String> fields = super.addValues();
        String t = this.stackTrace;
        if (t == null) {
            t = "";
        } else {
            t = t.replace("\n", "\\");
            t = t.replace("\r", "");
        }
        fields.add(t);
        fields.add(StringUtils.defaultString((String)this.failedActionName));
        fields.add(StringUtils.defaultString((String)this.testUserNumber));
        fields.add(StringUtils.defaultString((String)this.directoryName));
        return fields;
    }

    @Override
    protected int getMinNoCSVElements() {
        return 6;
    }

    @Override
    protected void parseValues(String[] values) {
        Matcher matcher;
        super.parseValues(values);
        this.stackTrace = values[5].trim();
        this.stackTrace = this.stackTrace.length() == 0 ? null : this.stackTrace.replace("\\", "\n");
        int length = values.length;
        if (length > 6) {
            this.setFailedActionName(values[6]);
        }
        if (length > 7) {
            this.setTestUserNumber(values[7]);
            this.setDirectoryName(values[8]);
        } else if (this.stackTrace != null && (matcher = RegExUtils.getPattern(" \\(user: '(.+)', output: '([0-9]+)'\\)").matcher(this.stackTrace)).find()) {
            this.stackTrace = StringUtils.remove((String)this.stackTrace, (String)matcher.group());
            String testUserId = matcher.group(1);
            int i = testUserId.lastIndexOf(45);
            this.testUserNumber = StringUtils.substring((String)testUserId, (int)(i + 1));
            this.directoryName = matcher.group(2);
        }
    }
}

