/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.DataManager;
import com.xceptance.xlt.api.engine.EventData;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.metrics.Metrics;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class DataManagerImpl
implements DataManager {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private static final Object mutex = new Object();
    private boolean loggingEnabled = true;
    private long startOfLoggingPeriod = Long.MIN_VALUE;
    private long endOfLoggingPeriod = Long.MAX_VALUE;
    private int numberOfEvents;
    private BufferedWriter logger;
    private final SessionImpl session;

    public int getNumberOfEvents() {
        return this.numberOfEvents;
    }

    protected DataManagerImpl(SessionImpl session) {
        this.session = session;
    }

    @Override
    public void logEvent(String eventName, String message) {
        EventData e = new EventData(eventName);
        e.setTestCaseName(this.session.getUserName());
        e.setMessage(message);
        this.logDataRecord(e);
    }

    @Override
    public synchronized void logDataRecord(Data stats) {
        Metrics.getInstance().updateMetrics(stats);
        BufferedWriter timerWriter = this.getTimerLogger();
        if (timerWriter == null) {
            return;
        }
        long time = stats.getTime();
        if (this.loggingEnabled && this.startOfLoggingPeriod <= time && time <= this.endOfLoggingPeriod) {
            try {
                timerWriter.write(stats.toCSV().replaceAll("[\n\r]+", " "));
                timerWriter.write(LINE_SEPARATOR);
                timerWriter.flush();
            }
            catch (IOException ex) {
                XltLogger.runTimeLogger.error("Failed to write statistics:", (Throwable)ex);
            }
            if (stats instanceof EventData) {
                EventData event = (EventData)stats;
                if (XltLogger.runTimeLogger.isWarnEnabled()) {
                    XltLogger.runTimeLogger.warn(String.format("EVENT: %2$s - %1$s - '%3$s'", event.getName(), event.getTestCaseName(), event.getMessage()));
                }
                ++this.numberOfEvents;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedWriter getTimerLogger() {
        DataManagerImpl dataManagerImpl = this;
        synchronized (dataManagerImpl) {
            if (this.logger != null) {
                return this.logger;
            }
        }
        File file = this.getTimerFile();
        if (file == null) {
            return null;
        }
        try {
            this.logger = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, true), "UTF-8"));
        }
        catch (FileNotFoundException | UnsupportedEncodingException e) {
            XltLogger.runTimeLogger.error("Cannot create writer for file: " + file, (Throwable)e);
        }
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File getTimerFile() {
        File file = new File(this.session.getResultsDirectory(), "timers.csv");
        try {
            Object object = mutex;
            synchronized (object) {
                file.getParentFile().mkdirs();
            }
            return file;
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.error("Cannot create file for output of timer: " + file, (Throwable)e);
            return null;
        }
    }

    @Override
    public long getStartOfLoggingPeriod() {
        return this.startOfLoggingPeriod;
    }

    @Override
    public long getEndOfLoggingPeriod() {
        return this.endOfLoggingPeriod;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    @Override
    public void setStartOfLoggingPeriod(long time) {
        this.startOfLoggingPeriod = time;
    }

    @Override
    public void setEndOfLoggingPeriod(long time) {
        this.endOfLoggingPeriod = time;
    }

    @Override
    public void setLoggingEnabled(boolean state) {
        this.loggingEnabled = state;
    }

    public synchronized void resetLoggerFile() {
        this.logger = null;
    }
}

