/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.util.Getter;
import com.xceptance.common.util.SynchronizingCounter;
import com.xceptance.common.util.concurrent.DaemonThreadFactory;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.RequestStack;
import com.xceptance.xlt.engine.XltWebClient;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class RequestQueue {
    private static final int WAIT_TIMEOUT = 300000;
    private final ExecutorService executorService;
    private final SynchronizingCounter ongoingRequestsCount;
    private boolean parallelModeEnabled;
    private final int threadCount;
    private final XltWebClient webClient;

    public RequestQueue(XltWebClient webClient, int threadCount) {
        this.webClient = webClient;
        this.threadCount = threadCount;
        this.parallelModeEnabled = true;
        DaemonThreadFactory threadFactory = new DaemonThreadFactory(new Getter<String>(){

            @Override
            public String get() {
                return Session.getCurrent().getUserID() + "-pool-";
            }
        });
        this.executorService = Executors.newFixedThreadPool(threadCount, threadFactory);
        this.ongoingRequestsCount = new SynchronizingCounter(0);
    }

    public void addRequest(URL url, URL referrerUrl, Charset charset) {
        this.ongoingRequestsCount.increment();
        RequestHandler requestHandler = null;
        if (this.isParallelModeEnabled()) {
            requestHandler = new RequestHandler(url, referrerUrl, RequestStack.getCurrent().clone(), charset);
            this.executorService.execute(requestHandler);
        } else {
            requestHandler = new RequestHandler(url, referrerUrl, RequestStack.getCurrent(), charset);
            requestHandler.run();
        }
    }

    public boolean isParallelModeEnabled() {
        return this.parallelModeEnabled && this.threadCount > 1;
    }

    public void setParallelModeEnabled(boolean value) {
        this.parallelModeEnabled = value;
    }

    public void shutdown() {
        this.executorService.shutdownNow();
    }

    public void waitForCompletion() {
        try {
            this.ongoingRequestsCount.awaitZero(300000L);
            int count = this.ongoingRequestsCount.get();
            if (count != 0) {
                Session.getCurrent().getDataManager().logEvent("Timed out when loading static content", "Outstanding requests: " + count);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class RequestHandler
    implements Runnable {
        private final RequestStack requestStack;
        private final URL url;
        private final URL referrerUrl;
        private final Charset charset;

        public RequestHandler(URL url, URL referrerUrl, RequestStack requestStack, Charset charset) {
            this.url = url;
            this.referrerUrl = referrerUrl;
            this.requestStack = requestStack;
            this.charset = charset;
        }

        @Override
        public void run() {
            RequestStack.setCurrent(this.requestStack);
            try {
                RequestQueue.this.webClient.loadStaticContentFromUrl(this.url, this.referrerUrl, this.charset);
            }
            catch (Exception e) {
                XltLogger.runTimeLogger.error("Failed to load static content from: " + this.url, (Throwable)e);
            }
            finally {
                RequestQueue.this.ongoingRequestsCount.decrement();
            }
        }
    }
}

