/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.io.FileUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.NetworkDataManager;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.SessionShutdownListener;
import com.xceptance.xlt.api.engine.TransactionData;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.DataManagerImpl;
import com.xceptance.xlt.engine.NetworkDataManagerImpl;
import com.xceptance.xlt.engine.TransactionInterruptedException;
import com.xceptance.xlt.engine.WebDriverActionDirector;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.junit.runners.model.MultipleFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionImpl
extends Session {
    private static final String PROP_COLLECT_ADDITIONAL_REQUEST_DATA = "com.xceptance.xlt.results.data.request.collectAdditionalRequestInfo";
    private static final Logger LOG = LoggerFactory.getLogger(SessionImpl.class);
    private static final String RESULT_DIR_PROPERTY = "com.xceptance.xlt.result-dir";
    private static final String UNKNOWN_AGENT_ID = "UnknownAgent";
    private static final String UNKNOWN_USER_NAME = "UnknownUser";
    private static final Map<ThreadGroup, SessionImpl> sessions = new ConcurrentHashMap<ThreadGroup, SessionImpl>(101);
    private static final Timer transactionExpirationTimer;
    private static final long DEFAULT_TRANSACTION_TIMEOUT = 900000L;
    private static final String PROP_MAX_TRANSACTION_TIMEOUT = "com.xceptance.xlt.maximumTransactionRunTime";
    public static final boolean COLLECT_ADDITIONAL_REQUEST_DATA;
    public static final boolean REMOVE_USERINFO_FROM_REQUEST_URL;
    private static final String PROP_REMOVE_USERINFO_FROM_REQUEST_URL = "com.xceptance.xlt.results.data.request.removeUserInfoFromURL";
    private int absoluteUserNumber = 0;
    private String agentID = "UnknownAgent";
    private int agentNumber = 0;
    private final DataManagerImpl dataManagerImpl;
    private boolean failed;
    private Throwable t;
    private String id;
    private boolean loadTest = false;
    private RequestHistory requestHistory;
    private final NetworkDataManagerImpl networkDataManagerImpl;
    private File resultDir;
    private final List<SessionShutdownListener> shutdownListeners;
    private int totalAgentCount = 1;
    private int totalUserCount = 1;
    private int userCount = 1;
    private String userName = "UnknownUser";
    private int userNumber = 0;
    private String actionName;
    private String failedActionName;
    private final NavigableMap<Long, ActionInfo> webDriverActionStartTimes = new TreeMap<Long, ActionInfo>();
    private TimerTask transactionExpirationTimerTask;
    private boolean sessionExpired;
    private boolean transactionExpired;
    private String testCaseClassName;
    private boolean executeThinkTime = false;
    private WebDriverActionDirector actionDirector;
    private ActionInfo actionInfo;
    private Object testInstance;
    private final Map<String, Object> valueLog = new HashMap<String, Object>();
    private TransactionTimer transactionTimer = null;

    public static SessionImpl getCurrent() {
        return SessionImpl.getSessionForThread(Thread.currentThread());
    }

    public static SessionImpl removeCurrent() {
        return sessions.remove(Thread.currentThread().getThreadGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionImpl getSessionForThread(Thread thread) {
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup == null) {
            return null;
        }
        SessionImpl s = sessions.get(threadGroup);
        if (s == null) {
            ThreadGroup threadGroup2 = threadGroup;
            synchronized (threadGroup2) {
                s = sessions.get(threadGroup);
                if (s == null) {
                    s = new SessionImpl();
                    sessions.put(threadGroup, s);
                    s.init();
                }
            }
        }
        return s;
    }

    public SessionImpl() {
        this.id = String.valueOf(GlobalClock.getInstance().getTime());
        this.dataManagerImpl = new DataManagerImpl(this);
        this.shutdownListeners = new ArrayList<SessionShutdownListener>();
        this.networkDataManagerImpl = new NetworkDataManagerImpl();
    }

    private void init() {
        this.requestHistory = new RequestHistory();
    }

    @Override
    public void addShutdownListener(SessionShutdownListener listener) {
        this.shutdownListeners.add(listener);
    }

    @Override
    public void clear() {
        try {
            if (this.actionDirector != null) {
                this.actionDirector.shutdown();
            }
            for (SessionShutdownListener listener : new ArrayList<SessionShutdownListener>(this.shutdownListeners)) {
                listener.shutdown();
            }
            this.requestHistory.dumpToDisk();
        }
        finally {
            this.networkDataManagerImpl.clear();
            this.requestHistory.clear();
            this.shutdownListeners.clear();
            this.failed = false;
            this.t = null;
            this.resultDir = null;
            this.actionDirector = null;
            this.actionName = null;
            this.webDriverActionStartTimes.clear();
            this.executeThinkTime = false;
            this.testInstance = null;
            this.transactionTimer = null;
            this.valueLog.clear();
        }
    }

    @Override
    public int getAbsoluteUserNumber() {
        return this.absoluteUserNumber;
    }

    @Override
    public String getAgentID() {
        return this.agentID;
    }

    @Override
    public int getAgentNumber() {
        return this.agentNumber;
    }

    @Override
    public DataManagerImpl getDataManager() {
        return this.dataManagerImpl;
    }

    @Override
    public String getID() {
        return this.id;
    }

    public RequestHistory getRequestHistory() {
        return this.requestHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public File getResultsDirectory() {
        if (this.resultDir != null) return this.resultDir;
        String resultDirName = "results";
        if (!this.isLoadTest()) {
            String propVal = XltProperties.getInstance().getProperty(RESULT_DIR_PROPERTY, "");
            if (propVal.length() == 0) {
                XltLogger.runTimeLogger.warn("No result dir defined. Will use default result directory 'results'.");
            } else {
                resultDirName = propVal;
            }
        }
        String cleanUserName = FileUtils.replaceIllegalCharsInFileName(this.userName);
        this.resultDir = new File(new File(resultDirName, cleanUserName), String.valueOf(this.userNumber));
        if (this.resultDir.exists()) return this.resultDir;
        Class<SessionImpl> clazz = SessionImpl.class;
        synchronized (SessionImpl.class) {
            this.resultDir.mkdirs();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.resultDir;
        }
    }

    public String getTestCaseClassName() {
        return this.testCaseClassName;
    }

    @Override
    public int getTotalAgentCount() {
        return this.totalAgentCount;
    }

    @Override
    public int getTotalUserCount() {
        return this.totalUserCount;
    }

    @Override
    public int getUserCount() {
        return this.userCount;
    }

    @Override
    public String getUserID() {
        return this.userName + "-" + this.userNumber;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public int getUserNumber() {
        return this.userNumber;
    }

    @Override
    @Deprecated
    public String getWebDriverActionName() {
        return this.getCurrentActionName();
    }

    @Override
    public boolean hasFailed() {
        return this.failed;
    }

    public void setFailReason(Throwable t) {
        this.t = t;
    }

    public Throwable getFailReason() {
        return this.t;
    }

    @Override
    public boolean isLoadTest() {
        return this.loadTest;
    }

    @Override
    public void removeShutdownListener(SessionShutdownListener listener) {
        this.shutdownListeners.remove(listener);
    }

    public void setAbsoluteUserNumber(int number) {
        this.absoluteUserNumber = number;
    }

    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    public void setAgentNumber(int agentNumber) {
        this.agentNumber = agentNumber;
    }

    @Override
    public void setFailed(boolean value) {
        this.failed = value;
        if (this.failed) {
            this.setFailedActionName();
        }
    }

    @Override
    public void setID(String id) {
        this.id = id;
    }

    public void setLoadTest(boolean loadTest) {
        this.loadTest = loadTest;
    }

    public void setTestCaseClassName(String className) {
        this.testCaseClassName = className;
    }

    public void setTotalAgentCount(int totalAgentCount) {
        this.totalAgentCount = totalAgentCount;
    }

    public void setTotalUserCount(int count) {
        this.totalUserCount = count;
    }

    public void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public void setUserName(String userName) {
        if (!this.userName.equals(userName)) {
            this.userName = userName;
            this.resultDir = null;
            this.dataManagerImpl.resetLoggerFile();
        }
    }

    public void setUserNameIfNotSet(String userName) {
        if (this.userName.equals(UNKNOWN_USER_NAME)) {
            this.setUserName(userName);
        }
    }

    public void setUserNumber(int userNumber) {
        this.userNumber = userNumber;
    }

    @Override
    public NetworkDataManager getNetworkDataManager() {
        return this.networkDataManagerImpl;
    }

    @Override
    @Deprecated
    public void setWebDriverActionName(String webDriverActionName) {
        this.startAction(webDriverActionName);
    }

    public void setWebDriverActionDirector(WebDriverActionDirector director) {
        this.actionDirector = director;
    }

    public WebDriverActionDirector getWebDriverActionDirector() {
        return this.actionDirector;
    }

    public void transactionStarted() {
        if (transactionExpirationTimer != null) {
            final long transactionTimeout = XltProperties.getInstance().getProperty(PROP_MAX_TRANSACTION_TIMEOUT, 900000L);
            this.transactionExpirationTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(String.format("User '%s' exceeds maximum permitted run time of %,d ms. Will mark it as expired.", SessionImpl.this.getUserID(), transactionTimeout));
                    }
                    SessionImpl.this.transactionExpired = true;
                }
            };
            this.transactionExpired = false;
            transactionExpirationTimer.schedule(this.transactionExpirationTimerTask, transactionTimeout);
        }
        this.startTransaction();
    }

    public void transactionFinished() {
        if (transactionExpirationTimer != null && this.transactionExpirationTimerTask != null) {
            this.transactionExpirationTimerTask.cancel();
        }
        this.stopTransaction();
    }

    public boolean wasMarkedAsExpired() {
        return this.sessionExpired;
    }

    public void markAsExpired() {
        this.sessionExpired = true;
    }

    public void checkState() throws TransactionInterruptedException {
        if (this.sessionExpired) {
            throw new TransactionInterruptedException("Load test has finished");
        }
        if (this.transactionExpired) {
            throw new TransactionInterruptedException("Transaction exceeded the run time limit");
        }
    }

    public NavigableMap<Long, ActionInfo> getWebDriverActionStartTimes() {
        return this.webDriverActionStartTimes;
    }

    @Override
    public String getCurrentActionName() {
        return this.actionName;
    }

    public void setCurrentActionName(String actionName) {
        this.actionName = actionName;
    }

    public ActionInfo getCurrentActionInfo() {
        return this.actionInfo;
    }

    @Override
    public void startAction(String actionName) {
        this.checkState();
        ParameterCheckUtils.isNotNullOrEmpty(actionName, "actionName");
        if (this.actionDirector == null) {
            this.actionDirector = new WebDriverActionDirector();
        }
        this.actionDirector.startNewAction(actionName);
        this.actionName = actionName;
        this.actionInfo = new ActionInfo();
        this.actionInfo.name = actionName;
        this.webDriverActionStartTimes.put(GlobalClock.getInstance().getTime(), this.actionInfo);
    }

    @Override
    public void stopAction() {
        this.checkState();
        if (this.actionDirector != null) {
            this.actionDirector.finishCurrentAction();
        }
        this.actionName = null;
    }

    public String getFailedActionName() {
        return this.failedActionName;
    }

    private void setFailedActionName() {
        if (this.failedActionName == null) {
            this.failedActionName = StringUtils.defaultString((String)this.actionName, (String)"");
        }
    }

    public void clearFailedActionName() {
        this.failedActionName = null;
    }

    public boolean isExecuteThinkTime() {
        return this.executeThinkTime;
    }

    public void setExecuteThinkTime(boolean executeThinkTime) {
        this.executeThinkTime = executeThinkTime;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public void setTestInstance(Object instance) {
        this.testInstance = instance;
    }

    @Override
    public Map<String, Object> getValueLog() {
        return this.valueLog;
    }

    public void startTransaction() {
        this.setFailed(false);
        this.setFailReason(null);
        this.clearFailedActionName();
        this.transactionTimer = new TransactionTimer();
    }

    public boolean isTransactionPending() {
        return this.transactionTimer != null;
    }

    public void stopTransaction() throws RuntimeException {
        if (this.isTransactionPending()) {
            TransactionData transactionData = new TransactionData(this.getUserName());
            transactionData.setRunTime(this.transactionTimer.getRuntime());
            transactionData.setTime(this.transactionTimer.getStartTime());
            transactionData.setFailed(this.hasFailed());
            transactionData.setFailureStackTrace(SessionImpl.extractFirstFailure(this.getFailReason()));
            transactionData.setFailedActionName(this.getFailedActionName());
            if (this.hasFailed()) {
                transactionData.setTestUserNumber(String.valueOf(this.getUserNumber()));
                transactionData.setDirectoryName(this.getID());
            }
            this.transactionTimer = null;
            if (!this.wasMarkedAsExpired()) {
                this.dataManagerImpl.logDataRecord(transactionData);
            }
        }
    }

    private static Throwable extractFirstFailure(Throwable throwable) {
        if (throwable instanceof MultipleFailureException) {
            return (Throwable)((MultipleFailureException)throwable).getFailures().get(0);
        }
        return throwable;
    }

    static {
        XltProperties props = XltProperties.getInstance();
        transactionExpirationTimer = props.getProperty("com.xceptance.xlt.abortLongRunningTransactions", false) ? new Timer("TransactionExpirationTimer", true) : null;
        COLLECT_ADDITIONAL_REQUEST_DATA = props.getProperty(PROP_COLLECT_ADDITIONAL_REQUEST_DATA, false);
        REMOVE_USERINFO_FROM_REQUEST_URL = props.getProperty(PROP_REMOVE_USERINFO_FROM_REQUEST_URL, true);
    }

    public static class TransactionTimer {
        private final long globalStartTime = GlobalClock.getInstance().getTime();
        private final long localStartTime = TimerUtils.getTime();

        public long getStartTime() {
            return this.globalStartTime;
        }

        public long getRuntime() {
            return TimerUtils.getTime() - this.localStartTime;
        }
    }
}

