/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.api.engine.ActionData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.engine.scripting.AbstractWebDriverScriptTestCase;
import com.xceptance.xlt.api.tests.AbstractWebDriverTestCase;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.api.webdriver.XltChromeDriver;
import com.xceptance.xlt.api.webdriver.XltFirefoxDriver;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverActionDirector {
    private static final Logger LOG = LoggerFactory.getLogger(WebDriverActionDirector.class);
    private static final String THINKTIME_PROPERTY = "com.xceptance.xlt.thinktime.action";
    private static final String THINKTIMEDEVIATION_PROPERTY = "com.xceptance.xlt.thinktime.action.deviation";
    private static final byte[] dummyScreenshot = WebDriverActionDirector.loadDummyScreenshot();
    private final int thinkTime = XltProperties.getInstance().getProperty("com.xceptance.xlt.thinktime.action", 0);
    private final int thinkTimeDeviation = XltProperties.getInstance().getProperty("com.xceptance.xlt.thinktime.action.deviation", 0);
    private ActionData actionData;
    private long actionStartTime;
    private boolean isFirstAction = true;
    private WeakReference<WebDriver> webDriver;

    public void finishCurrentAction() {
        if (this.actionData != null) {
            this.doWaitForPageLoad();
            Session session = Session.getCurrent();
            this.actionData.setRunTime(TimerUtils.getTime() - this.actionStartTime);
            this.actionData.setFailed(session.hasFailed());
            session.getDataManager().logDataRecord(this.actionData);
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info(String.format("### Action '%s' finished after %d ms", this.actionData.getName(), this.actionData.getRunTime()));
            }
            this.takeScreenshot();
            this.actionData = null;
        }
    }

    public void startNewAction(String timerName) {
        this.finishCurrentAction();
        if (this.isFirstAction) {
            this.isFirstAction = false;
        } else {
            this.doThink();
        }
        this.actionData = new ActionData(timerName);
        this.actionStartTime = TimerUtils.getTime();
        this.setTimerName(timerName);
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            XltLogger.runTimeLogger.info(String.format("### Action '%s' started", timerName));
        }
    }

    public void shutdown() {
        if (!SessionImpl.getCurrent().wasMarkedAsExpired()) {
            this.finishCurrentAction();
            this.preQuit();
        }
    }

    protected void preQuit() {
        if (this.webDriver != null) {
            WebDriver wd = (WebDriver)this.webDriver.get();
            while (wd instanceof WrapsDriver) {
                wd = ((WrapsDriver)wd).getWrappedDriver();
            }
            if (wd instanceof XltChromeDriver || wd instanceof XltFirefoxDriver) {
                ReflectionUtils.callMethod(wd, "preQuit", new Object[0]);
            }
        }
    }

    protected void doThink() {
        long resultingThinkTime = Math.max(0, XltRandom.nextIntWithDeviation(this.thinkTime, this.thinkTimeDeviation));
        if (resultingThinkTime > 0L) {
            if (XltLogger.runTimeLogger.isInfoEnabled()) {
                XltLogger.runTimeLogger.info("Executing action think time wait (" + resultingThinkTime + " ms)...");
            }
            try {
                Thread.sleep(resultingThinkTime);
            }
            catch (InterruptedException ie) {
                throw new XltException("Sleep interrupted", ie);
            }
        }
    }

    protected void takeScreenshot() {
        if (this.webDriver == null) {
            this.webDriver = new WeakReference<WebDriver>(WebDriverActionDirector.getDriver());
        }
        WebDriver wd = (WebDriver)this.webDriver.get();
        RequestHistory requestHistory = SessionImpl.getCurrent().getRequestHistory();
        if (wd != null && requestHistory.getDumpMode() != RequestHistory.DumpMode.NEVER) {
            byte[] bytes = dummyScreenshot;
            if (wd instanceof TakesScreenshot) {
                try {
                    bytes = (byte[])((TakesScreenshot)wd).getScreenshotAs(OutputType.BYTES);
                }
                catch (Exception e) {
                    LOG.error("Failed to create screenshot", (Throwable)e);
                }
            }
            requestHistory.add(SessionImpl.getCurrent().getCurrentActionInfo(), bytes);
        }
    }

    protected void doWaitForPageLoad() {
    }

    protected void setTimerName(String timerName) {
    }

    private static WebDriver getDriver() {
        Object instance = SessionImpl.getCurrent().getTestInstance();
        try {
            if (instance instanceof AbstractWebDriverTestCase) {
                return ((AbstractWebDriverTestCase)instance).getWebDriver();
            }
            if (instance instanceof AbstractWebDriverScriptTestCase) {
                return (WebDriver)ReflectionUtils.callMethod(AbstractWebDriverScriptTestCase.class, instance, "getWebDriver", new Object[0]);
            }
        }
        catch (Throwable t) {
            LOG.error("Failed to obtain webdriver", t);
        }
        return null;
    }

    private static synchronized byte[] loadDummyScreenshot() {
        try {
            URL resourceUrl = WebDriverActionDirector.class.getResource("DummyScreenshot.png");
            return IOUtils.toByteArray((URL)resourceUrl);
        }
        catch (IOException | NullPointerException e) {
            LOG.error("Failed to load dummy screenshot", (Throwable)e);
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }
}

