/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.httprequest;

import com.gargoylesoftware.htmlunit.FormEncodingType;
import com.gargoylesoftware.htmlunit.HttpMethod;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import com.gargoylesoftware.htmlunit.util.UrlUtils;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.httprequest.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(HttpRequest.class);
    private static final ThreadLocal<WebClient> WEB_CLIENT = new ThreadLocal<WebClient>(){

        @Override
        protected WebClient initialValue() {
            Session.getCurrent().addShutdownListener(() -> WEB_CLIENT.remove());
            return new XltWebClient();
        }
    };
    protected String timerName;
    protected String baseUrl;
    protected String relativeUrl;
    protected Charset contentCharset;
    protected FormEncodingType encodingType;
    protected HttpMethod httpMethod;
    protected final Map<String, String> headers = new HashMap<String, String>();
    protected final List<NameValuePair> parameters = new LinkedList<NameValuePair>();
    protected String body;
    protected byte[] bytesBody;
    protected boolean cachingEnabled;

    public static WebClient getDefaultWebClient() {
        return WEB_CLIENT.get();
    }

    public static void setDefaultWebClient(WebClient webClient) {
        WEB_CLIENT.set(webClient);
    }

    public HttpRequest() {
    }

    public HttpRequest(String timerName) {
        this.timerName = timerName;
    }

    public HttpRequest(HttpRequest other) {
        this.timerName = other.timerName;
        this.baseUrl = other.baseUrl;
        this.relativeUrl = other.relativeUrl;
        this.contentCharset = other.contentCharset;
        this.encodingType = other.encodingType;
        this.httpMethod = other.httpMethod;
        this.headers.putAll(other.headers);
        this.parameters.addAll(other.parameters);
        this.body = other.body;
        this.cachingEnabled = other.cachingEnabled;
    }

    public HttpRequest timerName(String timerName) {
        this.timerName = timerName;
        return this;
    }

    public HttpRequest baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public HttpRequest relativeUrl(String relativeUrl) {
        this.relativeUrl = relativeUrl;
        return this;
    }

    public HttpRequest method(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public HttpRequest charset(Charset contentCharset) {
        this.contentCharset = contentCharset;
        return this;
    }

    public HttpRequest encodingType(FormEncodingType encodingType) {
        this.encodingType = encodingType;
        return this;
    }

    public HttpRequest header(String name, String value) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Header name must not be blank.");
        }
        if (value == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header value 'null' was converted into empty string for header name " + name);
            }
            value = "";
        }
        this.headers.put(name, value);
        return this;
    }

    public HttpRequest headers(List<NameValuePair> additionalHeaders) {
        additionalHeaders.stream().forEach(p -> this.header(p.getName(), p.getValue()));
        return this;
    }

    public HttpRequest headers(Map<String, String> additionalHeaders) {
        additionalHeaders.forEach((n, v) -> this.header((String)n, (String)v));
        return this;
    }

    public HttpRequest removeHeader(String name) {
        this.headers.remove(name);
        return this;
    }

    public HttpRequest removeHeaders(List<String> headerNames) {
        headerNames.forEach(n -> this.removeHeader((String)n));
        return this;
    }

    public HttpRequest removeHeaders() {
        this.headers.clear();
        return this;
    }

    public HttpRequest param(String name, String value) {
        return this.param(new NameValuePair(name, value));
    }

    public HttpRequest param(NameValuePair nameValuePair) {
        String name = nameValuePair.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Name of parameter must not be blank.");
        }
        if (nameValuePair.getClass() == NameValuePair.class && nameValuePair.getValue() == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Value of parameter '" + name + "' was converted from 'null' to an empty string");
            }
            nameValuePair = new NameValuePair(name, "");
        }
        this.parameters.add(nameValuePair);
        return this;
    }

    public HttpRequest params(List<NameValuePair> params) {
        params.forEach(this::param);
        return this;
    }

    public HttpRequest params(Map<String, String> params) {
        params.forEach((n, v) -> this.param((String)n, (String)v));
        return this;
    }

    public HttpRequest removeParam(String name) {
        this.parameters.removeIf(p -> p.getName().equals(name));
        return this;
    }

    public HttpRequest removeParams(List<String> paramNames) {
        paramNames.forEach(n -> this.removeParam((String)n));
        return this;
    }

    public HttpRequest removeParams() {
        this.parameters.clear();
        return this;
    }

    public HttpRequest body(String body) {
        this.body = body;
        this.bytesBody = null;
        return this;
    }

    public HttpRequest body(byte[] bytes) {
        this.bytesBody = bytes;
        this.body = null;
        return this;
    }

    public HttpRequest body(File file) throws IOException {
        byte[] bytes = FileUtils.readFileToByteArray((File)file);
        return this.body(bytes);
    }

    public HttpRequest body(InputStream inputStream) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        return this.body(bytes);
    }

    public HttpRequest caching(boolean cachingEnabled) {
        this.cachingEnabled = cachingEnabled;
        return this;
    }

    public HttpResponse fire() throws IOException, URISyntaxException {
        return this.fire(HttpRequest.getDefaultWebClient());
    }

    public HttpResponse fire(WebClient webClient) throws IOException, URISyntaxException {
        if (webClient == null) {
            throw new IllegalArgumentException("Can not utilize invalid web client.");
        }
        if (StringUtils.isNotBlank((CharSequence)this.timerName) && webClient instanceof XltWebClient) {
            ((XltWebClient)webClient).setTimerName(this.timerName.trim());
        }
        WebRequest webRequest = this.buildWebRequest();
        WebResponse webResponse = webClient.loadWebResponse(webRequest);
        return new HttpResponse(webResponse);
    }

    public HttpRequest clone() {
        return new HttpRequest(this);
    }

    protected WebRequest buildWebRequest() throws MalformedURLException, URISyntaxException {
        boolean methodSupportsBody = this.httpMethod == HttpMethod.POST || this.httpMethod == HttpMethod.PUT || this.httpMethod == HttpMethod.PATCH || this.httpMethod == HttpMethod.DELETE;
        Assert.assertTrue((String)"Base URL must not be null or blank", (boolean)StringUtils.isNotBlank((CharSequence)this.baseUrl));
        Assert.assertTrue((String)"Can not use request parameters in conjunction with request body in POST, PUT, PATCH, or DELETE requests", (!methodSupportsBody || this.body == null && this.bytesBody == null || this.parameters.isEmpty() ? 1 : 0) != 0);
        URL url = StringUtils.isBlank((CharSequence)this.relativeUrl) ? new URL(this.baseUrl) : new URL(UrlUtils.resolveUrl(this.baseUrl, this.relativeUrl));
        WebRequest webRequest = new WebRequest(url);
        if (this.httpMethod != null) {
            webRequest.setHttpMethod(this.httpMethod);
        }
        if (this.contentCharset != null) {
            webRequest.setCharset(this.contentCharset);
        }
        if (methodSupportsBody && this.encodingType != null) {
            webRequest.setEncodingType(this.encodingType);
        }
        if (!this.headers.isEmpty()) {
            webRequest.setAdditionalHeaders(this.headers);
        }
        this.handleParameters(webRequest, this.parameters, methodSupportsBody);
        if (methodSupportsBody) {
            if (this.body != null) {
                webRequest.setRequestBody(this.body);
            } else if (this.bytesBody != null) {
                String bytesAsString = new String(this.bytesBody, StandardCharsets.ISO_8859_1);
                webRequest.setRequestBody(bytesAsString);
                webRequest.setCharset(StandardCharsets.ISO_8859_1);
            }
        }
        if (!this.cachingEnabled) {
            webRequest.setDocumentRequest();
        }
        return webRequest;
    }

    private void handleParameters(WebRequest webRequest, List<NameValuePair> parameters, boolean methodSupportsBody) throws URISyntaxException, MalformedURLException {
        if (!parameters.isEmpty()) {
            if (methodSupportsBody) {
                if (StringUtils.isNotEmpty((CharSequence)webRequest.getUrl().getQuery())) {
                    this.adjustUrl(webRequest, parameters, false);
                }
                webRequest.setRequestParameters(parameters);
            } else {
                this.adjustUrl(webRequest, parameters, true);
            }
        }
    }

    private void adjustUrl(WebRequest webRequest, List<NameValuePair> parameters, boolean addParameters) throws MalformedURLException, URISyntaxException {
        URL url = webRequest.getUrl();
        URIBuilder uriBuilder = new URIBuilder(url.toURI());
        List urlParameters = uriBuilder.getQueryParams();
        parameters.forEach(p -> urlParameters.removeIf(u -> u.getName().equals(p.getName())));
        uriBuilder.setParameters(urlParameters);
        if (addParameters) {
            parameters.forEach(p -> uriBuilder.addParameter(p.getName(), p.getValue()));
        }
        webRequest.setUrl(new URL(uriBuilder.toString()));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }
}

