/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.htmlunit;

import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.DomText;
import com.gargoylesoftware.htmlunit.html.HtmlAnchor;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlOptionGroup;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlPreformattedText;
import com.gargoylesoftware.htmlunit.javascript.host.ClientRect;
import com.gargoylesoftware.htmlunit.javascript.host.Element;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.css.StyleAttributes;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.w3c.dom.NodeList;

public final class HtmlUnitElementUtils {
    private static final String[] BLOCK_LEVEL_TAG_NAMES = new String[]{"p", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "div", "noscript", "blockquote", "form", "hr", "table", "fieldset", "address", "ul", "ol", "pre", "br", "td", "th"};
    private static final char[] NON_BREAKING_SPACES = new char[]{'\u00a0', '\u2007', '\u202f'};

    private HtmlUnitElementUtils() {
    }

    public static boolean isVisible(DomElement element) {
        if (element instanceof HtmlOption || element instanceof HtmlOptionGroup) {
            HtmlElement select = (HtmlElement)element.getFirstByXPath("./ancestor-or-self::select");
            return select != null && HtmlUnitElementUtils.isVisible(select);
        }
        if (element instanceof HtmlAnchor && element.getChildElementCount() == 0 && StringUtils.isBlank((CharSequence)HtmlUnitElementUtils.collapseWhitespace(element.getTextContent(), true))) {
            return false;
        }
        try {
            Context.enter();
            if (!element.isDisplayed() || !HtmlUnitElementUtils.consumesSpace(element)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = !HtmlUnitElementUtils.isOverflowHidden(element);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    private static boolean consumesSpace(DomElement element) {
        ClientRect rectum = ((HTMLElement)element.getScriptableObject()).getBoundingClientRect();
        if (rectum.getWidth() > 0 && rectum.getHeight() > 0) {
            return true;
        }
        if (!"hidden".equals(HtmlUnitElementUtils.getOverflow(element))) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                DomNode n = (DomNode)children.get(i);
                if (n.getNodeType() != 3 && (n.getNodeType() != 1 || !HtmlUnitElementUtils.consumesSpace((HtmlElement)n))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isOverflowHidden(DomElement element) {
        if ("hidden".equals(HtmlUnitElementUtils.getOverFlowState(element))) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                DomNode n = (DomNode)children.get(i);
                if (n.getNodeType() != 1 || HtmlUnitElementUtils.isOverflowHidden((HtmlElement)n)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getOverFlowState(DomElement element) {
        HtmlPage page = (HtmlPage)element.getPage();
        String overflow = page != null ? HtmlUnitElementUtils.getOverflow(page.getDocumentElement()) : "visible";
        HtmlElement l = HtmlUnitElementUtils.c(element);
        while (l != null) {
            ClientRect box;
            String[] q = HtmlUnitElementUtils._getVisibility(l, overflow);
            if (!("visible".equals(q[0]) && "visible".equals(q[1]) || (box = ((HTMLElement)l.getScriptableObject()).getBoundingClientRect()).getWidth() != 0 && box.getHeight() != 0)) {
                return "hidden";
            }
            l = HtmlUnitElementUtils.c(l);
        }
        return "none";
    }

    private static String[] _getVisibility(HtmlElement l, String overflow) {
        HtmlPage page = (HtmlPage)l.getPage();
        HtmlElement body = page != null ? page.getBody() : null;
        HtmlElement b = l;
        if ("visible".equals(overflow) && page != null) {
            if (l == page.getDocumentElement()) {
                b = body;
            } else if (l == body) {
                return new String[]{"visible", "visible"};
            }
        }
        if ("hidden".equals(HtmlUnitElementUtils.getOverflow(b))) {
            return new String[]{"hidden", "hidden"};
        }
        String[] r = new String[]{HtmlUnitElementUtils.getOverflowX(b), HtmlUnitElementUtils.getOverflowY(b)};
        if (l == page.getDocumentElement()) {
            if ("visible".equals(r[0])) {
                r[0] = "auto";
            }
            if ("visible".equals(r[1])) {
                r[1] = "auto";
            }
        }
        return r;
    }

    private static String getDisplay(HtmlElement element) {
        HTMLElement e = (HTMLElement)element.getScriptableObject();
        String value = e.getWindow().getComputedStyle(e, null).getDisplay();
        if ("inherit".equals(value)) {
            value = HtmlUnitElementUtils.getDisplay(HtmlUnitElementUtils.getParentElement(element));
        }
        return value;
    }

    private static String getCssPosition(DomElement element) {
        HTMLElement e = (HTMLElement)element.getScriptableObject();
        String value = e.getWindow().getComputedStyle(e, null).getStyleAttribute(StyleAttributes.Definition.POSITION);
        if ("inherit".equals(value)) {
            value = HtmlUnitElementUtils.getCssPosition(HtmlUnitElementUtils.getParentElement(element));
        }
        return value;
    }

    private static String getOverflow(DomElement element) {
        HTMLElement e = (HTMLElement)element.getScriptableObject();
        String value = e.getWindow().getComputedStyle(e, null).getStyleAttribute(StyleAttributes.Definition.OVERFLOW);
        if ("inherit".equals(value)) {
            value = HtmlUnitElementUtils.getCssPosition(HtmlUnitElementUtils.getParentElement(element));
        }
        return value;
    }

    private static String getOverflowX(DomElement element) {
        HTMLElement e = (HTMLElement)element.getScriptableObject();
        String value = e.getWindow().getComputedStyle(e, null).getStyleAttribute(StyleAttributes.Definition.OVERFLOW_X);
        if ("inherit".equals(value)) {
            value = HtmlUnitElementUtils.getCssPosition(HtmlUnitElementUtils.getParentElement(element));
        }
        return value;
    }

    private static String getOverflowY(DomElement element) {
        HTMLElement e = (HTMLElement)element.getScriptableObject();
        String value = e.getWindow().getComputedStyle(e, null).getStyleAttribute(StyleAttributes.Definition.OVERFLOW_Y);
        if ("inherit".equals(value)) {
            value = HtmlUnitElementUtils.getCssPosition(HtmlUnitElementUtils.getParentElement(element));
        }
        return value;
    }

    private static HtmlElement c(DomElement element) {
        String pos = HtmlUnitElementUtils.getCssPosition(element);
        HtmlElement docElement = (HtmlElement)element.getPage().getDocumentElement();
        if ("fixed".equals(pos)) {
            return element == docElement ? null : docElement;
        }
        boolean posAbsolute = "absolute".equals(pos);
        HtmlElement e = HtmlUnitElementUtils.getParentElement(element);
        while (e != null && !HtmlUnitElementUtils.b(e, posAbsolute)) {
            e = HtmlUnitElementUtils.getParentElement(e);
        }
        return e;
    }

    private static boolean b(HtmlElement e, boolean posIsAbsolute) {
        HtmlElement docElement;
        HtmlPage page = (HtmlPage)e.getPage();
        HtmlElement htmlElement = docElement = page != null ? page.getDocumentElement() : null;
        if (e == docElement) {
            return true;
        }
        String display = HtmlUnitElementUtils.getDisplay(e);
        return (display == null || !display.startsWith("inline")) && (!posIsAbsolute || !"static".equals(HtmlUnitElementUtils.getCssPosition(e)));
    }

    private static HtmlElement getParentElement(DomElement element) {
        DomNode node;
        for (node = element.getParentNode(); node != null && node.getNodeType() != 1; node = node.getParentNode()) {
        }
        return node != null ? (HtmlElement)node : null;
    }

    public static final String computeText(DomElement element) {
        return HtmlUnitElementUtils.getTextFromNode(element, element instanceof HtmlPreformattedText).trim();
    }

    public static boolean isBlockLevelElement(HtmlElement element) {
        String tagName = element.getTagName().toLowerCase();
        for (String blockLevelsTagName : BLOCK_LEVEL_TAG_NAMES) {
            if (!blockLevelsTagName.equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public static String collapseWhitespace(String text) {
        return HtmlUnitElementUtils.collapseWhitespace(text, false);
    }

    public static String collapseWhitespace(String text, boolean retainNonBreakingSpace) {
        String s = text;
        s = s.replace("\r", "");
        if (!retainNonBreakingSpace) {
            s = HtmlUnitElementUtils.replaceNonBreakingSpaces(s);
        }
        s = s.replaceAll("\\p{javaWhitespace}+", " ");
        return s;
    }

    public static String getTextTransform(Window window, Element element) {
        String textTransform = "none";
        if (window != null && element != null && "inherit".equals(textTransform = window.getComputedStyle(element, null).getStyleAttribute(StyleAttributes.Definition.TEXT_TRANSFORM))) {
            textTransform = HtmlUnitElementUtils.getTextTransform(window, element.getParentElement());
        }
        return textTransform;
    }

    private static String getTextFromNode(DomNode node, boolean preformatted) {
        switch (node.getNodeType()) {
            case 3: {
                String data = HtmlUnitElementUtils.getTextFromTextNode((DomText)node);
                if (!preformatted) {
                    return HtmlUnitElementUtils.collapseWhitespace(data);
                }
                return HtmlUnitElementUtils.replaceNonBreakingSpaces(data);
            }
            case 1: {
                if (!node.isDisplayed()) {
                    return "";
                }
                StringBuilder text = new StringBuilder();
                if (HtmlUnitElementUtils.isBlockLevelElement((HtmlElement)node)) {
                    text.append('\n');
                }
                boolean childrenPreformatted = preformatted || node instanceof HtmlPreformattedText;
                for (DomNode child : node.getChildren()) {
                    text.append(HtmlUnitElementUtils.getTextFromNode(child, childrenPreformatted));
                }
                return text.toString();
            }
        }
        return "";
    }

    private static String getTextFromTextNode(DomText textNode) {
        String text = textNode.getNodeValue();
        HtmlElement parent = (HtmlElement)textNode.getParentNode();
        Window w = (Window)parent.getPage().getEnclosingWindow().getScriptableObject();
        String textTransform = HtmlUnitElementUtils.getTextTransform(w, (Element)parent.getScriptableObject());
        if ("lowercase".equals(textTransform)) {
            text = text.toLowerCase();
        } else if ("uppercase".equals(textTransform)) {
            text = text.toUpperCase();
        } else if ("capitalize".equals(textTransform)) {
            text = WordUtils.capitalize((String)text);
        }
        return text;
    }

    private static String replaceNonBreakingSpaces(String text) {
        String s = text;
        for (char c : NON_BREAKING_SPACES) {
            s = s.replace(c, ' ');
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getPosition(DomElement element) {
        HTMLElement scriptable = (HTMLElement)element.getScriptableObject();
        HtmlElement body = ((HtmlPage)element.getPage()).getBody();
        try {
            int clientLeft;
            Context.enter();
            if (element.equals(body)) {
                int[] nArray = new int[]{scriptable.getOffsetLeft(), scriptable.getOffsetTop()};
                return nArray;
            }
            ClientRect rectum = scriptable.getBoundingClientRect();
            Document doc = (Document)scriptable.getOwnerDocument();
            HTMLElement docElement = (HTMLElement)doc.getDocumentElement();
            HTMLElement bodyElement = (HTMLElement)body.getScriptableObject();
            int clientTop = docElement.getClientTop();
            if (clientTop == 0) {
                clientTop = bodyElement.getClientTop();
            }
            if ((clientLeft = docElement.getClientLeft()) == 0) {
                clientLeft = bodyElement.getClientLeft();
            }
            int[] nArray = new int[]{rectum.getLeft() - clientLeft, rectum.getTop() - clientTop};
            return nArray;
        }
        finally {
            Context.exit();
        }
    }

    public static HtmlPage fireMouseEvent(DomElement element, String eventType, boolean isCtrlPressed, boolean isShiftPressed, boolean isAltPressed, int button, int xOffset, int yOffset) {
        ScriptResult result;
        HtmlPage page = (HtmlPage)element.getPage();
        if (element instanceof DisabledElement && ((DisabledElement)((Object)element)).isDisabled()) {
            return page;
        }
        MouseEvent event = new MouseEvent(element, eventType, isShiftPressed, isCtrlPressed, isAltPressed, button);
        if (xOffset > -1 || yOffset > -1) {
            int[] position = HtmlUnitElementUtils.getPosition(element);
            if (xOffset > -1) {
                event.setClientX(position[0] + xOffset);
            }
            if (yOffset > -1) {
                event.setClientY(position[1] + yOffset);
            }
        }
        if ((result = element.fireEvent(event)) != null) {
            page = (HtmlPage)page.getWebClient().getCurrentWindow().getEnclosedPage();
        }
        return page;
    }

    public static HtmlPage fireMouseEvent(DomElement element, String eventType, int xOffset, int yOffset) {
        return HtmlUnitElementUtils.fireMouseEvent(element, eventType, false, false, false, 0, xOffset, yOffset);
    }

    public static HtmlPage fireMouseEvent(DomElement element, String eventType, int xOffset, int yOffset, int mouseButton) {
        return HtmlUnitElementUtils.fireMouseEvent(element, eventType, false, false, false, mouseButton, xOffset, yOffset);
    }
}

