/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.xlt.engine.scripting.webdriver.ElementFinder;
import com.xceptance.xlt.engine.scripting.webdriver.OptionFinder;
import com.xceptance.xlt.engine.scripting.webdriver.WindowFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

final class WebDriverFinder {
    static final Pattern STRATEGY_PATTERN = Pattern.compile("^(\\p{Alpha}+)=(.*)");
    private final ElementFinder finder = new ElementFinder(false);
    private final OptionFinder optionFinder = new OptionFinder();
    private final ElementFinder visibleFinder = new ElementFinder(true);
    private final WindowFinder windowFinder = new WindowFinder();

    WebDriverFinder() {
    }

    public WebElement findElement(WebDriver webDriver, String locator) {
        return this.findElement(webDriver, locator, false);
    }

    public WebElement findElement(WebDriver webDriver, String locator, boolean visibleElementsOnly) {
        return this.getFinder(visibleElementsOnly).find(webDriver, locator);
    }

    public WebElement findOption(WebElement select, String optionLocator) {
        return this.optionFinder.findOption(select, optionLocator);
    }

    public List<WebElement> findOptions(WebElement select, String optionLocator) {
        return this.optionFinder.findOptions(select, optionLocator);
    }

    public String findWindow(WebDriver webDriver, String windowLocator, boolean switchBack) {
        return this.windowFinder.find(webDriver, windowLocator, switchBack);
    }

    public String findWindow(WebDriver webDriver, String windowLocator) {
        return this.windowFinder.find(webDriver, windowLocator, true);
    }

    public boolean isElementPresent(WebDriver webDriver, String locator) {
        try {
            this.findElement(webDriver, locator, false);
        }
        catch (InvalidSelectorException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    private ElementFinder getFinder(boolean visibleElementsOnly) {
        return visibleElementsOnly ? this.visibleFinder : this.finder;
    }

    public List<WebElement> findElements(WebDriver webDriver, String elementLocator) {
        return this.findElements(webDriver, elementLocator, false);
    }

    public List<WebElement> findElements(WebDriver webDriver, String elementLocator, boolean visibleElementsOnly) {
        return this.getFinder(visibleElementsOnly).findAll(webDriver, elementLocator);
    }
}

