/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.socket;

import com.xceptance.xlt.engine.socket.SocketStatistics;
import com.xceptance.xlt.engine.util.TimerUtils;

public class SocketMonitor {
    private int bytesReceived;
    private int bytesSent;
    private long connectEndTime;
    private long connectStartTime;
    private long dnsLookupEndTime;
    private long dnsLookupStartTime;
    private long firstBytesReceivedTime;
    private long firstBytesSentTime;
    private long lastBytesReceivedTime;
    private long lastBytesSentTime;

    public void connected() {
        this.connectEndTime = TimerUtils.getTime();
    }

    public void connectingStarted() {
        this.connectStartTime = this.connectEndTime = TimerUtils.getTime();
    }

    public void dnsLookupDone() {
        this.dnsLookupEndTime = TimerUtils.getTime();
    }

    public void dnsLookupStarted() {
        this.dnsLookupStartTime = this.dnsLookupEndTime = TimerUtils.getTime();
    }

    public SocketStatistics getSocketStatistics() {
        int timeToFirst;
        int timeToLast;
        int dnsLookupTime = (int)(this.dnsLookupEndTime - this.dnsLookupStartTime);
        int connectTime = (int)(this.connectEndTime - this.connectStartTime);
        int sendTime = (int)(this.lastBytesSentTime - this.firstBytesSentTime);
        int receiveTime = (int)(this.lastBytesReceivedTime - this.firstBytesReceivedTime);
        long referenceTime = SocketMonitor.getMaxTime(this.connectEndTime, this.lastBytesSentTime);
        int serverBusyTime = this.firstBytesReceivedTime > 0L && this.firstBytesReceivedTime > referenceTime ? (int)(this.firstBytesReceivedTime - referenceTime) : 0;
        if (this.firstBytesReceivedTime == 0L) {
            timeToLast = 0;
            timeToFirst = 0;
        } else {
            long start = SocketMonitor.getMinTime(this.dnsLookupStartTime, this.connectStartTime, this.firstBytesSentTime, this.firstBytesReceivedTime);
            timeToFirst = (int)(this.firstBytesReceivedTime - start);
            timeToLast = (int)(this.lastBytesReceivedTime - start);
        }
        return new SocketStatistics(dnsLookupTime, connectTime, sendTime, serverBusyTime, receiveTime, timeToFirst, timeToLast, this.bytesSent, this.bytesReceived);
    }

    public void read(int bytes) {
        this.lastBytesReceivedTime = TimerUtils.getTime();
        this.bytesReceived += bytes;
        if (this.firstBytesReceivedTime == 0L) {
            this.firstBytesReceivedTime = this.lastBytesReceivedTime;
        }
    }

    public void reset() {
        this.bytesSent = 0;
        this.bytesReceived = 0;
        this.dnsLookupStartTime = 0L;
        this.dnsLookupEndTime = 0L;
        this.connectStartTime = 0L;
        this.connectEndTime = 0L;
        this.firstBytesSentTime = 0L;
        this.lastBytesSentTime = 0L;
        this.firstBytesReceivedTime = 0L;
        this.lastBytesReceivedTime = 0L;
    }

    public void wrote(int bytes) {
        this.lastBytesSentTime = TimerUtils.getTime();
        this.bytesSent += bytes;
        if (this.firstBytesSentTime == 0L) {
            this.firstBytesSentTime = this.lastBytesSentTime;
        }
    }

    private static long getMaxTime(long ... timestamps) {
        long result = 0L;
        for (long timestamp : timestamps) {
            if (timestamp <= 0L || result != 0L && timestamp <= result) continue;
            result = timestamp;
        }
        return result;
    }

    private static long getMinTime(long ... timestamps) {
        long result = 0L;
        for (long timestamp : timestamps) {
            if (timestamp <= 0L || result != 0L && timestamp >= result) continue;
            result = timestamp;
        }
        return result;
    }
}

