/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.net.MalformedURLException;
import java.net.URL;

public final class URLCleaner {
    private URLCleaner() {
    }

    public static URL removeUserInfoIfNecessaryAsURL(URL url) {
        if (SessionImpl.REMOVE_USERINFO_FROM_REQUEST_URL) {
            try {
                return UrlUtils.getURLWithoutUserInfo(url);
            }
            catch (MalformedURLException mue) {
                XltLogger.runTimeLogger.error("Failed to remove user-info from URL '{}'", (Object)url, (Object)mue);
            }
        }
        return url;
    }

    public static String removeUserInfoIfNecessaryAsString(URL url) {
        if (SessionImpl.REMOVE_USERINFO_FROM_REQUEST_URL) {
            return UrlUtils.removeUserInfo(url);
        }
        return url.toExternalForm();
    }

    public static String removeUserInfoIfNecessaryAsString(String url) {
        if (SessionImpl.REMOVE_USERINFO_FROM_REQUEST_URL) {
            return UrlUtils.removeUserInfo(url);
        }
        return url;
    }
}

