/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

public class URLInfo {
    private final String protocol;
    private final String userInfo;
    private final String host;
    private final String path;
    private final int port;
    private final String query;
    private final String fragment;

    private URLInfo(String protocol, String userInfo, String host, int port, String path, String query, String fragment) {
        this.protocol = protocol;
        this.userInfo = userInfo;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public String getQuery() {
        return this.query;
    }

    public String getFragment() {
        return this.fragment;
    }

    public static URLInfoBuilder builder() {
        return new URLInfoBuilder();
    }

    public static class URLInfoBuilder {
        private String proto;
        private String host;
        private String userInfo;
        private String path;
        private String query;
        private String fragment;
        private int port = -1;

        public URLInfoBuilder proto(String protocol) {
            this.proto = protocol;
            return this;
        }

        public URLInfoBuilder host(String host) {
            this.host = host;
            return this;
        }

        public URLInfoBuilder userInfo(String user, String password) {
            this.userInfo = user + ":" + password;
            return this;
        }

        public URLInfoBuilder userInfo(String userInfo) {
            this.userInfo = userInfo;
            return this;
        }

        public URLInfoBuilder port(int port) {
            this.port = port;
            return this;
        }

        public URLInfoBuilder path(String path) {
            this.path = path;
            return this;
        }

        public URLInfoBuilder query(String query) {
            this.query = query;
            return this;
        }

        public URLInfoBuilder fragment(String fragment) {
            this.fragment = fragment;
            return this;
        }

        public URLInfo build() {
            return new URLInfo(this.proto, this.userInfo, this.host, this.port, this.path, this.query, this.fragment);
        }
    }
}

