/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.xceptance.xlt.engine.xltdriver.ElementConverter;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitElementFinder;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitWebElement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.w3c.dom.NodeList;

public class HtmlUnitWebElementFinder {
    public static WebElement findElement(HtmlUnitDriver driver, DomElement element, By locator) {
        return ElementConverter.HtmlUnitWebElementConverter.getElementObject(driver, element, locator).findElement(locator);
    }

    public static List<WebElement> findElements(HtmlUnitDriver driver, DomElement element, By locator) {
        return ElementConverter.HtmlUnitWebElementConverter.getElementObject(driver, element, locator).findElements(locator);
    }

    public static abstract class WebElementObject
    extends HtmlUnitElementFinder.ElementObject {
        private final DomElement element;

        public WebElementObject(HtmlUnitDriver driver, DomElement element) {
            super(driver);
            this.element = element;
        }

        public DomElement getElement() {
            return this.element;
        }
    }

    public static class WebFindByXPath
    extends WebElementObject {
        public WebFindByXPath(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        @Override
        public WebElement findElement(By locator) {
            Object node;
            String value = WebFindByXPath.getValue(locator);
            try {
                node = this.getElement().getFirstByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", value), (Throwable)ex);
            }
            if (node == null) {
                throw new NoSuchElementException("Unable to find an element with xpath " + value);
            }
            if (node instanceof HtmlElement) {
                return this.getDriver().toWebElement((HtmlElement)node);
            }
            throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", value, node.getClass().toString()));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            List domElements;
            String value = WebFindByXPath.getValue(locator);
            ArrayList<WebElement> webElements = new ArrayList<WebElement>();
            try {
                domElements = this.getElement().getByXPath(value);
            }
            catch (Exception ex) {
                throw new InvalidSelectorException(String.format("The xpath expression '%s' cannot be evaluated", value), (Throwable)ex);
            }
            for (Object e : domElements) {
                if (e instanceof DomElement) {
                    webElements.add(this.getDriver().toWebElement((DomElement)e));
                    continue;
                }
                throw new InvalidSelectorException(String.format("The xpath expression '%s' selected an object of type '%s' instead of a WebElement", value, e.getClass().toString()));
            }
            return webElements;
        }
    }

    public static class WebFindByPartialLinkText
    extends WebElementObject {
        public WebFindByPartialLinkText(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            NodeList htmlElements = this.getElement().getElementsByTagName("a");
            ArrayList<WebElement> webElements = new ArrayList<WebElement>();
            String value = WebFindByPartialLinkText.getValue(locator);
            Iterator iterator = htmlElements.iterator();
            while (iterator.hasNext()) {
                HtmlElement e = (HtmlElement)iterator.next();
                if (!e.asNormalizedText().contains(value) || e.getAttribute("href") == null) continue;
                webElements.add(this.getDriver().toWebElement(e));
            }
            return webElements;
        }
    }

    public static class WebFindByLinkText
    extends WebElementObject {
        public WebFindByLinkText(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            String expectedText = WebFindByLinkText.getValue(locator).trim();
            NodeList htmlElements = this.getElement().getElementsByTagName("a");
            ArrayList<WebElement> webElements = new ArrayList<WebElement>();
            Iterator iterator = htmlElements.iterator();
            while (iterator.hasNext()) {
                DomElement e = (DomElement)iterator.next();
                if (!expectedText.equals(e.asNormalizedText()) || e.getAttribute("href") == null) continue;
                webElements.add(this.getDriver().toWebElement(e));
            }
            return webElements;
        }
    }

    public static class WebFindByCssSelector
    extends WebElementObject {
        public WebFindByCssSelector(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        @Override
        public WebElement findElement(By locator) {
            List<WebElement> elements = new HtmlUnitElementFinder.FindByCssSelector(this.getDriver()).findElements(locator);
            if ((elements = this.findChildNodes(elements)).isEmpty()) {
                throw new NoSuchElementException("Cannot find child element using css: " + WebFindByCssSelector.getValue(locator));
            }
            return elements.get(0);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            List<WebElement> elements = new HtmlUnitElementFinder.FindByCssSelector(this.getDriver()).findElements(locator);
            return this.findChildNodes(elements);
        }

        private List<WebElement> findChildNodes(List<WebElement> allElements) {
            LinkedList<WebElement> toReturn = new LinkedList<WebElement>();
            for (WebElement current : allElements) {
                DomElement candidate = ((HtmlUnitWebElement)current).element;
                if (!this.getElement().isAncestorOf(candidate) || this.getElement() == candidate) continue;
                toReturn.add(current);
            }
            return toReturn;
        }
    }

    public static class WebFindByTagName
    extends WebElementObject {
        public WebFindByTagName(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        @Override
        public List<WebElement> findElements(By locator) {
            NodeList elements = this.getElement().getElementsByTagName(WebFindByTagName.getValue(locator));
            ArrayList<WebElement> toReturn = new ArrayList<WebElement>(elements.size());
            Iterator iterator = elements.iterator();
            while (iterator.hasNext()) {
                HtmlElement e = (HtmlElement)iterator.next();
                toReturn.add(this.getDriver().toWebElement(e));
            }
            return toReturn;
        }
    }

    public static class WebFindByClassName
    extends WebElementObject {
        public WebFindByClassName(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        protected By.ByXPath getXpath(By locator) {
            return new By.ByXPath(".//*[@class = '" + WebFindByClassName.getValue(locator) + "']");
        }

        @Override
        public WebElement findElement(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElement((By)this.getXpath(locator));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElements((By)this.getXpath(locator));
        }
    }

    public static class WebFindByName
    extends WebElementObject {
        public WebFindByName(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        protected By.ByXPath getXpath(By locator) {
            return new By.ByXPath(".//*[@name = '" + WebFindByName.getValue(locator) + "']");
        }

        @Override
        public WebElement findElement(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElement((By)this.getXpath(locator));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElements((By)this.getXpath(locator));
        }
    }

    public static class WebFindById
    extends WebElementObject {
        public WebFindById(HtmlUnitDriver driver, DomElement element) {
            super(driver, element);
        }

        protected By.ByXPath getXpath(By locator) {
            return new By.ByXPath(".//*[@id = '" + WebFindById.getValue(locator) + "']");
        }

        @Override
        public WebElement findElement(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElement((By)this.getXpath(locator));
        }

        @Override
        public List<WebElement> findElements(By locator) {
            return new WebFindByXPath(this.getDriver(), this.getElement()).findElements((By)this.getXpath(locator));
        }
    }
}

