/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.NetworkInterface;
import com.google.api.services.compute.model.Region;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.gce.GceAdmin;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GceAdminUtils {
    private static final Logger log = LoggerFactory.getLogger(GceAdmin.class);
    private static final String AGENT_CONTROLLER_LINE_FORMAT = "com.xceptance.xlt.mastercontroller.agentcontrollers.ac%03d_%s.url = https://%s:8500";
    private static final Map<String, String> FRIENDLY_REGION_NAMES = new HashMap<String, String>();

    GceAdminUtils() {
    }

    static List<Region> multiSelectRegions(List<Region> regions) {
        List<String> regionNames = GceAdminUtils.getFriendlyRegionNames(regions);
        return ConsoleUiUtils.multiSelectItems("Select one or more regions:", regionNames, regions, true);
    }

    static List<InstanceGroup> multiSelectInstanceGroups(List<InstanceGroup> instanceGroups) {
        ArrayList<InstanceGroup> sortedInstanceGroups = new ArrayList<InstanceGroup>(instanceGroups);
        Collections.sort(sortedInstanceGroups, (ig1, ig2) -> ig1.getName().compareTo(ig2.getName()));
        ArrayList<String> sortedInstanceGroupNames = new ArrayList<String>();
        for (InstanceGroup instanceGroup : sortedInstanceGroups) {
            sortedInstanceGroupNames.add(instanceGroup.getName());
        }
        return ConsoleUiUtils.multiSelectItems("Select one or more instance groups:", sortedInstanceGroupNames, sortedInstanceGroups, true);
    }

    static String buildAgentControllerConnectionProperties(List<Instance> instances) {
        StringBuilder sb = new StringBuilder();
        int instanceIndex = 1;
        for (Instance instance : instances) {
            String zoneResource = instance.getZone();
            String zoneName = GceAdminUtils.getZoneName(zoneResource);
            String ipAddress = GceAdminUtils.getIpAddress(instance);
            sb.append(String.format(AGENT_CONTROLLER_LINE_FORMAT, instanceIndex, zoneName, ipAddress)).append('\n');
            ++instanceIndex;
        }
        return sb.toString();
    }

    static void outputAgentControllerConnectionProperties(List<Instance> instances, File outputFile) throws IOException {
        String agentControllerConnectionProperties = GceAdminUtils.buildAgentControllerConnectionProperties(instances);
        if (outputFile != null) {
            FileUtils.writeStringToFile((File)outputFile, (String)agentControllerConnectionProperties, (Charset)StandardCharsets.UTF_8);
        } else {
            System.out.print(agentControllerConnectionProperties);
        }
    }

    static void logError(String errorMessage, Throwable t) {
        System.err.println("Error: " + errorMessage);
        log.error(errorMessage, t);
    }

    static void dieWithMessage(String errorMessage) {
        GceAdminUtils.dieWithMessage(errorMessage, null);
    }

    static void dieWithMessage(String errorMessage, Throwable t) {
        GceAdminUtils.logError(errorMessage, t);
        System.exit(1);
    }

    static List<String> getFriendlyRegionNames(List<Region> regions) {
        return regions.stream().map(GceAdminUtils::getFriendlyRegionName).collect(Collectors.toList());
    }

    static String getFriendlyRegionName(Region region) {
        String regionName = region.getName();
        String friendlyRegionName = FRIENDLY_REGION_NAMES.get(regionName);
        if (friendlyRegionName == null) {
            friendlyRegionName = FRIENDLY_REGION_NAMES.get("");
        }
        return friendlyRegionName + " (" + regionName + ")";
    }

    static String getInstanceName(String instanceUrl) {
        return StringUtils.substringAfter((String)instanceUrl, (String)"instances/");
    }

    static String getRegionName(String regionUrl) {
        return StringUtils.substringAfter((String)regionUrl, (String)"regions/");
    }

    static String getZoneName(String resourceUrl) {
        String zoneName = StringUtils.substringBetween((String)resourceUrl, (String)"zones/", (String)"/instances/");
        if (zoneName == null) {
            zoneName = StringUtils.substringAfter((String)resourceUrl, (String)"zones/");
        }
        return zoneName;
    }

    static String getMachineType(String machineTypeUrl) {
        return StringUtils.substringAfter((String)machineTypeUrl, (String)"machineTypes/");
    }

    static String getIpAddress(Instance instance) {
        List networkInterfaces = instance.getNetworkInterfaces();
        if (networkInterfaces != null && networkInterfaces.size() > 0) {
            for (NetworkInterface networkInterface : networkInterfaces) {
                List accessConfigs = networkInterface.getAccessConfigs();
                if (accessConfigs == null || accessConfigs.size() <= 0) continue;
                for (AccessConfig accessConfig : accessConfigs) {
                    String ipAddress = accessConfig.getNatIP();
                    if (!StringUtils.isNotBlank((CharSequence)ipAddress)) continue;
                    return ipAddress;
                }
            }
            for (NetworkInterface networkInterface : networkInterfaces) {
                String ipAddress = networkInterface.getNetworkIP();
                if (!StringUtils.isNotBlank((CharSequence)ipAddress)) continue;
                return ipAddress;
            }
        }
        return "<none>";
    }

    static {
        FRIENDLY_REGION_NAMES.put("asia-east1", "Asia Pacific  - Taiwan        ");
        FRIENDLY_REGION_NAMES.put("asia-east2", "Asia Pacific  - Hong Kong     ");
        FRIENDLY_REGION_NAMES.put("asia-northeast1", "Asia Pacific  - Tokyo         ");
        FRIENDLY_REGION_NAMES.put("asia-northeast2", "Asia Pacific  - Osaka         ");
        FRIENDLY_REGION_NAMES.put("asia-northeast3", "Asia Pacific  - Seoul         ");
        FRIENDLY_REGION_NAMES.put("asia-south1", "Asia Pacific  - Mumbai        ");
        FRIENDLY_REGION_NAMES.put("asia-south2", "Asia Pacific  - Delhi         ");
        FRIENDLY_REGION_NAMES.put("asia-southeast1", "Asia Pacific  - Singapore     ");
        FRIENDLY_REGION_NAMES.put("asia-southeast2", "Asia Pacific  - Jakarta       ");
        FRIENDLY_REGION_NAMES.put("australia-southeast1", "Asia Pacific  - Sydney        ");
        FRIENDLY_REGION_NAMES.put("australia-southeast2", "Asia Pacific  - Melbourne     ");
        FRIENDLY_REGION_NAMES.put("europe-central2", "Europe        - Warsaw        ");
        FRIENDLY_REGION_NAMES.put("europe-north1", "Europe        - Finland       ");
        FRIENDLY_REGION_NAMES.put("europe-west1", "Europe        - Belgium       ");
        FRIENDLY_REGION_NAMES.put("europe-west2", "Europe        - London        ");
        FRIENDLY_REGION_NAMES.put("europe-west3", "Europe        - Frankfurt     ");
        FRIENDLY_REGION_NAMES.put("europe-west4", "Europe        - Netherlands   ");
        FRIENDLY_REGION_NAMES.put("europe-west6", "Europe        - Zurich        ");
        FRIENDLY_REGION_NAMES.put("northamerica-northeast1", "Canada        - Montr\u00e9al      ");
        FRIENDLY_REGION_NAMES.put("northamerica-northeast2", "Canada        - Toronto       ");
        FRIENDLY_REGION_NAMES.put("southamerica-east1", "South America - Sao Paulo     ");
        FRIENDLY_REGION_NAMES.put("southamerica-west1", "South America - Chile         ");
        FRIENDLY_REGION_NAMES.put("us-central1", "US            - Iowa          ");
        FRIENDLY_REGION_NAMES.put("us-east1", "US            - South Carolina");
        FRIENDLY_REGION_NAMES.put("us-east4", "US            - North Virginia");
        FRIENDLY_REGION_NAMES.put("us-west1", "US            - Oregon        ");
        FRIENDLY_REGION_NAMES.put("us-west2", "US            - California    ");
        FRIENDLY_REGION_NAMES.put("us-west3", "US            - Utah          ");
        FRIENDLY_REGION_NAMES.put("us-west4", "US            - Nevada        ");
        FRIENDLY_REGION_NAMES.put("", "<unknown>     - <unknown>     ");
    }
}

