/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.api.services.compute.model.Instance;
import com.google.api.services.compute.model.InstanceGroup;
import com.google.api.services.compute.model.Region;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class OpListInstances {
    private static final String[] FILTER_OPTION_KEYS = new String[]{"0", "l", "g"};
    private static final String[] FILTER_OPTION_DESCRIPTIONS = new String[]{"(No filter)", "Name label", "Instance group"};
    private static final String[] FILTER_OPTIONS = new String[]{"noFilter", "label", "group"};
    private final GceClient gceClient;

    OpListInstances(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute() throws IOException {
        List<Object> instances = new ArrayList();
        List<Region> regions = this.gceClient.getRegions();
        List<Region> selectedRegions = GceAdminUtils.multiSelectRegions(regions);
        System.out.println();
        String filterOption = this.selectFilterOption();
        System.out.println();
        if (filterOption.equals(FILTER_OPTIONS[0])) {
            instances = this.getAllInstances(selectedRegions);
        } else if (filterOption.equals(FILTER_OPTIONS[1])) {
            instances = this.getInstancesWithNameLabel(selectedRegions);
        } else if (filterOption.equals(FILTER_OPTIONS[2])) {
            instances = this.getInstancesInInstanceGroups(selectedRegions);
        }
        this.printAgentControllerConnectionProperties(instances);
    }

    private String selectFilterOption() {
        return ConsoleUiUtils.selectItem("Filter instances by:", Arrays.asList(FILTER_OPTION_KEYS), Arrays.asList(FILTER_OPTION_DESCRIPTIONS), Arrays.asList(FILTER_OPTIONS));
    }

    private List<Instance> getAllInstances(List<Region> regions) throws IOException {
        List<Instance> instances = this.getInstancesInRegions(regions);
        if (instances.isEmpty()) {
            System.out.println();
            System.out.println("No instances found.");
        }
        return instances;
    }

    private List<Instance> getInstancesInRegions(List<Region> regions) throws IOException {
        ArrayList<Instance> allInstances = new ArrayList<Instance>();
        for (Region region : regions) {
            System.out.printf("Querying all instances in region '%s' ... ", region.getName());
            List<Instance> instances = this.gceClient.getInstancesInRegion(region);
            System.out.println("OK");
            allInstances.addAll(this.filterRunningInstance(instances));
        }
        return allInstances;
    }

    private List<Instance> filterRunningInstance(List<Instance> instances) {
        return instances.stream().filter(instance -> "RUNNING".equals(instance.getStatus())).collect(Collectors.toList());
    }

    private List<Instance> getInstancesWithNameLabel(List<Region> regions) throws IOException {
        List<Instance> instances = this.getInstancesInRegions(regions);
        List<String> nameLabels = this.getNameLabels(instances);
        System.out.println();
        if (nameLabels.isEmpty()) {
            System.out.println("No instances with name labels found.");
            return Collections.emptyList();
        }
        return this.filterInstancesByNameLabels(instances, this.multiSelectNameLabels(nameLabels));
    }

    private List<String> getNameLabels(List<Instance> instances) {
        ArrayList<String> nameLabels = new ArrayList<String>();
        for (Instance instance : instances) {
            String nameLabel;
            Map labels = instance.getLabels();
            if (labels == null || (nameLabel = (String)labels.get("name")) == null || nameLabels.contains(nameLabel)) continue;
            nameLabels.add(nameLabel);
        }
        Collections.sort(nameLabels);
        return nameLabels;
    }

    private List<String> multiSelectNameLabels(List<String> nameLabels) {
        return ConsoleUiUtils.multiSelectItems("Select one or more name labels:", nameLabels, nameLabels, true);
    }

    private List<Instance> filterInstancesByNameLabels(List<Instance> instances, List<String> labels) {
        ArrayList<Instance> filteredInstances = new ArrayList<Instance>();
        for (Instance instance : instances) {
            String nameLabel;
            Map instanceLabels = instance.getLabels();
            if (instanceLabels == null || !labels.contains(nameLabel = (String)instanceLabels.get("name"))) continue;
            filteredInstances.add(instance);
        }
        return filteredInstances;
    }

    private List<Instance> getInstancesInInstanceGroups(List<Region> regions) throws IOException {
        List<InstanceGroup> instanceGroups = this.getInstanceGroupsInRegions(regions);
        System.out.println();
        if (instanceGroups.isEmpty()) {
            System.out.println("No instance groups found.");
            return Collections.emptyList();
        }
        return this.getInstancesOfInstanceGroups(GceAdminUtils.multiSelectInstanceGroups(instanceGroups));
    }

    private List<InstanceGroup> getInstanceGroupsInRegions(List<Region> regions) throws IOException {
        ArrayList<InstanceGroup> allInstanceGroups = new ArrayList<InstanceGroup>();
        for (Region region : regions) {
            System.out.printf("Querying all instance groups in region '%s' ... ", region.getName());
            List<InstanceGroup> instanceGroups = this.gceClient.getAllInstanceGroups(region);
            System.out.println("OK");
            allInstanceGroups.addAll(instanceGroups);
        }
        return allInstanceGroups;
    }

    private List<Instance> getInstancesOfInstanceGroups(List<InstanceGroup> instanceGroups) throws IOException {
        ArrayList<Instance> allInstances = new ArrayList<Instance>();
        System.out.println();
        for (InstanceGroup instanceGroup : instanceGroups) {
            System.out.printf("Querying all instances in instance group '%s' ... ", instanceGroup.getName());
            List<Instance> instancesOfGroup = this.gceClient.getInstancesInGroup(instanceGroup);
            System.out.println("OK");
            allInstances.addAll(this.filterRunningInstance(instancesOfGroup));
        }
        return allInstances;
    }

    private void printAgentControllerConnectionProperties(List<Instance> instances) {
        if (!instances.isEmpty()) {
            System.out.println();
            System.out.println("--- Master controller configuration ---");
            System.out.print(GceAdminUtils.buildAgentControllerConnectionProperties(instances));
        }
    }
}

