/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.RegExUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.regex.Matcher;

public abstract class AbstractLoadFunctionParser {
    private static final String RE_RECORD_SEP = "[,;\\s]*";
    private static final String RE_TIME = "[^/]+";
    private static final String RE_FIELD_SEP = "[/\\s]+";
    private static final String RE_VALUE = "[^,;\\s]+";

    public int[][] parse(String loadFunction) throws ParseException {
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        Matcher recordSeparatorMatcher = RegExUtils.getPattern(RE_RECORD_SEP).matcher(loadFunction);
        Matcher timeMatcher = RegExUtils.getPattern(RE_TIME).matcher(loadFunction);
        Matcher fieldSeparatorMatcher = RegExUtils.getPattern(RE_FIELD_SEP).matcher(loadFunction);
        Matcher valueMatcher = RegExUtils.getPattern(RE_VALUE).matcher(loadFunction);
        int l = loadFunction.length();
        int i = 0;
        while (!(i >= l || recordSeparatorMatcher.find(i) && recordSeparatorMatcher.start() == i && (i = recordSeparatorMatcher.end()) == l)) {
            if (!timeMatcher.find(i) || timeMatcher.start() != i) {
                throw new ParseException("Expected a time at index " + i, i);
            }
            i = timeMatcher.end();
            int time = ParseUtils.parseTimePeriod(timeMatcher.group());
            if (!fieldSeparatorMatcher.find(i) || fieldSeparatorMatcher.start() != i) {
                throw new ParseException("Expected a '/' at index " + i, i);
            }
            i = fieldSeparatorMatcher.end();
            if (valueMatcher.find(i) && valueMatcher.start() == i) {
                i = valueMatcher.end();
                int value = this.parseValue(valueMatcher.group());
                pairs.add(new int[]{time, value});
                continue;
            }
            throw new ParseException("Expected a value at index " + i, i);
        }
        int size = pairs.size();
        if (size == 0) {
            throw new IllegalArgumentException("The load function must specify at least one time/value pair.");
        }
        int[][] result = (int[][])pairs.toArray((T[])new int[size][]);
        return result;
    }

    abstract int parseValue(String var1) throws ParseException;
}

