/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.caucho.hessian.client.EasyHessianProxyFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import com.xceptance.common.net.UrlConnectionFactory;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.AgentControllerImpl;
import com.xceptance.xlt.agentcontroller.AgentControllerProxy;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.mastercontroller.AgentControllerConnectionInfo;
import com.xceptance.xlt.mastercontroller.BasicConsoleUI;
import com.xceptance.xlt.mastercontroller.FireAndForgetUI;
import com.xceptance.xlt.mastercontroller.InteractiveUI;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.MasterControllerConfiguration;
import com.xceptance.xlt.mastercontroller.NonInteractiveUI;
import com.xceptance.xlt.mastercontroller.XltProxySelector;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import java.io.File;
import java.io.IOException;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final String OPTION_TIMEZONE = "timezone";
    private static final String OPTION_AUTO = "auto";
    private static final String OPTION_EMBEDDED = "embedded";
    private static final String OPTION_REPORT = "report";
    private static final String OPTION_FAF = "faf";
    private static final String OPTION_SEQUENTIAL = "sequential";
    private static final String OPTION_TEST_PROPS_FILE = "testPropertiesFile";
    private static final String OPTION_PROPERTY_DEFINITION = "D";
    private static final String OPTION_RESULT_OVERRIDE = "o";
    private static final String OPTION_NO_DOWNLOAD = "noDownload";
    private static final String OPTION_DOWNLOAD = "only-download";
    private static final String OPTION_COMMANDS = "c";
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    protected BasicConsoleUI ui;

    protected void initialize(CommandLine commandLine) throws Exception {
        String outputDir;
        boolean isAgentControllerConnectionRelaxed;
        File overridePropertyFile = this.getOverridePropertiesFile(commandLine);
        Properties commandLineProps = commandLine.getOptionProperties(OPTION_PROPERTY_DEFINITION);
        MasterControllerConfiguration config = new MasterControllerConfiguration(overridePropertyFile, commandLineProps, commandLine.hasOption(OPTION_EMBEDDED));
        this.setupHttpsProxy(config);
        boolean sequentialMode = commandLine.hasOption(OPTION_SEQUENTIAL);
        boolean fafMode = commandLine.hasOption(OPTION_FAF);
        boolean autoMode = commandLine.hasOption(OPTION_AUTO) || fafMode || sequentialMode;
        boolean commandsMode = commandLine.hasOption(OPTION_COMMANDS);
        boolean bl = isAgentControllerConnectionRelaxed = config.isAgentControllerConnectionRelaxed() && commandLine.hasOption(OPTION_AUTO);
        if ((autoMode && !sequentialMode || commandsMode) && commandLine.hasOption(OPTION_RESULT_OVERRIDE) && StringUtils.isNotBlank((CharSequence)(outputDir = commandLine.getOptionValue(OPTION_RESULT_OVERRIDE)))) {
            config.setResultOutputDirectory(outputDir);
        }
        FailedAgentControllerCollection unconnectedAgentControllers = new FailedAgentControllerCollection();
        TreeMap<String, AgentController> agentControllers = new TreeMap<String, AgentController>();
        boolean agentBaseNumber = false;
        if (commandLine.hasOption(OPTION_EMBEDDED)) {
            this.startAgentControllerEmbedded(agentControllers, unconnectedAgentControllers, config, commandLineProps, isAgentControllerConnectionRelaxed, 0);
        } else {
            this.startAgentControllerRemote(agentControllers, unconnectedAgentControllers, config, commandLineProps, isAgentControllerConnectionRelaxed, 0);
        }
        MasterController masterController = this.startMasterController(config, commandLine, isAgentControllerConnectionRelaxed, agentControllers);
        this.ui = this.setupUi(masterController, config, commandLine, sequentialMode, autoMode, fafMode);
        masterController.setUserInterface(this.ui);
        this.ui.printXltInfo();
        this.ui.skipAgentControllerConnections(unconnectedAgentControllers);
        masterController.init();
        this.ui.printAgentControllerPreCheckInformation();
    }

    File getOverridePropertiesFile(CommandLine commandLine) {
        String overridePropertyFileName = commandLine.getOptionValue("pf");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{overridePropertyFileName})) {
            return new File(overridePropertyFileName);
        }
        return null;
    }

    protected void setupHttpsProxy(MasterControllerConfiguration config) {
        if (config.isHttpsProxyEnabled()) {
            System.setProperty("https.proxyHost", config.getHttpsProxyHost());
            System.setProperty("https.proxyPort", config.getHttpsProxyPort());
            System.setProperty("https.nonProxyHosts", config.getHttpsProxyBypassHosts());
            XltProxySelector proxySel = new XltProxySelector(ProxySelector.getDefault());
            ProxySelector.setDefault(proxySel);
        }
    }

    protected HessianProxyFactory getHessianProxyFactory(MasterControllerConfiguration config) {
        EasyHessianProxyFactory proxyFactory = new EasyHessianProxyFactory();
        proxyFactory.setConnectTimeout(config.getAgentControllerConnectTimeout());
        proxyFactory.setReadTimeout(config.getAgentControllerReadTimeout());
        proxyFactory.setUser(config.getUserName());
        proxyFactory.setPassword(config.getPassword());
        return proxyFactory;
    }

    protected UrlConnectionFactory getUrlConnectionFactory(MasterControllerConfiguration config) {
        UrlConnectionFactory urlConnectionFactory = new UrlConnectionFactory();
        urlConnectionFactory.setEasySsl(true);
        urlConnectionFactory.setConnectTimeout(config.getAgentControllerConnectTimeout());
        urlConnectionFactory.setReadTimeout(config.getAgentControllerReadTimeout());
        urlConnectionFactory.setUserName(config.getUserName());
        urlConnectionFactory.setPassword(config.getPassword());
        return urlConnectionFactory;
    }

    private void startAgentControllerEmbedded(Map<String, AgentController> agentControllers, FailedAgentControllerCollection unconnectedAgentControllers, MasterControllerConfiguration config, Properties commandLineProps, boolean isAgentControllerConnectionRelaxed, int agentBaseNumber) throws IOException {
        log.info("create embedded agent controller");
        try {
            AgentControllerImpl agentController = new AgentControllerImpl(commandLineProps);
            agentController.init(OPTION_EMBEDDED, null, config.getDefaultWeight(), config.getDefaultAgentCount(), agentBaseNumber, false);
            agentControllers.put(agentController.getName(), agentController);
        }
        catch (Exception e) {
            String message = "Unable to open proxy for embedded@localhost:8500";
            if (isAgentControllerConnectionRelaxed) {
                log.warn("Unable to open proxy for embedded@localhost:8500", (Throwable)e);
                System.out.println("Unable to open proxy for embedded@localhost:8500");
            }
            throw new IOException("Unable to open proxy for embedded@localhost:8500", e);
        }
    }

    private void startAgentControllerRemote(Map<String, AgentController> agentControllers, FailedAgentControllerCollection unconnectedAgentControllers, MasterControllerConfiguration config, Properties commandLineProps, boolean isAgentControllerConnectionRelaxed, int agentBaseNumber) throws Exception {
        log.info("create proxy controllers for remote agent controllers");
        HessianProxyFactory proxyFactory = this.getHessianProxyFactory(config);
        UrlConnectionFactory urlConnectionFactory = this.getUrlConnectionFactory(config);
        List<AgentControllerConnectionInfo> connectionInfos = config.getAgentControllerConnectionInfos();
        for (AgentControllerConnectionInfo info : connectionInfos) {
            int agentCount = info.getNumberOfAgents();
            AgentControllerProxy agentController = new AgentControllerProxy(commandLineProps, proxyFactory, urlConnectionFactory);
            try {
                agentController.init(info.getName(), info.getUrl(), info.getWeight(), agentCount, agentBaseNumber, info.runsClientPerformanceTests());
                agentControllers.put(agentController.getName(), agentController);
                if (log.isDebugEnabled()) {
                    log.debug("proxy created for " + info.getName() + " @ " + info.getUrl().getHost() + ":" + info.getUrl().getPort());
                }
                agentBaseNumber += agentCount;
            }
            catch (Exception e) {
                String message = "Unable to open proxy for " + info.getName() + " @ " + info.getUrl().getHost() + ":" + info.getUrl().getPort() + ": " + e.getMessage();
                if (isAgentControllerConnectionRelaxed) {
                    log.warn(message, (Throwable)e);
                    unconnectedAgentControllers.add(agentController, e);
                    continue;
                }
                throw new IOException(message, e);
            }
        }
    }

    private MasterController startMasterController(MasterControllerConfiguration config, CommandLine commandLine, boolean isAgentControllerConnectionRelaxed, Map<String, AgentController> agentControllers) {
        String propertiesFileName = commandLine.getOptionValue(OPTION_TEST_PROPS_FILE);
        String timezone = commandLine.getOptionValue(OPTION_TIMEZONE);
        MasterController masterController = new MasterController(agentControllers, config, propertiesFileName, isAgentControllerConnectionRelaxed, timezone);
        return masterController;
    }

    protected BasicConsoleUI setupUi(MasterController masterController, MasterControllerConfiguration config, CommandLine commandLine, boolean sequentialMode, boolean autoMode, boolean fafMode) {
        BasicConsoleUI ui;
        boolean commandsMode = commandLine.hasOption(OPTION_COMMANDS);
        boolean generateReport = commandLine.hasOption(OPTION_REPORT);
        boolean noResults = autoMode && commandLine.hasOption(OPTION_NO_DOWNLOAD);
        boolean download = commandLine.hasOption(OPTION_DOWNLOAD);
        TestResultAmount resultAmount = TestResultAmount.ALL;
        if (download) {
            String downloadArg = commandLine.getOptionValue(OPTION_DOWNLOAD);
            resultAmount = ResultDataTypes.asTestResultAmount(downloadArg);
        }
        if (fafMode) {
            System.out.println("\n*** Command-line option -faf is deprecated. Please use -auto instead. ***\n");
        }
        if (generateReport && noResults) {
            System.out.println("\n*** Cannot generate report as download of test results will be skipped. ***\n");
        }
        if (download && noResults) {
            System.out.println("\n*** Cannot apply given download filter as download of test results will be skipped.");
        }
        if (autoMode) {
            ui = new FireAndForgetUI(masterController, sequentialMode, generateReport, noResults, config.getAgentControllerInitialResponseTimeout(), resultAmount);
            masterController.setTestComment(commandLine.getOptionValue("comment", null));
        } else if (commandsMode) {
            String commandList = commandLine.getOptionValue(OPTION_COMMANDS);
            ui = new NonInteractiveUI(masterController, commandList, config.getAgentControllerInitialResponseTimeout(), resultAmount);
            masterController.setTestComment(commandLine.getOptionValue("comment", null));
        } else {
            ui = new InteractiveUI(masterController, generateReport);
        }
        ui.setStatusListUpdateInterval(config.getStatusListUpdateInterval());
        ui.setShowDetailedStatusList(config.getShowDetailedStatusList());
        return ui;
    }

    protected Options createCommandLineOptions() {
        Options options = new Options();
        Option autoMode = new Option(OPTION_AUTO, false, "Run a load test in non-interactive mode.");
        options.addOption(autoMode);
        Option embeddedMode = new Option(OPTION_EMBEDDED, false, "Use a single embedded agent controller.");
        options.addOption(embeddedMode);
        Option fafMode = new Option(OPTION_FAF, false, "(deprecated, use -auto instead)");
        options.addOption(fafMode);
        Option generateReport = new Option(OPTION_REPORT, false, "Generate the test report right after downloading the test results (ignored in commands mode).");
        options.addOption(generateReport);
        Option sequentialMode = new Option(OPTION_SEQUENTIAL, false, "Run test cases one after the other (implies -auto).");
        options.addOption(sequentialMode);
        Option additionalPropertiesFile = new Option("pf", true, "Set the path to an additional properties file, which overrides the values in file 'mastercontroller.properties'.");
        additionalPropertiesFile.setArgName("file");
        options.addOption(additionalPropertiesFile);
        Option testComment = new Option("comment", true, "Set a comment for the test run (ignored in interactive mode).");
        testComment.setArgName("string");
        options.addOption(testComment);
        Option testPropertiesFileName = new Option(OPTION_TEST_PROPS_FILE, true, "Use the specified file as the test-run specific properties file.");
        testPropertiesFileName.setArgName("fileName");
        options.addOption(testPropertiesFileName);
        Option propertyDefinition = new Option(OPTION_PROPERTY_DEFINITION, true, "Override a property in file 'mastercontroller.properties'.");
        propertyDefinition.setValueSeparator('=');
        propertyDefinition.setArgName("property=value");
        propertyDefinition.setArgs(2);
        options.addOption(propertyDefinition);
        Option timeZone = new Option(OPTION_TIMEZONE, true, "Override the user's default timezone when generating the test report.");
        timeZone.setArgName("timezoneId");
        options.addOption(timeZone);
        Option output = new Option(OPTION_RESULT_OVERRIDE, true, "Store downloaded test results to this directory (ignored in interactive or sequential mode).");
        output.setArgName("dir");
        options.addOption(output);
        Option noResults = new Option(OPTION_NO_DOWNLOAD, false, "Don't download test results (auto mode only).");
        options.addOption(noResults);
        Option commands = new Option(OPTION_COMMANDS, "commands", true, "Execute the commands, given as a comma-separated list, in the specified order and quit. Supported commands are: " + StringUtils.join((Object[])NonInteractiveUI.MasterControllerCommands.values(), (String)", ") + ".");
        commands.setArgName("commandList");
        options.addOption(commands);
        Option download = new Option(null, OPTION_DOWNLOAD, true, "Restrict download to the given (comma-separated list of) result data types (non-interactive mode only). Supported values are: " + StringUtils.join((Object[])ResultDataTypes.values(), (String)", ") + ".");
        download.setArgName("dataTypeList");
        options.addOption(download);
        return options;
    }

    protected CommandLine parseCommandLine(String[] args, Options options) throws ParseException {
        DefaultParser parser = new DefaultParser();
        return parser.parse(options, args);
    }

    protected void printUsageInfo(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage:\n");
        formatter.setWidth(79);
        StringBuilder usage = new StringBuilder();
        usage.append("   mastercontroller [<other options>]\n");
        usage.append("     -> Runs in interactive mode. Choose the command to be executed next.\n\n");
        usage.append("   mastercontroller -c <commandList> [<other options>]\n");
        usage.append("     -> Runs in non-interactive mode. Pass the commands to be executed.\n\n");
        usage.append("   mastercontroller -auto [<other options>]\n");
        usage.append("     -> Runs a load test in non-interactive mode by executing all needed commands automatically.\n\n");
        formatter.printHelp(usage.toString(), "Options:", options, null);
    }

    protected boolean validateCommandLine(CommandLine commandLine) {
        String message;
        Object[] unknownCommands;
        String commandList;
        boolean fafMode = commandLine.hasOption(OPTION_FAF);
        boolean autoMode = commandLine.hasOption(OPTION_AUTO);
        boolean commandMode = commandLine.hasOption(OPTION_COMMANDS);
        boolean sequentialMode = commandLine.hasOption(OPTION_SEQUENTIAL);
        boolean invalid = false;
        if ((autoMode || fafMode || sequentialMode) && commandMode) {
            String message2 = String.format("Option '-%s' cannot be used together with '-%s', '-%s', or '-%s'.", OPTION_COMMANDS, OPTION_AUTO, OPTION_FAF, OPTION_SEQUENTIAL);
            System.out.println(message2);
            log.error(message2);
            invalid = true;
        }
        if ((commandList = commandLine.getOptionValue(OPTION_COMMANDS)) != null && (unknownCommands = NonInteractiveUI.MasterControllerCommands.validate(commandList)).length > 0) {
            message = String.format("Unrecognized commands passed to '-%s' option: %s\nSupported commands: %s", OPTION_COMMANDS, StringUtils.join((Object[])unknownCommands, (String)", "), StringUtils.join((Object[])NonInteractiveUI.MasterControllerCommands.values(), (String)", "));
            System.out.println(message);
            log.error(message);
            invalid = true;
        }
        if (commandLine.hasOption(OPTION_DOWNLOAD)) {
            String message3;
            if (commandLine.hasOption(OPTION_NO_DOWNLOAD)) {
                message3 = String.format("Option '--%s' cannot be used together with option '-%s'.", OPTION_DOWNLOAD, OPTION_NO_DOWNLOAD);
                System.out.println(message3);
                log.error(message3);
                invalid = true;
            } else if (!(commandMode || autoMode || sequentialMode || fafMode)) {
                message3 = String.format("Option '--%s' can only be used in non-interactive mode.", OPTION_DOWNLOAD);
                System.out.println(message3);
                log.error(message3);
                invalid = true;
            } else {
                String downloadOptValue = StringUtils.stripToNull((String)commandLine.getOptionValue(OPTION_DOWNLOAD));
                if (downloadOptValue == null) {
                    message = String.format("Option '--%s' requires an argument but none was given (or consists of whitespace characters only).", OPTION_DOWNLOAD);
                    System.out.println(message);
                    log.error(message);
                    invalid = true;
                } else {
                    Object[] unknownTypes = ResultDataTypes.validate(downloadOptValue);
                    if (unknownTypes.length > 0) {
                        String message4 = String.format("Unrecognized values passed as argument to '--%s' option: %s\nSupported values: %s", OPTION_DOWNLOAD, StringUtils.join((Object[])unknownTypes, (String)", "), StringUtils.join((Object[])ResultDataTypes.values(), (String)", "));
                        System.out.println(message4);
                        log.error(message4);
                        invalid = true;
                    }
                }
            }
        }
        return invalid;
    }

    protected void run(String[] args) {
        Locale.setDefault(Locale.US);
        Options options = null;
        CommandLine commandLine = null;
        try {
            options = this.createCommandLineOptions();
            commandLine = this.parseCommandLine(args, options);
        }
        catch (ParseException ex) {
            this.printUsageInfo(options);
            System.exit(2);
        }
        if (this.validateCommandLine(commandLine)) {
            System.exit(2);
        }
        try {
            this.initialize(commandLine);
        }
        catch (Exception ex) {
            System.out.println("\nFailed to initialize master controller: " + ex.getMessage());
            log.error("Failed to initialize master controller:", (Throwable)ex);
            System.exit(1);
        }
        try {
            this.ui.run();
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("\nFailed to run master controller: " + ex.getMessage());
            log.error("Failed to run master controller:", (Throwable)ex);
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.run(args);
    }

    private static enum ResultDataTypes {
        logs,
        resultbrowsers,
        measurements;


        public static String[] validate(String valueString) {
            ArrayList<String> unknown = new ArrayList<String>();
            for (String arg : ResultDataTypes.parse(valueString)) {
                try {
                    ResultDataTypes.valueOf(arg);
                }
                catch (IllegalArgumentException e) {
                    unknown.add(arg);
                }
            }
            return unknown.toArray(new String[unknown.size()]);
        }

        public static TestResultAmount asTestResultAmount(String valueString) {
            EnumSet<ResultDataTypes> selection = EnumSet.noneOf(ResultDataTypes.class);
            for (String arg : ResultDataTypes.parse(valueString)) {
                ResultDataTypes dataType = (ResultDataTypes)EnumUtils.getEnum(ResultDataTypes.class, (String)arg);
                if (dataType == null) continue;
                selection.add(dataType);
            }
            boolean withLogs = selection.contains((Object)logs);
            boolean withResultBrowsers = selection.contains((Object)resultbrowsers);
            boolean withMeasurements = selection.contains((Object)measurements);
            TestResultAmount resultAmount = TestResultAmount.ALL;
            if (withLogs) {
                if (!withResultBrowsers) {
                    resultAmount = withMeasurements ? TestResultAmount.MEASUREMENTS_AND_LOGS : TestResultAmount.LOGS_ONLY;
                } else if (!withMeasurements) {
                    resultAmount = TestResultAmount.RESULTBROWSER_AND_LOGS;
                }
            } else {
                resultAmount = withResultBrowsers ? (withMeasurements ? TestResultAmount.MEASUREMENTS_AND_RESULTBROWSER : TestResultAmount.RESULTBROWSER_ONLY) : (withMeasurements ? TestResultAmount.MEASUREMENTS_ONLY : TestResultAmount.CANCEL);
            }
            return resultAmount;
        }

        private static String[] parse(String valueString) {
            String[] values = StringUtils.split((String)valueString, (char)',');
            if (values != null) {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = values[i].trim();
                }
            }
            return values;
        }
    }
}

