/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.mastercontroller.AgentControllerConnectionInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.FileUtils;

public class MasterControllerConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.mastercontroller.";
    private static final String PROP_AGENT_CONTROLLER_URL_SUFFIX = ".url";
    private static final String PROP_AGENT_CONTROLLER_WEIGHT_SUFFIX = ".weight";
    private static final String PROP_AGENT_CONTROLLER_AGENTS_SUFFIX = ".agents";
    private static final String PROP_AGENT_CONTROLLER_CLIENTPERF_SUFFIX = ".clientPerformance";
    private static final String PROP_AGENT_CONTROLLERS_PREFIX = "com.xceptance.xlt.mastercontroller.agentcontrollers.";
    private static final String PROP_AGENT_CONTROLLER_DEFAULT_PREFIX = "com.xceptance.xlt.mastercontroller.agentcontrollers.default.";
    private static final String PROP_AGENT_CONTROLLER_DEFAULT_AGENTS = "com.xceptance.xlt.mastercontroller.agentcontrollers.default.agents";
    private static final String PROP_AGENT_CONTROLLER_DEFAULT_WEIGHT = "com.xceptance.xlt.mastercontroller.agentcontrollers.default.weight";
    private static final String PROP_AGENT_CONTROLLER_DEFAULT_CP = "com.xceptance.xlt.mastercontroller.agentcontrollers.default.clientPerformance";
    private static final String PROP_AGENT_FILES_DIR = "com.xceptance.xlt.mastercontroller.agentfiles";
    private static final String PROP_TEST_SUITE_PATH = "com.xceptance.xlt.mastercontroller.testSuitePath";
    private static final String PROP_REPORTS_ROOT_DIR = "com.xceptance.xlt.mastercontroller.reports";
    private static final String PROP_RESULTS_ROOT_DIR = "com.xceptance.xlt.mastercontroller.results";
    private static final String PROP_UI_STATUS_PREFIX = "com.xceptance.xlt.mastercontroller.ui.status.";
    private static final String PROP_UI_STATUS_SHOW_DETAILED = "com.xceptance.xlt.mastercontroller.ui.status.detailedList";
    private static final String PROP_UI_STATUS_UPDATE_INTERVAL = "com.xceptance.xlt.mastercontroller.ui.status.updateInterval";
    private static final String PROP_IGNORE_UNREACHABLE_AGENT_CONTROLLERS = "com.xceptance.xlt.mastercontroller.ignoreUnreachableAgentControllers";
    private static final String PROP_HTTPS_PROXY = "com.xceptance.xlt.mastercontroller.https.proxy";
    private static final String PROP_HTTPS_PROXY_ENABLED = "com.xceptance.xlt.mastercontroller.https.proxy.enabled";
    private static final String PROP_HTTPS_PROXY_HOST = "com.xceptance.xlt.mastercontroller.https.proxy.host";
    private static final String PROP_HTTPS_PROXY_PORT = "com.xceptance.xlt.mastercontroller.https.proxy.port";
    private static final String PROP_HTTPS_PROXY_BYPASS_HOSTS = "com.xceptance.xlt.mastercontroller.https.proxy.bypassForHosts";
    private static final String PROP_TEMP_DIR = "com.xceptance.xlt.mastercontroller.tempdir";
    private static final String PROP_MAX_PARALLEL_COMMUNICATIONS = "com.xceptance.xlt.mastercontroller.maxParallelCommunications";
    private static final String PROP_MAX_PARALLEL_UPLOADS = "com.xceptance.xlt.mastercontroller.maxParallelUploads";
    private static final String PROP_MAX_PARALLEL_DOWNLOADS = "com.xceptance.xlt.mastercontroller.maxParallelDownloads";
    private static final String PROP_CONNECT_TIMEOUT = "com.xceptance.xlt.mastercontroller.connectTimeout";
    private static final String PROP_READ_TIMEOUT = "com.xceptance.xlt.mastercontroller.readTimeout";
    private static final String PROP_INITIAL_RESPONSE_TIMEOUT = "com.xceptance.xlt.mastercontroller.initialResponseTimeout";
    private static final String PROP_PASSWORD = "com.xceptance.xlt.mastercontroller.password";
    private static final String PROP_COMPRESSED_TIMER_FILES = "com.xceptance.xlt.mastercontroller.compressedTimerFiles";
    private final List<AgentControllerConnectionInfo> agentControllerConnectionInfos;
    private File agentFilesDirectory;
    private final File configDirectory;
    private final File homeDirectory;
    private final boolean showDetailedStatusList;
    private final int statusListUpdateInterval;
    private File testReportsRootDirectory;
    private File testResultsRootDirectory;
    private File tempDirectory;
    private final boolean isAgentControllerConnectionRelaxed;
    private final boolean isHttpsProxyEnabled;
    private final String httpsProxyHost;
    private final String httpsProxyPort;
    private final String httpsProxyBypassHosts;
    private int defaultWeight = 1;
    private int defaultAgentCount = 1;
    private final int parallelCommunicationLimit;
    private final int parallelDownloadLimit;
    private final int parallelUploadLimit;
    private final int acConnectTimeout;
    private final int acReadTimeout;
    private final int acInitialResponseTimeout;
    private File resultOutputDirectory;
    private final String userName;
    private final String password;
    private final boolean isEmbedded;
    private final boolean compressedTimerFiles;

    public MasterControllerConfiguration(File overridePropertyFile, Properties commandLineProperties, boolean isEmbeddedMode) throws IOException {
        this.isEmbedded = isEmbeddedMode;
        this.homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        File propFile = new File(this.configDirectory, "mastercontroller.properties");
        this.loadProperties(propFile);
        if (overridePropertyFile != null) {
            if (!overridePropertyFile.isFile() || !overridePropertyFile.canRead()) {
                throw new FileNotFoundException(overridePropertyFile.getAbsolutePath());
            }
            this.loadProperties(overridePropertyFile);
        }
        this.addProperties(commandLineProperties);
        String agentFilesPropertyName = PROP_TEST_SUITE_PATH;
        this.agentFilesDirectory = this.getFileProperty(PROP_TEST_SUITE_PATH, null);
        if (this.agentFilesDirectory == null) {
            agentFilesPropertyName = PROP_AGENT_FILES_DIR;
            this.agentFilesDirectory = this.getFileProperty(PROP_AGENT_FILES_DIR);
        }
        if (!this.agentFilesDirectory.isAbsolute()) {
            this.agentFilesDirectory = new File(this.homeDirectory, this.agentFilesDirectory.getPath());
        }
        if (!this.agentFilesDirectory.isDirectory()) {
            throw new RuntimeException("The property '" + agentFilesPropertyName + "' does not specify an existing directory.");
        }
        this.testReportsRootDirectory = this.getFileProperty(PROP_REPORTS_ROOT_DIR, new File("reports"));
        if (!this.testReportsRootDirectory.isAbsolute()) {
            this.testReportsRootDirectory = new File(this.homeDirectory, this.testReportsRootDirectory.getPath());
        }
        this.testResultsRootDirectory = this.getFileProperty(PROP_RESULTS_ROOT_DIR, new File("results"));
        if (!this.testResultsRootDirectory.isAbsolute()) {
            this.testResultsRootDirectory = new File(this.homeDirectory, this.testResultsRootDirectory.getPath());
        }
        this.tempDirectory = this.getFileProperty(PROP_TEMP_DIR, new File(System.getProperty("java.io.tmpdir")));
        if (!this.tempDirectory.isAbsolute()) {
            this.tempDirectory = new File(this.homeDirectory, this.tempDirectory.getPath());
        }
        if (!this.tempDirectory.exists()) {
            FileUtils.forceMkdir((File)this.tempDirectory);
        } else if (!this.tempDirectory.isDirectory() || !this.tempDirectory.canWrite()) {
            throw new IOException("Temp directory is not a directory or is not writable: " + this.tempDirectory.getCanonicalPath());
        }
        this.parallelCommunicationLimit = this.getIntProperty(PROP_MAX_PARALLEL_COMMUNICATIONS, -1);
        this.parallelUploadLimit = this.getIntProperty(PROP_MAX_PARALLEL_UPLOADS, this.parallelCommunicationLimit);
        this.parallelDownloadLimit = this.getIntProperty(PROP_MAX_PARALLEL_DOWNLOADS, this.parallelCommunicationLimit);
        this.agentControllerConnectionInfos = this.readAgentControllerConnectionInfos();
        if (!isEmbeddedMode && this.agentControllerConnectionInfos.isEmpty()) {
            throw new RuntimeException("No agent controllers are configured.");
        }
        this.isHttpsProxyEnabled = this.getBooleanProperty(PROP_HTTPS_PROXY_ENABLED, false);
        this.httpsProxyHost = this.getStringProperty(PROP_HTTPS_PROXY_HOST, "");
        this.httpsProxyPort = this.getStringProperty(PROP_HTTPS_PROXY_PORT, "");
        this.httpsProxyBypassHosts = this.getStringProperty(PROP_HTTPS_PROXY_BYPASS_HOSTS, "");
        this.showDetailedStatusList = this.getBooleanProperty(PROP_UI_STATUS_SHOW_DETAILED, false);
        this.statusListUpdateInterval = this.getIntProperty(PROP_UI_STATUS_UPDATE_INTERVAL, 5);
        this.isAgentControllerConnectionRelaxed = this.getBooleanProperty(PROP_IGNORE_UNREACHABLE_AGENT_CONTROLLERS, false);
        this.acConnectTimeout = this.getIntProperty(PROP_CONNECT_TIMEOUT, -1);
        this.acReadTimeout = this.getIntProperty(PROP_READ_TIMEOUT, -1);
        this.acInitialResponseTimeout = this.getIntProperty(PROP_INITIAL_RESPONSE_TIMEOUT, -1);
        this.userName = "xlt";
        this.password = this.getStringProperty(PROP_PASSWORD, null);
        this.compressedTimerFiles = this.getBooleanProperty(PROP_COMPRESSED_TIMER_FILES, true);
    }

    public List<AgentControllerConnectionInfo> getAgentControllerConnectionInfos() {
        return this.agentControllerConnectionInfos;
    }

    public File getAgentFilesDirectory() {
        return this.agentFilesDirectory;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public File getTestReportsRootDirectory() {
        return this.testReportsRootDirectory;
    }

    public File getTestResultsRootDirectory() {
        return this.testResultsRootDirectory;
    }

    private List<AgentControllerConnectionInfo> readAgentControllerConnectionInfos() {
        ArrayList<AgentControllerConnectionInfo> infos = new ArrayList<AgentControllerConnectionInfo>();
        this.defaultAgentCount = this.getIntProperty(PROP_AGENT_CONTROLLER_DEFAULT_AGENTS, this.defaultAgentCount);
        this.defaultWeight = this.getIntProperty(PROP_AGENT_CONTROLLER_DEFAULT_WEIGHT, this.defaultWeight);
        boolean defaultCP = this.getBooleanProperty(PROP_AGENT_CONTROLLER_DEFAULT_CP, false);
        Set<String> agentControllerNames = this.getPropertyKeyFragment(PROP_AGENT_CONTROLLERS_PREFIX);
        HashMap<String, String> urlToNameMap = new HashMap<String, String>(agentControllerNames.size());
        for (String name : agentControllerNames) {
            URL url;
            if (name.equals("default") || (url = this.getUrlProperty(PROP_AGENT_CONTROLLERS_PREFIX + name + PROP_AGENT_CONTROLLER_URL_SUFFIX, null)) == null) continue;
            String urlString = url.toString();
            String acName = (String)urlToNameMap.get(urlString);
            if (acName != null) {
                String errMsg = String.format("Agent controllers '%s' and '%s' share the same URL (%s). Each agent controller needs to have a unique URL.", name, acName, urlString);
                throw new RuntimeException(errMsg);
            }
            int agentCount = this.getIntProperty(PROP_AGENT_CONTROLLERS_PREFIX + name + PROP_AGENT_CONTROLLER_AGENTS_SUFFIX, this.defaultAgentCount);
            if (agentCount <= 0) continue;
            int weight = this.getIntProperty(PROP_AGENT_CONTROLLERS_PREFIX + name + PROP_AGENT_CONTROLLER_WEIGHT_SUFFIX, this.defaultWeight);
            if (weight <= 0) {
                throw new RuntimeException("The value of property 'com.xceptance.xlt.mastercontroller.agentcontrollers." + name + ".weight' must be greater than 0.");
            }
            boolean runsCPTests = this.getBooleanProperty(PROP_AGENT_CONTROLLERS_PREFIX + name + PROP_AGENT_CONTROLLER_CLIENTPERF_SUFFIX, defaultCP);
            AgentControllerConnectionInfo info = new AgentControllerConnectionInfo();
            info.setUrl(url);
            info.setWeight(weight);
            info.setName(name);
            info.setNumberOfAgents(agentCount);
            info.setRunsClientPerformanceTests(runsCPTests);
            infos.add(info);
            urlToNameMap.put(urlString, name);
        }
        return infos;
    }

    public boolean getShowDetailedStatusList() {
        return this.showDetailedStatusList;
    }

    public int getStatusListUpdateInterval() {
        return this.statusListUpdateInterval;
    }

    public boolean isAgentControllerConnectionRelaxed() {
        return this.isAgentControllerConnectionRelaxed;
    }

    public boolean isHttpsProxyEnabled() {
        return this.isHttpsProxyEnabled;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public String getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public String getHttpsProxyBypassHosts() {
        return this.httpsProxyBypassHosts;
    }

    public int getDefaultAgentCount() {
        return this.defaultAgentCount;
    }

    public int getDefaultWeight() {
        return this.defaultWeight;
    }

    public int getParallelCommunicationLimit() {
        return this.parallelCommunicationLimit;
    }

    public int getParallelUploadLimit() {
        return this.parallelUploadLimit;
    }

    public int getParallelDownloadLimit() {
        return this.parallelDownloadLimit;
    }

    public int getAgentControllerConnectTimeout() {
        return this.acConnectTimeout;
    }

    public int getAgentControllerReadTimeout() {
        return this.acReadTimeout;
    }

    public int getAgentControllerInitialResponseTimeout() {
        return this.acInitialResponseTimeout;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public File getResultOutputDirectory() {
        return this.resultOutputDirectory;
    }

    public void setResultOutputDirectory(String outputDirectory) {
        File outDir = new File(outputDirectory);
        if (!outDir.isAbsolute()) {
            outDir = new File(this.testResultsRootDirectory, outputDirectory);
        }
        try {
            FileUtils.forceMkdir((File)outDir);
            com.xceptance.common.io.FileUtils.cleanDirRelaxed(outDir);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create or clean result output directory '" + outputDirectory + "'", ioe);
        }
        this.resultOutputDirectory = outDir;
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean isCompressedTimerFiles() {
        return this.compressedTimerFiles;
    }
}

