/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.xlt.common.XltConstants;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.LineChunk;
import com.xceptance.xlt.report.LogReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataRecordReader
implements Runnable {
    private static final int CHUNK_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(LogReader.class);
    private final ConcurrentSkipListMap<Long, String> actionNames = new ConcurrentSkipListMap();
    private final String agentName;
    private final FileObject directory;
    private final String testCaseName;
    private final AtomicLong totalLineCounter;
    private final String userNumber;
    private final Dispatcher dispatcher;

    public DataRecordReader(FileObject directory, String agentName, String testCaseName, String userNumber, AtomicLong totalLineCounter, Dispatcher dispatcher) {
        this.directory = directory;
        this.agentName = agentName;
        this.testCaseName = testCaseName;
        this.userNumber = userNumber;
        this.totalLineCounter = totalLineCounter;
        this.dispatcher = dispatcher;
    }

    @Override
    public void run() {
        try {
            this.dispatcher.beginReading();
            this.readLogsFromTestUserDir();
        }
        catch (Exception e) {
            String msg = String.format("Failed to read test results from directory '%s': %s", this.directory, e);
            LOG.error(msg);
            System.out.println(msg);
        }
        finally {
            this.dispatcher.finishedReading();
        }
    }

    private void readLogsFromTestUserDir() throws Exception {
        ArrayList<FileObject> regularTimerFiles = new ArrayList<FileObject>();
        ArrayList<FileObject> clientPerformanceTimerFiles = new ArrayList<FileObject>();
        for (FileObject file : this.directory.getChildren()) {
            if (file.getType() != FileType.FILE || !file.isReadable()) continue;
            String fileName = file.getName().getBaseName();
            if (XltConstants.TIMER_FILENAME_PATTERNS.stream().anyMatch(r -> r.asPredicate().test(fileName))) {
                regularTimerFiles.add(file);
                continue;
            }
            if (!XltConstants.CPT_TIMER_FILENAME_PATTERNS.stream().anyMatch(r -> r.asPredicate().test(fileName))) continue;
            clientPerformanceTimerFiles.add(file);
        }
        boolean haveClientPerformanceTimerFiles = !clientPerformanceTimerFiles.isEmpty();
        for (FileObject file : regularTimerFiles) {
            this.readTimerLog(file, haveClientPerformanceTimerFiles, false);
        }
        if (haveClientPerformanceTimerFiles) {
            for (FileObject file : clientPerformanceTimerFiles) {
                this.readTimerLog(file, false, true);
            }
        }
    }

    private void readTimerLog(FileObject file, boolean collectActionNames, boolean adjustTimerName) {
        boolean isCompressed = "gz".equalsIgnoreCase(file.getName().getExtension());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(isCompressed ? new GZIPInputStream(file.getContent().getInputStream()) : file.getContent().getInputStream(), "UTF-8"));){
            ArrayList<String> lines = new ArrayList<String>(1000);
            int baseLineNumber = 1;
            int linesRead = 0;
            String line = reader.readLine();
            while (line != null) {
                lines.add(line);
                if (++linesRead == 1000) {
                    this.buildAndSubmitLineChunk(lines, baseLineNumber, file, collectActionNames, adjustTimerName);
                    lines = new ArrayList(1000);
                    baseLineNumber += linesRead;
                    this.totalLineCounter.addAndGet(linesRead);
                    linesRead = 0;
                }
                line = reader.readLine();
            }
            if (linesRead > 0) {
                this.buildAndSubmitLineChunk(lines, baseLineNumber, file, collectActionNames, adjustTimerName);
                this.totalLineCounter.addAndGet(linesRead);
            }
        }
        catch (Exception ex) {
            String msg = String.format("Failed to read file '%s': %s\n", file, ex.getMessage());
            LOG.error(msg);
            System.out.println(msg);
        }
    }

    private void buildAndSubmitLineChunk(List<String> lines, int baseLineNumber, FileObject file, boolean collectActionNames, boolean adjustTimerName) throws InterruptedException {
        LineChunk lineChunk = new LineChunk(lines, baseLineNumber, file, this.agentName, this.testCaseName, this.userNumber, collectActionNames, adjustTimerName, this.actionNames);
        this.dispatcher.addNewLineChunk(lineChunk);
    }
}

