/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external.converter;

import com.xceptance.xlt.api.report.ReportCreator;
import com.xceptance.xlt.report.external.config.ChartConfig;
import com.xceptance.xlt.report.external.converter.ConverterConfiguration;
import com.xceptance.xlt.report.util.JFreeChartUtils;
import com.xceptance.xlt.report.util.TimeSeriesConfiguration;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;

public abstract class AbstractDataConverter
implements ReportCreator {
    private ConverterConfiguration config;

    public abstract void parse(long var1, Map<String, Object> var3) throws IllegalArgumentException;

    protected void createFloatingChart(List<List<TimeSeriesConfiguration>> axisCollections, ChartConfig chartConfig, String fileName) {
        JFreeChart chart = JFreeChartUtils.createBasicLineChart(chartConfig.getTitle(), chartConfig.getXAxisTitle(), this.getConfiguration().getChartStartTime(), this.getConfiguration().getChartEndTime());
        for (int axisIndex = 0; axisIndex < axisCollections.size(); ++axisIndex) {
            if (axisCollections.get(axisIndex).isEmpty()) continue;
            String yAxisTitle = axisIndex < 1 ? chartConfig.getYAxisTitle() : chartConfig.getYAxisTitle2();
            JFreeChartUtils.setAxisTimeSeriesCollection(chart, axisIndex, yAxisTitle, axisCollections.get(axisIndex));
        }
        JFreeChartUtils.saveChart(chart, fileName, this.getConfiguration().getExternalChartsDir(), this.getConfiguration().getChartWidth(), this.getConfiguration().getChartHeight());
    }

    public ConverterConfiguration getConfiguration() {
        return this.config;
    }

    public void setConfiguration(ConverterConfiguration config) {
        this.config = config;
    }
}

