/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.report.providers.ContentTypeReport;
import com.xceptance.xlt.report.providers.ContentTypesReport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ContentTypesReportProvider
extends AbstractReportProvider {
    private final Map<String, ContentTypeReport> contentTypeReports = new HashMap<String, ContentTypeReport>();

    @Override
    public Object createReportFragment() {
        ContentTypesReport report = new ContentTypesReport();
        report.contentTypes = new ArrayList<ContentTypeReport>(this.contentTypeReports.values());
        return report;
    }

    @Override
    public void processDataRecord(Data stat) {
        if (stat instanceof RequestData) {
            ContentTypeReport contentTypeReport;
            RequestData reqStats = (RequestData)stat;
            String contentType = reqStats.getContentType();
            if (StringUtils.isBlank((CharSequence)contentType)) {
                contentType = "(none)";
            }
            if ((contentTypeReport = this.contentTypeReports.get(contentType)) == null) {
                contentTypeReport = new ContentTypeReport();
                contentTypeReport.contentType = contentType;
                this.contentTypeReports.put(contentType, contentTypeReport);
            }
            ++contentTypeReport.count;
        }
    }
}

