/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.io;

import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.provider.local.LocalFile;
import org.apache.http.client.utils.URIBuilder;

public final class FileUtils {
    private static final String DIRECTORY_IS_NULL = "Directory is null.";
    private static final String NOT_A_DIRECTORY = "Not a directory: ";
    private static final char[] CHARS_2B_ESCAPED = new char[]{'/', '\\', '<', '>', '|', '*', '?', ':', '\"', ';', ',', '%', '#', '$'};

    private FileUtils() {
    }

    public static void copyFile(File source, File target) throws IOException {
        if (source == null) {
            throw new IllegalArgumentException("Source file is null.");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target file is null.");
        }
        if (!source.isFile()) {
            throw new IllegalArgumentException("Not a valid file: " + source);
        }
        if (!target.isDirectory() && !target.isFile()) {
            throw new IllegalArgumentException("Neither a file nor a directory: " + target);
        }
        if (target.isDirectory()) {
            org.apache.commons.io.FileUtils.copyFileToDirectory((File)source, (File)target);
        } else {
            org.apache.commons.io.FileUtils.copyFile((File)source, (File)target);
        }
    }

    public static void copyDirectory(File sourceDir, File targetDir, boolean contentOnly) throws IOException {
        File[] files;
        if (sourceDir == null) {
            throw new IllegalArgumentException("Source directory is null.");
        }
        if (targetDir == null) {
            throw new IllegalArgumentException("Target directory is null.");
        }
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException(NOT_A_DIRECTORY + sourceDir);
        }
        if (!targetDir.isDirectory()) {
            throw new IllegalArgumentException(NOT_A_DIRECTORY + targetDir);
        }
        File toDir = targetDir;
        if (!contentOnly) {
            toDir = new File(targetDir, sourceDir.getName());
            org.apache.commons.io.FileUtils.forceMkdir((File)toDir);
        }
        for (File file : files = FileUtils.listFiles(sourceDir, false)) {
            if (file.isFile()) {
                FileUtils.copyFile(file, toDir);
                continue;
            }
            if (!file.isDirectory()) continue;
            FileUtils.copyDirectory(file, toDir, false);
        }
    }

    public static void deleteFilesFromDirectory(File directory) throws IOException {
        FileUtils.deleteFilesFromDirectory(directory, null);
    }

    public static void deleteFilesFromDirectory(File directory, FileFilter fileFilter) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException(DIRECTORY_IS_NULL);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(NOT_A_DIRECTORY + directory);
        }
        File[] files = directory.listFiles(fileFilter);
        if (files != null) {
            for (File file : files) {
                org.apache.commons.io.FileUtils.forceDelete((File)file);
            }
        }
    }

    public static void deleteFile(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("File is null.");
        }
        if (file.exists()) {
            org.apache.commons.io.FileUtils.forceDelete((File)file);
        }
    }

    public static File[] listFiles(File directory, boolean recursively) throws IOException {
        return FileUtils.listFiles(directory, recursively, null);
    }

    public static File[] listFiles(File directory, boolean recursively, FilenameFilter filter) throws IOException {
        if (directory == null) {
            throw new IllegalArgumentException(DIRECTORY_IS_NULL);
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(NOT_A_DIRECTORY + directory);
        }
        if (recursively) {
            File[] files = directory.listFiles();
            ArrayList<File> result = new ArrayList<File>();
            if (files != null) {
                for (File file : files) {
                    if (filter == null || filter.accept(directory, file.getName())) {
                        result.add(file);
                    }
                    if (!file.isDirectory()) continue;
                    File[] subDirFiles = FileUtils.listFiles(file, recursively, filter);
                    result.addAll(new ArrayList<File>(Arrays.asList(subDirFiles)));
                }
            }
            return result.toArray(new File[result.size()]);
        }
        File[] files = directory.listFiles(filter);
        if (files == null) {
            throw new IOException("Failed to list directory: " + directory);
        }
        return files;
    }

    public static String replaceIllegalCharsInFileName(String fileName) {
        ParameterCheckUtils.isNotNull(fileName, "fileName");
        char[] chars = fileName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            for (char illegalChar : CHARS_2B_ESCAPED) {
                if (chars[i] != illegalChar) continue;
                chars[i] = 95;
            }
        }
        return new String(chars);
    }

    public static String convertIllegalCharsInFileName(String fileName) {
        ParameterCheckUtils.isNotNull(fileName, "fileName");
        int offset = 10;
        StringBuilder converted = new StringBuilder(fileName.length() + 10);
        for (char c : fileName.toCharArray()) {
            converted.append(FileUtils.convertCharacter(c));
        }
        return converted.toString();
    }

    private static String convertCharacter(char c) {
        int bitMask = 255;
        for (char illegalChar : CHARS_2B_ESCAPED) {
            if (c != illegalChar) continue;
            return String.format("$%02x", c % 255);
        }
        return Character.toString(c);
    }

    public static boolean deleteDirectoryRelaxed(File file) throws IOException, IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        return FileUtils.deleteDirectoryRelaxed(file, false);
    }

    public static boolean cleanDirRelaxed(File dir) throws IOException, IllegalArgumentException {
        if (dir == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        if (dir.isFile()) {
            throw new IllegalArgumentException("File must be a directory.");
        }
        return FileUtils.deleteDirectoryRelaxed(dir, true);
    }

    private static boolean deleteDirectoryRelaxed(File file, boolean clearOnly) throws IOException {
        boolean isRemoved = false;
        if (!file.exists()) {
            isRemoved = true;
        } else if (file.isDirectory()) {
            boolean isClear = true;
            File[] childs = file.listFiles();
            if (childs != null) {
                for (File child : childs) {
                    if (FileUtils.deleteDirectoryRelaxed(child, false)) continue;
                    isClear = false;
                }
            }
            if (isClear) {
                isRemoved = true;
                if (!clearOnly) {
                    isRemoved = file.delete();
                }
            }
        } else {
            if (!file.delete()) {
                throw new IOException("unable to delete file " + file.getAbsolutePath());
            }
            isRemoved = true;
        }
        return isRemoved;
    }

    public static String computeRelativeUri(File source, File target, boolean sourceIsDirectory) {
        if (source.equals(target)) {
            return sourceIsDirectory ? "." : "./" + source.getName();
        }
        String[] sourcePathParts = StringUtils.split((String)FileUtils.getCanonicalPath(source), (char)File.separatorChar);
        Object[] targetPathParts = StringUtils.split((String)FileUtils.getCanonicalPath(target), (char)File.separatorChar);
        int noCommonPathParts = 0;
        int noParts = Math.min(targetPathParts.length, sourcePathParts.length);
        for (int i = 0; i < noParts; ++i) {
            File t = new File(targetPathParts[i]);
            File s = new File(sourcePathParts[i]);
            if (t.equals(s)) continue;
            noCommonPathParts = i;
            break;
        }
        StringBuilder pathBuilder = new StringBuilder(1024);
        if (noCommonPathParts == 0 && SystemUtils.IS_OS_WINDOWS) {
            pathBuilder.append("file:///");
            pathBuilder.append(StringUtils.join((Object[])targetPathParts, (String)"/"));
        } else {
            int noLevelsToSource = sourcePathParts.length - noCommonPathParts - (sourceIsDirectory ? 0 : 1);
            if (noLevelsToSource > 0) {
                pathBuilder.append(StringUtils.repeat((String)"../", (int)noLevelsToSource));
            }
            pathBuilder.append(StringUtils.join((Object[])targetPathParts, (String)"/", (int)noCommonPathParts, (int)targetPathParts.length));
        }
        return pathBuilder.toString();
    }

    private static String getCanonicalPath(File f) {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to resolve canonical path for file '" + f.getAbsolutePath() + "': " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new RuntimeException("Failed to resolve canonical path for file '" + f.getAbsolutePath() + "': " + e.getMessage());
        }
    }

    public static File convertLocalFileToFile(LocalFile localFile) {
        File f = (File)ReflectionUtils.callMethod(LocalFile.class, localFile, "getLocalFile", new Object[0]);
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert: " + localFile.getName().getPath(), e);
        }
    }

    public static int getNumberOfAncestors(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        int returnValue = 0;
        File current = file;
        while (current.getParentFile() != null) {
            current = current.getParentFile();
            ++returnValue;
        }
        return returnValue;
    }

    public static List<File> getParents(File file, int ancestorsToSkip) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null.");
        }
        ArrayList<File> returnValue = new ArrayList<File>();
        File current = file;
        while (current.getParentFile() != null) {
            current = current.getParentFile();
            returnValue.add(0, current);
        }
        return returnValue.subList(ancestorsToSkip, returnValue.size());
    }

    public static String getCurrentWorkingDirectory() {
        return System.getProperty("user.dir");
    }

    public static URI toUri(File file) {
        ParameterCheckUtils.isNotNull(file, "file");
        try {
            return new URIBuilder(file.toURI()).setHost("").build();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to build URI from file: " + file, e);
        }
    }
}

