/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.RegExUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;

public final class PropertiesUtils {
    private static final String DELIMITER_START = "${";
    private static final String DELIMITER_STOP = "}";

    private PropertiesUtils() {
    }

    public static Properties loadProperties(File file) throws IOException {
        ParameterCheckUtils.isReadableFile(file, "file");
        return PropertiesUtils.loadProperties(VFS.getManager().toFileObject(file));
    }

    public static void loadProperties(File file, Properties props) throws IOException {
        ParameterCheckUtils.isReadableFile(file, "file");
        ParameterCheckUtils.isNotNull(props, "props");
        PropertiesUtils.loadProperties(VFS.getManager().toFileObject(file), props);
    }

    public static Properties loadProperties(FileObject file) throws IOException {
        Properties props = new Properties();
        PropertiesUtils.loadProperties(file, props);
        return props;
    }

    public static void loadProperties(FileObject file, Properties props) throws IOException {
        try {
            ParameterCheckUtils.isReadableFile(file, "file");
        }
        catch (IllegalArgumentException e) {
            throw new FileNotFoundException(file.toString());
        }
        ParameterCheckUtils.isNotNull(props, "props");
        try (InputStream is = file.getContent().getInputStream();){
            props.load(is);
        }
    }

    public static String substituteVariables(String value, Properties properties) throws IllegalArgumentException {
        ParameterCheckUtils.isNotNull(value, "value");
        ParameterCheckUtils.isNotNull(properties, "props");
        if (value.length() == 0 || properties.size() == 0) {
            return value;
        }
        return PropertiesUtils.resolveVariables(value, properties, new HashSet<String>());
    }

    private static String resolveVariables(String value, Properties props, Set<String> variables) {
        String result = value;
        List<String> matches = RegExUtils.getAllMatches(value, RegExUtils.escape(DELIMITER_START) + "(.*?)" + RegExUtils.escape(DELIMITER_STOP), 1);
        for (String key : matches) {
            if (variables.contains(key)) continue;
            variables.add(key);
            String substitution = System.getProperty(key, null);
            if (substitution == null && (substitution = props.getProperty(key)) == null) {
                substitution = System.getenv(key);
            }
            if (substitution == null) continue;
            substitution = PropertiesUtils.resolveVariables(substitution, props, new HashSet<String>(variables));
            result = RegExUtils.replaceAll(result, RegExUtils.escape(DELIMITER_START + key + DELIMITER_STOP), Matcher.quoteReplacement(substitution));
        }
        return result;
    }

    public static Map<String, String> getPropertiesForKey(String domainKey, Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (domainKey == null || domainKey.isEmpty()) {
            return result;
        }
        Object prefix = domainKey.endsWith(".") ? domainKey : domainKey + ".";
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String fullKey = (String)entry.getKey();
            String propVal = (String)entry.getValue();
            if (propVal == null || propVal.length() == 0 || !fullKey.startsWith((String)prefix) || fullKey.length() <= ((String)prefix).length()) continue;
            result.put(fullKey.substring(((String)prefix).length()), properties.getProperty(fullKey));
        }
        return result;
    }
}

