/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.actions;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.actions.AbstractWebAction;
import com.xceptance.xlt.api.actions.ElementMissingException;
import com.xceptance.xlt.api.engine.NetworkData;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.resultbrowser.RequestHistory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.HttpMethod;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebRequest;
import org.htmlunit.WebWindow;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlHiddenInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.util.NameValuePair;

public abstract class AbstractHtmlPageAction
extends AbstractWebAction {
    private static final String PROP_JS_BACKGROUND_ACTIVITY_WAITINGTIME = "com.xceptance.xlt.js.backgroundActivity.waitingTime";
    private static final long DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME = XltProperties.getInstance().getProperty("com.xceptance.xlt.js.backgroundActivity.waitingTime", -1);
    private HtmlPage htmlPage;
    private List<NetworkData> netStats = null;

    protected AbstractHtmlPageAction(AbstractWebAction previousAction, String timerName) {
        super(previousAction, timerName);
    }

    protected AbstractHtmlPageAction(String timerName) {
        this(null, timerName);
    }

    public HtmlPage getHtmlPage() {
        return this.htmlPage;
    }

    @Override
    public AbstractHtmlPageAction getPreviousAction() {
        return (AbstractHtmlPageAction)super.getPreviousAction();
    }

    @Override
    public void run() throws Throwable {
        try {
            super.run();
        }
        finally {
            this.dumpPage(this.getHtmlPage());
            Session.getCurrent().getNetworkDataManager().clear();
        }
    }

    public void setHtmlPage(HtmlPage htmlPage) {
        this.setHtmlPage(htmlPage, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    public void setHtmlPage(HtmlPage htmlPage, long waitingTime) {
        ParameterCheckUtils.isNotNull(htmlPage, "htmlPage");
        this.htmlPage = this.waitForPageIsComplete(htmlPage, waitingTime);
    }

    protected void loadPage(URL url, HttpMethod method, List<NameValuePair> requestParameters, long waitingTime) throws Exception {
        WebRequest webRequest = this.createWebRequestSettings(url, method, requestParameters);
        Object result = this.getWebClient().getPage(webRequest);
        this.htmlPage = this.waitForPageIsComplete((Page)result, waitingTime);
    }

    protected void loadPage(URL url, HttpMethod method, List<NameValuePair> requestParameters) throws Exception {
        this.loadPage(url, method, requestParameters, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPage(URL url, long waitingTime) throws Exception {
        this.loadPage(url, HttpMethod.GET, EMPTY_PARAMETER_LIST, waitingTime);
    }

    protected void loadPage(URL url) throws Exception {
        this.loadPage(url, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPage(String urlAsString, long waitingTime) throws Exception {
        URL url = new URL(urlAsString);
        this.loadPage(url, waitingTime);
    }

    protected void loadPage(String urlAsString) throws Exception {
        this.loadPage(urlAsString, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageByClick(HtmlElement element, long waitingTime) throws Exception {
        Object result = element.click();
        this.htmlPage = this.waitForPageIsComplete((Page)result, waitingTime);
    }

    protected void loadPageByClick(HtmlElement element) throws Exception {
        this.loadPageByClick(element, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageByDragAndDrop(HtmlElement draggable, HtmlElement dropTarget, long waitingTime) throws Exception {
        draggable.mouseDown();
        dropTarget.mouseMove();
        Page result = dropTarget.mouseUp();
        this.htmlPage = this.waitForPageIsComplete(result, waitingTime);
    }

    protected void loadPageByDragAndDrop(HtmlElement draggable, HtmlElement dropTarget) throws Exception {
        this.loadPageByDragAndDrop(draggable, dropTarget, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    @Deprecated
    protected void loadPageByFormClick(HtmlForm form, String elementToClick, boolean randomPosition, long waitingTime) throws Exception {
        this.loadPageByFormClick(form, elementToClick, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    @Deprecated
    protected void loadPageByFormClick(HtmlForm form, String elementToClick, boolean randomPosition) throws Exception {
        this.loadPageByFormClick(form, elementToClick);
    }

    protected void loadPageByFormClick(HtmlForm form, String elementToClick, long waitingTime) throws Exception {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        elements.addAll(form.getInputsByName(elementToClick));
        elements.addAll(form.getButtonsByName(elementToClick));
        if (elements.isEmpty()) {
            elements.add((HtmlElement)((HtmlPage)form.getPage()).getHtmlElementById(elementToClick));
        }
        DomElement element2Click = null;
        for (int i = 0; i < elements.size(); ++i) {
            HtmlElement input = (HtmlElement)elements.get(i);
            if (input instanceof HtmlHiddenInput) continue;
            element2Click = input;
            break;
        }
        if (element2Click == null) {
            throw new ElementMissingException("No element with name '" + elementToClick + "' found that can be clicked on.");
        }
        Object result = element2Click.click();
        this.htmlPage = this.waitForPageIsComplete((Page)result, waitingTime);
    }

    protected void loadPageByFormClick(HtmlForm form, String elementToClick) throws Exception {
        this.loadPageByFormClick(form, elementToClick, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageBySelect(HtmlSelect select, String optionValue) throws Exception {
        this.loadPageBySelect(select, optionValue, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageBySelect(HtmlSelect select, String optionValue, long waitingTime) throws Exception {
        Object result = select.setSelectedAttribute(optionValue, true);
        this.htmlPage = this.waitForPageIsComplete((Page)result, waitingTime);
    }

    protected void loadPageBySelect(HtmlSelect select, HtmlOption option) {
        Object result = select.setSelectedAttribute(option, true);
        this.htmlPage = this.waitForPageIsComplete((Page)result, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageBySelect(HtmlSelect select, HtmlOption option, long waitingTime) throws Exception {
        Object result = select.setSelectedAttribute(option, true);
        this.htmlPage = this.waitForPageIsComplete((Page)result, waitingTime);
    }

    protected void loadPageByFormSubmit(HtmlForm form, SubmittableElement element, long waitingTime) throws Exception {
        Method submitMethod = HtmlForm.class.getDeclaredMethod("submit", SubmittableElement.class);
        submitMethod.setAccessible(true);
        try {
            submitMethod.invoke((Object)form, element);
            WebWindow w = this.getWebClient().getCurrentWindow();
            this.getWebClient().getJavaScriptEngine().processPostponedActions();
            this.htmlPage = this.waitForPageIsComplete(w.getEnclosedPage(), waitingTime);
        }
        catch (InvocationTargetException te) {
            Throwable cause = te.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new XltException("Failed to submit form", cause);
        }
    }

    protected void loadPageByFormSubmit(HtmlForm form, SubmittableElement element) throws Exception {
        this.loadPageByFormSubmit(form, element, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageByFormSubmit(HtmlForm form, long waitingTime) throws Exception {
        this.loadPageByFormSubmit(form, null, waitingTime);
    }

    protected void loadPageByFormSubmit(HtmlForm form) throws Exception {
        this.loadPageByFormSubmit(form, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    protected void loadPageByTypingKeys(HtmlElement element, String text, long waitingTime) throws Exception {
        Page result = element.getPage();
        for (char ch : text.toCharArray()) {
            result = element.type(ch);
        }
        this.htmlPage = this.waitForPageIsComplete(result, waitingTime);
    }

    protected void loadPageByTypingKeys(HtmlElement element, String text) throws Exception {
        this.loadPageByTypingKeys(element, text, DEFAULT_JS_BACKGROUND_ACTIVITY_WAITINGTIME);
    }

    private HtmlPage waitForPageIsComplete(Page page, long waitingTime) {
        Page enclosedPage;
        if (page instanceof SgmlPage) {
            XltWebClient webClient = (XltWebClient)((SgmlPage)page).getWebClient();
            webClient.waitForBackgroundThreads(page.getEnclosingWindow().getTopWindow().getEnclosedPage(), waitingTime);
        }
        if (!((enclosedPage = page.getEnclosingWindow().getTopWindow().getEnclosedPage()) instanceof HtmlPage)) {
            throw new XltException("The server response could not be parsed as HTML.");
        }
        HtmlPage newHtmlPage = (HtmlPage)enclosedPage;
        ((XltWebClient)newHtmlPage.getWebClient()).loadNewStaticContent(newHtmlPage);
        this.collectAndSetNetworkData();
        return newHtmlPage;
    }

    private void dumpPage(HtmlPage htmlPage) {
        String timerName = ((XltWebClient)this.getWebClient()).getTimerName();
        RequestHistory requestHistory = SessionImpl.getCurrent().getRequestHistory();
        if (htmlPage != null) {
            requestHistory.add(timerName, htmlPage);
        } else {
            requestHistory.add(timerName);
        }
    }

    private void collectAndSetNetworkData() {
        this.netStats = Session.getCurrent().getNetworkDataManager().getData();
    }

    protected List<NetworkData> getNetworkDataSet() {
        return this.netStats;
    }
}

