/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.common.lang.StringHasher;
import com.xceptance.xlt.api.engine.TimerData;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.util.UrlHostParser;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class RequestData
extends TimerData {
    private static final char TYPE_CODE = 'R';
    private static final char IP_ADDRESSES_SEPARATOR = '|';
    public static final XltCharBuffer UNKNOWN_HOST = XltCharBuffer.valueOf("(unknown)");
    private int bytesReceived;
    private int bytesSent;
    private int connectTime;
    private XltCharBuffer contentType;
    private int receiveTime;
    private int responseCode;
    private int sendTime;
    private int serverBusyTime;
    private int timeToFirstBytes;
    private int timeToLastBytes;
    private int dnsTime;
    private XltCharBuffer requestId;
    private XltCharBuffer responseId;
    private XltCharBuffer url;
    private int hashCodeOfUrlWithoutFragment;
    private XltCharBuffer host;
    private XltCharBuffer httpMethod;
    private XltCharBuffer formDataEncoding;
    private XltCharBuffer formData;
    private String ipAddresses;
    private XltCharBuffer usedIpAddress;

    public RequestData() {
        super('R');
    }

    public RequestData(String name) {
        super(name, 'R');
    }

    public int getBytesReceived() {
        return this.bytesReceived;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public int getConnectTime() {
        return this.connectTime;
    }

    public XltCharBuffer getContentType() {
        return this.contentType;
    }

    public int getReceiveTime() {
        return this.receiveTime;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public int getSendTime() {
        return this.sendTime;
    }

    public int getServerBusyTime() {
        return this.serverBusyTime;
    }

    public int getTimeToFirstBytes() {
        return this.timeToFirstBytes;
    }

    public int getTimeToLastBytes() {
        return this.timeToLastBytes;
    }

    public String getRequestId() {
        return this.requestId == null ? null : this.requestId.toString();
    }

    public String getResponseId() {
        return this.responseId == null ? null : this.responseId.toString();
    }

    public XltCharBuffer getUrl() {
        return this.url;
    }

    public int hashCodeOfUrlWithoutFragment() {
        return this.hashCodeOfUrlWithoutFragment;
    }

    public XltCharBuffer getHost() {
        return this.host;
    }

    public XltCharBuffer getHttpMethod() {
        return this.httpMethod;
    }

    public XltCharBuffer getFormDataEncoding() {
        return this.formDataEncoding;
    }

    public XltCharBuffer getFormData() {
        return this.formData;
    }

    public int getDnsTime() {
        return this.dnsTime;
    }

    public String[] getIpAddresses() {
        return StringUtils.split((String)this.ipAddresses, (char)'|');
    }

    public XltCharBuffer getUsedIpAddress() {
        return this.usedIpAddress;
    }

    public void setBytesReceived(int responseSize) {
        if (responseSize < 0) {
            throw new IllegalArgumentException("Response size must not be negative: '" + responseSize + "'.");
        }
        this.bytesReceived = responseSize;
    }

    public void setBytesSent(int requestSize) {
        if (requestSize < 0) {
            throw new IllegalArgumentException("Request size must not be negative: '" + requestSize + "'.");
        }
        this.bytesSent = requestSize;
    }

    public void setConnectTime(int connectTime) {
        this.connectTime = connectTime;
    }

    public void setContentType(String contentType) {
        this.contentType = XltCharBuffer.valueOf(contentType);
    }

    public void setContentType(XltCharBuffer contentType) {
        this.contentType = contentType;
        this.contentType.hashCode();
    }

    public void setReceiveTime(int receiveTime) {
        this.receiveTime = receiveTime;
    }

    public void setRequestId(XltCharBuffer id) {
        this.requestId = id;
    }

    public void setRequestId(String id) {
        this.requestId = XltCharBuffer.valueOf(id);
    }

    public void setResponseId(XltCharBuffer id) {
        this.responseId = id;
    }

    public void setResponseId(String id) {
        this.responseId = XltCharBuffer.valueOf(id);
    }

    public void setResponseCode(int responseCode) {
        if (responseCode < 0) {
            throw new IllegalArgumentException("Response code must not be negative: " + responseCode + "'.");
        }
        this.responseCode = responseCode;
    }

    public void setSendTime(int sendTime) {
        this.sendTime = sendTime;
    }

    public void setServerBusyTime(int serverBusyTime) {
        this.serverBusyTime = serverBusyTime;
    }

    public void setTimeToFirstBytes(int timeToFirstBytes) {
        this.timeToFirstBytes = timeToFirstBytes;
    }

    public void setTimeToLastBytes(int timeToLastBytes) {
        this.timeToLastBytes = timeToLastBytes;
    }

    public void setUrl(String url) {
        this.url = XltCharBuffer.valueOf(url);
    }

    public void setUrl(XltCharBuffer url) {
        this.hashCodeOfUrlWithoutFragment = StringHasher.hashCodeWithLimit(url, '#');
        XltCharBuffer hostName = UrlHostParser.retrieveHostFromUrl(url);
        if (hostName.length() == 0) {
            this.host = UNKNOWN_HOST;
        } else {
            this.host = hostName;
            hostName.hashCode();
        }
        this.url = url;
    }

    public void setHttpMethod(XltCharBuffer httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = XltCharBuffer.valueOf(httpMethod);
    }

    public void setFormDataEncoding(XltCharBuffer encoding) {
        this.formDataEncoding = encoding;
    }

    public void setFormDataEncoding(String encoding) {
        this.formDataEncoding = XltCharBuffer.valueOf(encoding);
    }

    public void setFormData(XltCharBuffer formData) {
        this.formData = formData;
    }

    public void setFormData(String formData) {
        this.formData = XltCharBuffer.valueOf(formData);
    }

    public void setDnsTime(int dnsTime) {
        this.dnsTime = dnsTime;
    }

    public void setIpAddresses(String[] ipAddresses) {
        this.ipAddresses = StringUtils.join((Object[])ipAddresses, (char)'|');
    }

    public void setUsedIpAddress(XltCharBuffer ipAddress) {
        this.usedIpAddress = ipAddress;
    }

    public void setUsedIpAddress(String ipAddress) {
        this.usedIpAddress = XltCharBuffer.valueOf(ipAddress);
    }

    @Override
    protected List<String> addValues() {
        List<String> fields = super.addValues();
        fields.add(Integer.toString(this.bytesSent));
        fields.add(Integer.toString(this.bytesReceived));
        fields.add(Integer.toString(this.responseCode));
        fields.add(XltCharBuffer.emptyWhenNull(this.url).toString());
        fields.add(XltCharBuffer.emptyWhenNull(this.contentType).toString());
        fields.add(String.valueOf(this.connectTime));
        fields.add(String.valueOf(this.sendTime));
        fields.add(String.valueOf(this.serverBusyTime));
        fields.add(String.valueOf(this.receiveTime));
        fields.add(String.valueOf(this.timeToFirstBytes));
        fields.add(String.valueOf(this.timeToLastBytes));
        fields.add(XltCharBuffer.emptyWhenNull(this.requestId).toString());
        fields.add(XltCharBuffer.emptyWhenNull(this.httpMethod).toString());
        fields.add(XltCharBuffer.emptyWhenNull(this.formDataEncoding).toString());
        fields.add(XltCharBuffer.emptyWhenNull(this.formData).toString());
        fields.add(String.valueOf(this.dnsTime));
        fields.add(StringUtils.defaultString((String)this.ipAddresses));
        fields.add(XltCharBuffer.emptyWhenNull(this.responseId).toString());
        fields.add(XltCharBuffer.emptyWhenNull(this.usedIpAddress).toString());
        return fields;
    }

    @Override
    protected int getMinNoCSVElements() {
        return 8;
    }

    @Override
    protected void parseRemainingValues(List<XltCharBuffer> values) {
        super.parseRemainingValues(values);
        this.setBytesSent(ParseNumbers.parseInt(values.get(5)));
        this.setBytesReceived(ParseNumbers.parseInt(values.get(6)));
        this.setResponseCode(ParseNumbers.parseInt(values.get(7)));
        if (values.size() > 23) {
            this.setUrl(values.get(8));
            this.setContentType(values.get(9));
            this.setConnectTime(ParseNumbers.parseInt(values.get(10)));
            this.setSendTime(ParseNumbers.parseInt(values.get(11)));
            this.setServerBusyTime(ParseNumbers.parseInt(values.get(12)));
            this.setReceiveTime(ParseNumbers.parseInt(values.get(13)));
            this.setTimeToFirstBytes(ParseNumbers.parseInt(values.get(14)));
            this.setTimeToLastBytes(ParseNumbers.parseInt(values.get(15)));
            this.setRequestId(values.get(16));
            this.setHttpMethod(values.get(17));
            this.setFormDataEncoding(values.get(18));
            this.setFormData(values.get(19));
            this.setDnsTime(ParseNumbers.parseInt(values.get(20)));
            this.ipAddresses = values.get(21).toString();
            this.setResponseId(values.get(22));
            this.setUsedIpAddress(values.get(23));
        } else {
            this.parseLegacyValues(values);
        }
    }

    private void parseLegacyValues(List<XltCharBuffer> values) {
        int length = values.size();
        if (length > 8) {
            this.setUrl(values.get(8));
        }
        if (length > 9) {
            this.setContentType(values.get(9));
        }
        if (length > 10) {
            this.setConnectTime(ParseNumbers.parseInt(values.get(10)));
            this.setSendTime(ParseNumbers.parseInt(values.get(11)));
            this.setServerBusyTime(ParseNumbers.parseInt(values.get(12)));
            this.setReceiveTime(ParseNumbers.parseInt(values.get(13)));
            this.setTimeToFirstBytes(ParseNumbers.parseInt(values.get(14)));
            this.setTimeToLastBytes(ParseNumbers.parseInt(values.get(15)));
        }
        if (length > 16) {
            this.setRequestId(values.get(16));
        }
        if (length > 17) {
            this.setHttpMethod(values.get(17));
            this.setFormDataEncoding(values.get(18));
            this.setFormData(values.get(19));
        }
        if (length > 20) {
            this.setDnsTime(ParseNumbers.parseInt(values.get(20)));
        }
        if (length > 21) {
            this.ipAddresses = values.get(21).toString();
            this.setResponseId(values.get(22));
        }
        if (length > 23) {
            this.setUsedIpAddress(values.get(23));
        }
    }
}

