/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.clientperformance;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.PageLoadTimingData;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.clientperformance.ClientPerformanceData;
import com.xceptance.xlt.clientperformance.ClientPerformanceRequest;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.resultbrowser.ActionInfo;
import com.xceptance.xlt.engine.resultbrowser.RequestInfo;
import com.xceptance.xlt.engine.util.UrlUtils;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientPerformanceMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(ClientPerformanceMetrics.class);

    public static void updatePerformanceData(SessionImpl session, List<ClientPerformanceData> dataList) {
        LOG.debug("Writing timer data file and reporting client performance metrics");
        for (ClientPerformanceData eachPerformanceData : dataList) {
            ClientPerformanceMetrics.updatePerformanceData(session, eachPerformanceData);
        }
    }

    private static void updatePerformanceData(SessionImpl session, ClientPerformanceData data) {
        for (ClientPerformanceRequest eachRequest : data.getRequestList()) {
            ClientPerformanceMetrics.updateAndLogRequestData(session, eachRequest);
        }
        for (PageLoadTimingData eachData : data.getCustomDataList()) {
            ClientPerformanceMetrics.updateAndLogPageLoadTimingData(session, eachData);
        }
    }

    private static void updateAndLogRequestData(SessionImpl session, ClientPerformanceRequest request) {
        ActionInfo actionInfo;
        Map.Entry<Long, ActionInfo> entry = session.getWebDriverActionStartTimes().floorEntry(request.getRequestData().getTime());
        ActionInfo actionInfo2 = actionInfo = entry != null ? entry.getValue() : null;
        if (actionInfo != null) {
            actionInfo.requests.add(ClientPerformanceMetrics.getRequestInfo(request));
        }
        ClientPerformanceMetrics.logTimerData(session, actionInfo, request.getRequestData());
    }

    private static void updateAndLogPageLoadTimingData(SessionImpl session, PageLoadTimingData data) {
        ActionInfo actionInfo;
        Map.Entry<Long, ActionInfo> entry = session.getWebDriverActionStartTimes().floorEntry(data.getTime());
        ActionInfo actionInfo2 = actionInfo = entry != null ? entry.getValue() : null;
        if (actionInfo != null) {
            actionInfo.events.add(new ActionInfo.PageLoadEventInfo(data.getName(), data.getTime(), data.getRunTime()));
        }
        ClientPerformanceMetrics.logTimerData(session, actionInfo, data);
    }

    private static RequestInfo getRequestInfo(ClientPerformanceRequest request) {
        RequestInfo requestInfo = new RequestInfo();
        RequestData requestData = request.getRequestData();
        int statusCode = requestData.getResponseCode();
        String statusMessage = (String)StringUtils.defaultIfBlank((CharSequence)request.getStatusMessage(), (CharSequence)"n/a");
        requestInfo.loadTime = requestData.getRunTime();
        if (statusCode > 0) {
            requestInfo.status = String.valueOf(statusCode) + " - ";
        }
        requestInfo.status = requestInfo.status + statusMessage;
        requestInfo.mimeType = requestData.getContentType().toString();
        requestInfo.name = ClientPerformanceMetrics.getRequestName(requestData);
        requestInfo.requestMethod = request.getHttpMethod();
        requestInfo.responseCode = statusCode;
        requestInfo.startTime = requestData.getTime();
        requestInfo.url = requestData.getUrl().toString();
        requestInfo.requestHeaders.addAll(request.getRequestHeaders());
        requestInfo.responseHeaders.addAll(request.getResponseHeaders());
        requestInfo.requestParameters.addAll(request.getFormDataParameters());
        requestInfo.requestBodyRaw = request.getRawBody();
        requestInfo.formDataEncoding = request.getFormDataEncoding();
        requestInfo.setTimings(requestData);
        return requestInfo;
    }

    private static String getRequestName(RequestData requestData) {
        String urlPath = UrlUtils.parseUrlString(requestData.getUrl().toString()).getPath();
        String pathWithoutEndSeparator = StringUtils.removeEnd((String)urlPath, (String)"/");
        Object name = FilenameUtils.getName((String)pathWithoutEndSeparator);
        if (!StringUtils.equals((CharSequence)urlPath, (CharSequence)pathWithoutEndSeparator)) {
            name = (String)name + "/";
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            name = "-";
        }
        return name;
    }

    private static void logTimerData(SessionImpl session, ActionInfo actionInfo, Data data) {
        String actionName = actionInfo != null ? actionInfo.name : "UnknownAction";
        String dName = data.getName();
        StringBuilder sb = new StringBuilder(actionName);
        if (StringUtils.isNotBlank((CharSequence)dName)) {
            if (data instanceof PageLoadTimingData) {
                sb.append(" [").append(dName).append("]");
            } else {
                int idx = dName.lastIndexOf(46);
                if (idx < dName.length()) {
                    sb.append('.').append(dName.substring(idx + 1));
                }
            }
        }
        data.setName(sb.toString());
        session.getDataManager().logDataRecord(data);
    }
}

