/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.htmlunit.okhttp3;

import com.xceptance.common.util.ssl.EasyHostnameVerifier;
import com.xceptance.common.util.ssl.EasyX509TrustManager;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.engine.dns.XltDnsResolver;
import com.xceptance.xlt.engine.htmlunit.AbstractWebConnection;
import com.xceptance.xlt.engine.htmlunit.okhttp3.AuthenticationCache;
import com.xceptance.xlt.engine.htmlunit.okhttp3.AuthenticatorImpl;
import com.xceptance.xlt.engine.htmlunit.okhttp3.AuthorizationHeaderInterceptor;
import com.xceptance.xlt.engine.htmlunit.okhttp3.CookieJarImpl;
import com.xceptance.xlt.engine.htmlunit.okhttp3.DnsImpl;
import com.xceptance.xlt.engine.htmlunit.okhttp3.RetrieveFinalRequestHeadersInterceptor;
import com.xceptance.xlt.engine.htmlunit.okhttp3.RetrieveUsedTargetIpAddressInterceptor;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.CookieJar;
import okhttp3.Dispatcher;
import okhttp3.Dns;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.htmlunit.WebClient;
import org.htmlunit.WebClientOptions;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.WebResponseData;
import org.htmlunit.util.KeyDataPair;
import org.htmlunit.util.NameValuePair;

public class OkHttp3WebConnection
extends AbstractWebConnection<OkHttpClient, Request, Response> {
    private static final List<Protocol> HTTP_1_1_ONLY = Arrays.asList(Protocol.HTTP_1_1);
    private static final List<Protocol> HTTP_2_AND_1_1 = Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    private static final EasyHostnameVerifier INSECURE_HOSTNAME_VERIFIER = new EasyHostnameVerifier();
    private static final EasyX509TrustManager INSECURE_TRUST_MANAGER = new EasyX509TrustManager(null);
    private static final SSLSocketFactory INSECURE_SSL_SOCKET_FACTORY = OkHttp3WebConnection.createInsecureSslSocketFactory();
    private final AuthenticationCache authenticationCache;
    private final ConnectionPool connectionPool;
    private final DnsImpl dns;
    private final List<Protocol> protocols;
    private boolean collectTargetIpAddress;

    public OkHttp3WebConnection(WebClient webClient, boolean http2Enabled, boolean collectTargetIpAddress) {
        super(webClient);
        this.collectTargetIpAddress = collectTargetIpAddress;
        this.authenticationCache = new AuthenticationCache();
        this.connectionPool = new ConnectionPool(6, 60L, TimeUnit.SECONDS);
        this.dns = new DnsImpl(new XltDnsResolver());
        this.protocols = http2Enabled ? HTTP_2_AND_1_1 : HTTP_1_1_ONLY;
    }

    @Override
    protected OkHttpClient createHttpClient(WebClient webClient, WebRequest webRequest) throws Exception {
        int timeout;
        WebClientOptions webClientOptions = webClient.getOptions();
        AuthenticatorImpl authenticator = new AuthenticatorImpl(webClient.getCredentialsProvider());
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        httpClientBuilder.authenticator((Authenticator)authenticator);
        httpClientBuilder.connectionPool(this.connectionPool);
        httpClientBuilder.cookieJar((CookieJar)new CookieJarImpl(webClient.getCookieManager()));
        httpClientBuilder.dns((Dns)this.dns);
        httpClientBuilder.protocols(this.protocols);
        httpClientBuilder.retryOnConnectionFailure(true);
        httpClientBuilder.followRedirects(false);
        httpClientBuilder.followSslRedirects(false);
        String proxyHost = webRequest.getProxyHost();
        if (proxyHost != null) {
            InetSocketAddress proxyHostAddress = new InetSocketAddress(proxyHost, webRequest.getProxyPort());
            Proxy proxy = new Proxy(webRequest.isSocksProxy() ? Proxy.Type.SOCKS : Proxy.Type.HTTP, proxyHostAddress);
            httpClientBuilder.proxy(proxy);
            httpClientBuilder.proxyAuthenticator((Authenticator)authenticator);
        }
        if ((timeout = webRequest.getTimeout()) < 0) {
            timeout = webClientOptions.getTimeout();
        }
        Duration timeoutMS = Duration.ofMillis(timeout);
        httpClientBuilder.connectTimeout(timeoutMS);
        httpClientBuilder.readTimeout(timeoutMS);
        httpClientBuilder.writeTimeout(timeoutMS);
        Dispatcher dispatcher = new Dispatcher();
        dispatcher.setMaxRequests(64);
        dispatcher.setMaxRequestsPerHost(6);
        httpClientBuilder.dispatcher(dispatcher);
        if (webClientOptions.isUseInsecureSSL()) {
            httpClientBuilder.sslSocketFactory(INSECURE_SSL_SOCKET_FACTORY, (X509TrustManager)INSECURE_TRUST_MANAGER);
            httpClientBuilder.hostnameVerifier((HostnameVerifier)INSECURE_HOSTNAME_VERIFIER);
        }
        httpClientBuilder.addNetworkInterceptor((Interceptor)new AuthorizationHeaderInterceptor(this.authenticationCache));
        httpClientBuilder.addNetworkInterceptor((Interceptor)new RetrieveFinalRequestHeadersInterceptor(webRequest));
        if (this.collectTargetIpAddress) {
            httpClientBuilder.addNetworkInterceptor((Interceptor)new RetrieveUsedTargetIpAddressInterceptor());
        }
        return httpClientBuilder.build();
    }

    @Override
    public void close() throws IOException {
        this.connectionPool.evictAll();
    }

    @Override
    protected Request createRequestWithoutBody(URI uri, WebRequest webRequest) {
        return this.createRequest(uri, webRequest, null);
    }

    @Override
    protected Request createRequestWithStringBody(URI uri, WebRequest webRequest, String body, String mimeType, @Nullable Charset charset) {
        RequestBody requestBody;
        MediaType mediaType;
        String contentType = webRequest.getAdditionalHeader("Content-Type");
        if (contentType == null) {
            String string = contentType = charset == null ? mimeType : mimeType + ";charset=" + charset;
        }
        if ((mediaType = MediaType.get((String)contentType)).charset() == null) {
            byte[] bytes = body.getBytes(StandardCharsets.ISO_8859_1);
            requestBody = RequestBody.create((MediaType)mediaType, (byte[])bytes);
        } else {
            requestBody = RequestBody.create((MediaType)mediaType, (String)body);
        }
        return this.createRequest(uri, webRequest, requestBody);
    }

    @Override
    protected Request createRequestWithMultiPartBody(URI uri, WebRequest webRequest) {
        MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
        for (NameValuePair pair : webRequest.getRequestParameters()) {
            if (pair instanceof KeyDataPair) {
                this.addFilePart((KeyDataPair)pair, builder);
                continue;
            }
            builder.addFormDataPart(pair.getName(), pair.getValue());
        }
        MultipartBody requestBody = builder.build();
        return this.createRequest(uri, webRequest, (RequestBody)requestBody);
    }

    void addFilePart(KeyDataPair pairWithFile, MultipartBody.Builder builder) {
        String name = pairWithFile.getName();
        String value = pairWithFile.getValue();
        byte[] data = pairWithFile.getData();
        File file = pairWithFile.getFile();
        String mimeType = pairWithFile.getMimeType();
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        MediaType mediaType = MediaType.parse((String)mimeType);
        String filename = file == null ? value : (pairWithFile.getFileName() == null ? file.getName() : pairWithFile.getFileName());
        if (data != null) {
            builder.addFormDataPart(name, filename, RequestBody.create((MediaType)mediaType, (byte[])data));
        } else if (file != null) {
            builder.addFormDataPart(name, filename, RequestBody.create((MediaType)mediaType, (File)file));
        } else {
            builder.addFormDataPart(name, filename, RequestBody.create((MediaType)mediaType, (byte[])new byte[0]));
        }
    }

    private Request createRequest(URI uri, WebRequest webRequest, @Nullable RequestBody requestBody) {
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(uri.toString());
        requestBuilder.method(webRequest.getHttpMethod().name(), requestBody);
        webRequest.getAdditionalHeaders().forEach((arg_0, arg_1) -> ((Request.Builder)requestBuilder).header(arg_0, arg_1));
        return requestBuilder.build();
    }

    @Override
    protected Response executeRequest(OkHttpClient httpClient, Request request) throws IOException {
        return httpClient.newCall(request).execute();
    }

    @Override
    protected WebResponse makeWebResponse(Response response, WebRequest webRequest, long loadTime) throws IOException {
        try (ResponseBody responseBody = response.body();){
            List<NameValuePair> headers = OkHttp3WebConnection.toNamevaluePairs(response.headers());
            WebResponseData webResponseData = new WebResponseData(responseBody.bytes(), response.code(), response.message(), headers);
            WebResponse webResponse = new WebResponse(webResponseData, webRequest, loadTime);
            webResponse.setProtocolVersion(response.protocol().toString());
            WebResponse webResponse2 = webResponse;
            return webResponse2;
        }
    }

    private static List<NameValuePair> toNamevaluePairs(Headers headers) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        for (int i = 0; i < headers.size(); ++i) {
            nameValuePairs.add(new NameValuePair(headers.name(i), headers.value(i)));
        }
        return nameValuePairs;
    }

    private static SSLSocketFactory createInsecureSslSocketFactory() {
        try {
            TrustManager[] trustManagers = new TrustManager[]{INSECURE_TRUST_MANAGER};
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, null);
            return sslContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new XltException("Failed to create insecure SSL socket factory", e);
        }
    }
}

