/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting;

import com.xceptance.common.util.CsvUtils;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.engine.scripting.Script;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class TestDataUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestDataUtils.class);

    private TestDataUtils() {
    }

    public static Map<String, String> getTestData(File scriptFile) {
        String baseName = scriptFile.getName().replace(".xml", "");
        try {
            File dataFile = new File(scriptFile.getParentFile(), baseName + "_data.xml");
            if (dataFile.isFile()) {
                return TestDataUtils.parseXMLData(new FileInputStream(dataFile));
            }
            dataFile = new File(scriptFile.getParentFile(), baseName + "_data.csv");
            if (dataFile.isFile()) {
                return TestDataUtils.parseCSVData(new FileInputStream(dataFile));
            }
            dataFile = new File(scriptFile.getParentFile(), baseName + "_data.properties");
            if (dataFile.isFile()) {
                return TestDataUtils.parsePropertiesData(new FileInputStream(dataFile));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load test data for script '" + baseName + "'.", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getTestData(Script script) {
        return TestDataUtils.getTestData(script.getScriptFile());
    }

    public static Map<String, String> getTestData(Class<?> clazz) {
        String clazzName = clazz.getSimpleName();
        try {
            InputStream is = clazz.getResourceAsStream(clazzName + "_data.xml");
            if (is != null) {
                return TestDataUtils.parseXMLData(is);
            }
            is = clazz.getResourceAsStream(clazzName + "_data.csv");
            if (is != null) {
                return TestDataUtils.parseCSVData(is);
            }
            is = clazz.getResourceAsStream(clazzName + "_data.properties");
            if (is != null) {
                return TestDataUtils.parsePropertiesData(is);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse test data for class '" + clazz.getCanonicalName() + "'", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> parseXMLData(InputStream is) throws Exception {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        XmlErrorHandler errorHandler = new XmlErrorHandler();
        DocumentBuilder parser = parserFactory.newDocumentBuilder();
        parser.setErrorHandler(errorHandler);
        Document document = parser.parse(is);
        if (errorHandler.errors > 0) {
            throw new SAXException(String.format("Parsing the XML data file produced %d error(s) and %d warning(s)", errorHandler.errors, errorHandler.warnings));
        }
        if (errorHandler.warnings > 0 && LOGGER.isWarnEnabled()) {
            LOGGER.warn(String.format("Parsing the XML data file produced %d warning(s)", errorHandler.warnings));
        }
        HashMap<String, String> data = new HashMap<String, String>();
        Element rootElement = document.getDocumentElement();
        NodeList childNodes = rootElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element element = (Element)childNode;
            data.put(element.getTagName(), element.getTextContent());
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> parseCSVData(InputStream is) throws Exception {
        HashMap<String, String> testData = new HashMap<String, String>();
        try {
            List lines = IOUtils.readLines((InputStream)is, (String)"UTF-8");
            for (Object o : lines) {
                List<String> parts = CsvUtils.decodeToList((String)o);
                if (parts.size() != 2) continue;
                testData.put(parts.get(0), parts.get(1));
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return testData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> parsePropertiesData(InputStream is) throws Exception {
        HashMap<String, String> testData = new HashMap<String, String>();
        try {
            Properties props = new Properties();
            props.load(new InputStreamReader(is, "UTF-8"));
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                testData.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return testData;
    }

    public static Map<String, String> getGlobalTestData() {
        File testDataFile = new File(XltExecutionContext.getCurrent().getTestSuiteHomeDirAsFile(), "global_testdata.properties");
        try {
            if (testDataFile.isFile()) {
                return TestDataUtils.parsePropertiesData(new FileInputStream(testDataFile));
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse global test data properties file '" + testDataFile.getAbsolutePath() + "'");
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getPackageTestData(Class<?> clazz, String baseDir, String packageName) {
        String baseName = packageName.replace('.', '/') + "/package_testdata.";
        try {
            InputStream is = null;
            if (clazz != null) {
                String base = baseDir + "/" + baseName;
                is = clazz.getResourceAsStream(base + "xml");
                if (is != null) {
                    return TestDataUtils.parseXMLData(is);
                }
                is = clazz.getResourceAsStream(base + "csv");
                if (is != null) {
                    return TestDataUtils.parseCSVData(is);
                }
                is = clazz.getResourceAsStream(base + "properties");
                if (is != null) {
                    return TestDataUtils.parsePropertiesData(is);
                }
            } else {
                File bd = new File(baseDir);
                File dataFile = new File(bd, baseName + "xml");
                if (dataFile.isFile() && (is = new FileInputStream(dataFile)) != null) {
                    return TestDataUtils.parseXMLData(is);
                }
                dataFile = new File(bd, baseName + "csv");
                if (dataFile.isFile() && (is = new FileInputStream(dataFile)) != null) {
                    return TestDataUtils.parseCSVData(is);
                }
                dataFile = new File(bd, baseName + "properties");
                if (dataFile.isFile() && (is = new FileInputStream(dataFile)) != null) {
                    return TestDataUtils.parsePropertiesData(is);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to parse package test data for package '" + packageName + "'", (Throwable)e);
        }
        return Collections.emptyMap();
    }

    private static class XmlErrorHandler
    implements ErrorHandler {
        int errors;
        int warnings;

        private XmlErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOGGER.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOGGER.error(this.report(exception));
            ++this.errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(this.report(exception));
            }
            ++this.warnings;
        }

        private String report(SAXParseException exception) {
            return String.format("### %d:%d - %s\n", exception.getLineNumber(), exception.getColumnNumber(), exception.getMessage());
        }
    }
}

