/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.xceptance.xlt.engine.scripting.docgen.Marked;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseInfo
implements Comparable<BaseInfo> {
    String description;
    String tags;
    final String name;
    final String id;
    private transient String descriptionMarkup;

    BaseInfo(String name) {
        this(name, null);
    }

    BaseInfo(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public String[] getTags() {
        return StringUtils.split((String)StringUtils.deleteWhitespace((String)StringUtils.defaultString((String)this.tags)), (char)',');
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescriptionMarkup() {
        if (this.descriptionMarkup == null) {
            this.descriptionMarkup = Marked.getInstance().markdownToHTML(this.description);
        }
        return this.descriptionMarkup;
    }

    public String getSimpleName() {
        int idx = this.name.lastIndexOf(46);
        if (idx > -1 && idx < this.name.length() - 1) {
            return this.name.substring(idx + 1);
        }
        return this.name;
    }

    public String getPackageName() {
        int idx = this.name.lastIndexOf(46);
        if (idx < 0) {
            return "(default package)";
        }
        return this.name.substring(0, idx);
    }

    @Override
    public int compareTo(BaseInfo o) {
        int result = this.getPackageName().compareToIgnoreCase(o.getPackageName());
        if (result == 0) {
            result = this.getSimpleName().compareTo(o.getSimpleName());
        }
        return result;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public void setDescription(String description) {
        this.description = description;
        this.descriptionMarkup = null;
    }
}

