/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.docgen;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import com.xceptance.xlt.engine.scripting.docgen.BaseInfo;
import com.xceptance.xlt.engine.scripting.docgen.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ScriptInfo
extends BaseInfo {
    @XStreamAlias(value="external-parameters")
    private final Map<String, String> externalParameters = new HashMap<String, String>();
    private final List<Step> steps = new ArrayList<Step>();
    @XStreamOmitField
    private final HashSet<String> stores = new HashSet();
    private final HashSet<String> calls = new HashSet();
    @XStreamAlias(value="test-data")
    private Map<String, String> testData;

    ScriptInfo(String name) {
        super(name);
    }

    ScriptInfo(String name, String id) {
        super(name, id);
    }

    void addStep(Step step) {
        this.steps.add(step);
    }

    void addCall(String call) {
        this.calls.add(call);
    }

    void addExternalParam(String name, String value) {
        this.externalParameters.put(name, value);
    }

    void setTestData(Map<String, String> testData) {
        this.testData = new HashMap<String, String>();
        if (testData != null) {
            this.testData.putAll(testData);
        }
    }

    public Map<String, String> getTestData() {
        return this.testData;
    }

    void addStore(String value) {
        this.stores.add(value);
    }

    boolean hasStore(String value) {
        return this.stores.contains(value);
    }

    public Set<String> getCalls() {
        return Collections.unmodifiableSet(this.calls);
    }

    public List<Step> getSteps() {
        return Collections.unmodifiableList(this.steps);
    }

    void removeFromExternals(Set<String> keys) {
        for (String key : keys) {
            this.externalParameters.remove(key);
        }
    }

    public Set<String> getStores() {
        return Collections.unmodifiableSet(this.stores);
    }

    public Map<String, String> getExternalParameters() {
        return Collections.unmodifiableMap(this.externalParameters);
    }
}

