/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.junit;

import com.xceptance.xlt.engine.junit.AbstractTestCaseRunner;
import com.xceptance.xlt.engine.scripting.XlteniumScriptInterpreter;
import com.xceptance.xlt.engine.scripting.junit.GenericScriptTestCase;
import com.xceptance.xlt.engine.util.ScriptingUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;

public class ScriptTestCaseRunner
extends AbstractTestCaseRunner {
    private static final List<File> dataSetFileDirs = new ArrayList<File>();
    private final String scriptName;

    public ScriptTestCaseRunner(Class<?> testCaseClass) throws Throwable {
        this(testCaseClass, ScriptingUtils.getScriptName(testCaseClass));
    }

    public ScriptTestCaseRunner(String scriptName) throws Throwable {
        this(GenericScriptTestCase.class, scriptName);
    }

    private ScriptTestCaseRunner(Class<?> testCaseClass, String scriptName) throws Throwable {
        super(testCaseClass, scriptName, ScriptingUtils.getScriptBaseName(scriptName), dataSetFileDirs);
        this.scriptName = scriptName;
    }

    @Override
    protected void setUpTest(FrameworkMethod method, Object test) {
        super.setUpTest(method, test);
        if (test instanceof GenericScriptTestCase) {
            ((GenericScriptTestCase)test).setScriptName(this.scriptName);
        }
    }

    static {
        dataSetFileDirs.add(CURRENT_DIR);
        if (DATA_SETS_DIR != null) {
            dataSetFileDirs.add(DATA_SETS_DIR);
        }
        dataSetFileDirs.add(XlteniumScriptInterpreter.SCRIPTS_DIRECTORY);
    }
}

