/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import com.xceptance.common.lang.ReflectionUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.webdriver.XltChromeDriver;
import com.xceptance.xlt.api.webdriver.XltDriver;
import com.xceptance.xlt.api.webdriver.XltFirefoxDriver;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.io.TemporaryFilesystem;
import org.openqa.selenium.safari.SafariDriver;

public class DefaultWebDriverFactory {
    private static final String PROP_PREFIX_WEB_DRIVER = "xlt.webDriver";
    private static final Pattern BROWSER_ARGS_PATTERN = Pattern.compile("\"(.*?)\"|'(.*?)'|\\S+");
    private static final ConcurrentHashMap<String, WebDriver> reusableWebDrivers = new ConcurrentHashMap();

    public static WebDriver createWebDriver(WebDriverType webDriverType, String pathToDriverServer, String pathToBrowser, String browserArgs, String pageLoadStrategy) {
        Object webDriver;
        if (webDriverType == WebDriverType.chrome || webDriverType == WebDriverType.chrome_clientperformance) {
            DefaultWebDriverFactory.setPathToDriverServer("webdriver.chrome.driver", pathToDriverServer);
            ChromeOptions options = DefaultWebDriverFactory.createChromeOptions(pathToBrowser, browserArgs, pageLoadStrategy);
            webDriver = webDriverType == WebDriverType.chrome ? new ChromeDriver(options) : new XltChromeDriver(options);
        } else if (webDriverType == WebDriverType.firefox || webDriverType == WebDriverType.firefox_clientperformance) {
            DefaultWebDriverFactory.setPathToDriverServer("webdriver.gecko.driver", pathToDriverServer);
            FirefoxOptions options = DefaultWebDriverFactory.createFirefoxOptions(pathToBrowser, browserArgs, pageLoadStrategy);
            webDriver = webDriverType == WebDriverType.firefox ? new FirefoxDriver(options) : new XltFirefoxDriver(options);
        } else if (webDriverType == WebDriverType.ie) {
            DefaultWebDriverFactory.setPathToDriverServer("webdriver.ie.driver", pathToDriverServer);
            webDriver = new InternetExplorerDriver();
        } else if (webDriverType == WebDriverType.edge) {
            DefaultWebDriverFactory.setPathToDriverServer("webdriver.edge.driver", pathToDriverServer);
            webDriver = new EdgeDriver();
        } else {
            webDriver = webDriverType == WebDriverType.safari ? new SafariDriver() : new XltDriver();
        }
        return webDriver;
    }

    private static void setPathToDriverServer(String propertyName, String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            System.setProperty(propertyName, path);
        }
    }

    private static ChromeOptions createChromeOptions(String pathToBrowser, String browserArgs, String pageLoadStrategy) {
        ChromeOptions options = new ChromeOptions();
        if (StringUtils.isNotBlank((CharSequence)pathToBrowser)) {
            options.setBinary(pathToBrowser);
        }
        if (StringUtils.isNotBlank((CharSequence)browserArgs)) {
            List<String> args = DefaultWebDriverFactory.parseBrowserArgs(browserArgs);
            options.addArguments(args);
        }
        if (StringUtils.isNotBlank((CharSequence)pageLoadStrategy)) {
            options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
        }
        return options;
    }

    static List<String> parseBrowserArgs(String browserArgs) {
        ArrayList<String> args = new ArrayList<String>();
        Matcher matcher = BROWSER_ARGS_PATTERN.matcher(browserArgs);
        while (matcher.find()) {
            String arg = matcher.group(1);
            if (arg == null && (arg = matcher.group(2)) == null) {
                arg = matcher.group();
            }
            args.add(arg);
        }
        return args;
    }

    private static FirefoxOptions createFirefoxOptions(String pathToBrowser, String browserArgs, String pageLoadStrategy) {
        FirefoxOptions options = new FirefoxOptions();
        if (StringUtils.isNotBlank((CharSequence)pathToBrowser)) {
            options.setBinary(pathToBrowser);
        }
        if (StringUtils.isNotBlank((CharSequence)browserArgs)) {
            String[] args = StringUtils.split((String)browserArgs);
            options.addArguments(args);
        }
        if (StringUtils.isNotBlank((CharSequence)pageLoadStrategy)) {
            options.setPageLoadStrategy(PageLoadStrategy.fromString((String)pageLoadStrategy));
        }
        return options;
    }

    public static WebDriver getWebDriver() {
        WebDriverType webDriverType;
        XltProperties props = XltProperties.getInstance();
        String driverTypeName = props.getProperty(PROP_PREFIX_WEB_DRIVER, WebDriverType.xlt.name());
        try {
            webDriverType = WebDriverType.valueOf(driverTypeName.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            XltLogger.runTimeLogger.warn("The configured WebDriver type '" + driverTypeName + "' is unknown. Falling back to 'xlt'.");
            webDriverType = WebDriverType.xlt;
        }
        String pathToBrowser = props.getProperty("xlt.webDriver." + webDriverType.name() + ".pathToBrowser", null);
        String browserArgs = props.getProperty("xlt.webDriver." + webDriverType.name() + ".browserArgs", null);
        String pathToDriverServer = props.getProperty("xlt.webDriver." + webDriverType.name() + ".pathToDriverServer", null);
        String pageLoadStrategy = props.getProperty("xlt.webDriver." + webDriverType.name() + ".pageLoadStrategy", null);
        boolean reuseDriver = webDriverType != WebDriverType.xlt && props.getProperty("xlt.webDriver.reuseDriver", false);
        WebDriver webDriver = reuseDriver ? DefaultWebDriverFactory.getOrCreateReusableWebDriver(webDriverType, pathToDriverServer, pathToBrowser, browserArgs, pageLoadStrategy) : DefaultWebDriverFactory.createWebDriver(webDriverType, pathToDriverServer, pathToBrowser, browserArgs, pageLoadStrategy);
        int windowWidth = props.getProperty("xlt.webDriver.window.width", -1);
        int windowHeight = props.getProperty("xlt.webDriver.window.height", -1);
        boolean maximizeWindow = props.getProperty("xlt.webDriver.window.maximize", false);
        if (maximizeWindow) {
            webDriver.manage().window().maximize();
        } else if (windowWidth > 0 && windowHeight > 0) {
            Dimension windowSize = new Dimension(windowWidth, windowHeight);
            webDriver.manage().window().setSize(windowSize);
        }
        DefaultWebDriverFactory.logWindowSize(webDriver);
        return webDriver;
    }

    private static void logWindowSize(WebDriver webDriver) {
        if (XltLogger.runTimeLogger.isInfoEnabled()) {
            Dimension windowDim = webDriver.manage().window().getSize();
            XltLogger.runTimeLogger.info("Size of browser window: " + windowDim.getWidth() + " x " + windowDim.getHeight());
        }
    }

    public static WebDriver getOrCreateReusableWebDriver(WebDriverType webDriverType, String pathToDriverServer, String pathToBrowser, String browserArgs, String pageLoadStrategy) {
        String key = webDriverType.name() + Thread.currentThread().getId();
        WebDriver webDriver = reusableWebDrivers.get(key);
        if (webDriver == null) {
            webDriver = DefaultWebDriverFactory.createWebDriver(webDriverType, pathToDriverServer, pathToBrowser, browserArgs, pageLoadStrategy);
            webDriver = DefaultWebDriverFactory.makeDriverUnquittable(webDriver);
            reusableWebDrivers.put(key, webDriver);
        } else {
            DefaultWebDriverFactory.resetWebDriver(webDriver);
        }
        return webDriver;
    }

    private static void resetWebDriver(WebDriver webDriver) {
        webDriver.manage().deleteAllCookies();
        Set windows = webDriver.getWindowHandles();
        if (windows.size() > 1) {
            String currentWindow = webDriver.getWindowHandle();
            for (String window : windows) {
                if (window.equals(currentWindow)) continue;
                webDriver.switchTo().window(window);
                webDriver.close();
            }
            webDriver.switchTo().window(currentWindow);
        }
    }

    private static WebDriver makeDriverUnquittable(final WebDriver webDriver) {
        InvocationHandler handler = new InvocationHandler(){
            private final WebDriver wrappedDriver;
            {
                this.wrappedDriver = webDriver;
            }

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                String methodName = method.getName();
                if (methodName.equals("quit") || methodName.equals("close") && this.wrappedDriver.getWindowHandles().size() <= 1) {
                    return null;
                }
                if (methodName.equals("getWrappedDriver")) {
                    return this.wrappedDriver;
                }
                try {
                    return method.invoke((Object)this.wrappedDriver, args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
        };
        List ifaces = ClassUtils.getAllInterfaces(webDriver.getClass());
        Class[] proxyIFaces = new Class[ifaces.size() + 1];
        proxyIFaces[0] = WrapsDriver.class;
        int i = 1;
        for (Class clazz : ifaces) {
            proxyIFaces[i++] = clazz;
        }
        return (WebDriver)Proxy.newProxyInstance(DefaultWebDriverFactory.class.getClassLoader(), proxyIFaces, handler);
    }

    static {
        TemporaryFilesystem tempFS = TemporaryFilesystem.getDefaultTmpFS();
        final Thread seleniumShutdownHook = (Thread)ReflectionUtils.readInstanceField(tempFS, "shutdownHook");
        Runtime.getRuntime().removeShutdownHook(seleniumShutdownHook);
        Runtime.getRuntime().addShutdownHook(new Thread(DefaultWebDriverFactory.class.getSimpleName() + "-shutdown"){

            @Override
            public void run() {
                for (WebDriver reusableWebDriver : reusableWebDrivers.values()) {
                    try {
                        ((WrapsDriver)reusableWebDriver).getWrappedDriver().quit();
                    }
                    catch (Exception exception) {}
                }
                seleniumShutdownHook.run();
            }
        });
    }

    private static enum WebDriverType {
        chrome,
        firefox,
        ie,
        safari,
        xlt,
        firefox_clientperformance,
        chrome_clientperformance,
        edge;

    }
}

