/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import com.xceptance.xlt.engine.xltdriver.w3.Action;
import java.util.ArrayList;
import java.util.List;
import org.htmlunit.html.DomElement;
import org.openqa.selenium.interactions.Coordinates;

public class HtmlUnitInputProcessor {
    private final HtmlUnitDriver driver_;
    private final List<HtmlUnitAction> htmlUnitActions_ = new ArrayList<HtmlUnitAction>();

    public HtmlUnitInputProcessor(HtmlUnitDriver driver) {
        this.driver_ = driver;
    }

    public void performActions() {
        for (HtmlUnitAction htmlUnitAction : this.htmlUnitActions_) {
            htmlUnitAction.process(this.driver_);
        }
        this.htmlUnitActions_.clear();
    }

    public void enqueuAction(Action action) {
        HtmlUnitAction htmlUnitAction = action.buildHtmlUnitAction();
        if (htmlUnitAction != null) {
            this.enqueuHtmlUnitAction(htmlUnitAction);
        }
    }

    private void enqueuHtmlUnitAction(HtmlUnitAction action) {
        this.htmlUnitActions_.add(action);
        while (this.htmlUnitActions_.size() > 1) {
            int lastPos = this.htmlUnitActions_.size() - 1;
            int secondLastPos = lastPos - 1;
            HtmlUnitAction lastAction = this.htmlUnitActions_.get(lastPos);
            HtmlUnitAction joinedAction = lastAction.join(this.htmlUnitActions_.get(secondLastPos));
            if (joinedAction == lastAction) {
                return;
            }
            this.htmlUnitActions_.set(secondLastPos, joinedAction);
            this.htmlUnitActions_.remove(lastPos);
        }
    }

    public static final class KeySendHtmlUnitAction
    implements HtmlUnitAction {
        private final String value_;

        public KeySendHtmlUnitAction(String value) {
            this.value_ = value;
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getKeyboard().sendKeys(this.value_);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            if (previousAction instanceof KeySendHtmlUnitAction) {
                KeySendHtmlUnitAction keySendHtmlUnitAction = (KeySendHtmlUnitAction)previousAction;
                return new KeySendHtmlUnitAction(keySendHtmlUnitAction.value_ + this.value_);
            }
            return this;
        }
    }

    public static final class KeyUpHtmlUnitAction
    implements HtmlUnitAction {
        private final String value_;

        public KeyUpHtmlUnitAction(String value) {
            this.value_ = value;
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getKeyboard().releaseKey(this.value_);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            if (previousAction instanceof KeyDownHtmlUnitAction) {
                KeyDownHtmlUnitAction keyDownHtmlUnitAction = (KeyDownHtmlUnitAction)previousAction;
                if (this.value_.equals(keyDownHtmlUnitAction.value_)) {
                    return new KeySendHtmlUnitAction(this.value_);
                }
            }
            return this;
        }
    }

    public static final class KeyDownHtmlUnitAction
    implements HtmlUnitAction {
        private final String value_;

        public KeyDownHtmlUnitAction(String value) {
            this.value_ = value;
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getKeyboard().pressKey(this.value_);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            return this;
        }
    }

    private static final class PointerDblClickHtmlUnitAction
    extends DomElementHtmlUnitAction {
        PointerDblClickHtmlUnitAction(DomElement domElement) {
            super(domElement);
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getMouse().doubleClick((Coordinates)null);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            return this;
        }
    }

    private static final class PointerClickHtmlUnitAction
    extends PointerHtmlUnitAction {
        PointerClickHtmlUnitAction(DomElement domElement, int button) {
            super(domElement, button);
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            if (2 == this.getButton()) {
                driver.getMouse().contextClick(null);
                return;
            }
            driver.getMouse().click(null);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            PointerClickHtmlUnitAction pointerClickAction;
            if (previousAction instanceof PointerClickHtmlUnitAction && (pointerClickAction = (PointerClickHtmlUnitAction)previousAction).getDomElement() == this.getDomElement()) {
                return new PointerDblClickHtmlUnitAction(this.getDomElement());
            }
            return this;
        }
    }

    public static final class PointerUpHtmlUnitAction
    extends PointerHtmlUnitAction {
        public PointerUpHtmlUnitAction(DomElement domElement, int button) {
            super(domElement, button);
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getMouse().mouseUp((Coordinates)null);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            PointerDownHtmlUnitAction pointerDownAction;
            if (previousAction instanceof PointerDownHtmlUnitAction && (pointerDownAction = (PointerDownHtmlUnitAction)previousAction).getDomElement() == this.getDomElement() && pointerDownAction.getButton() == this.getButton()) {
                return new PointerClickHtmlUnitAction(this.getDomElement(), this.getButton());
            }
            return this;
        }
    }

    public static final class PointerDownHtmlUnitAction
    extends PointerHtmlUnitAction {
        public PointerDownHtmlUnitAction(DomElement domElement, int button) {
            super(domElement, button);
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getMouse().mouseDown((Coordinates)null);
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            return this;
        }
    }

    public static abstract class PointerHtmlUnitAction
    extends DomElementHtmlUnitAction {
        private final int button_;

        public PointerHtmlUnitAction(DomElement domElement, int button) {
            super(domElement);
            this.button_ = button;
        }

        public int getButton() {
            return this.button_;
        }
    }

    public static final class PointerMoveHtmlUnitAction
    extends DomElementHtmlUnitAction {
        public PointerMoveHtmlUnitAction(DomElement domElement) {
            super(domElement);
        }

        @Override
        public void process(HtmlUnitDriver driver) {
            driver.getMouse().mouseMove(this.getDomElement());
        }

        @Override
        public HtmlUnitAction join(HtmlUnitAction previousAction) {
            return this;
        }
    }

    private static abstract class DomElementHtmlUnitAction
    implements HtmlUnitAction {
        private DomElement domElement_;

        DomElementHtmlUnitAction(DomElement domElement) {
            this.domElement_ = domElement;
        }

        protected DomElement getDomElement() {
            return this.domElement_;
        }
    }

    public static interface HtmlUnitAction {
        public void process(HtmlUnitDriver var1);

        public HtmlUnitAction join(HtmlUnitAction var1);
    }
}

