/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.lang.ThreadUtils;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.xlt.mastercontroller.AgentControllersInformation;
import com.xceptance.xlt.mastercontroller.BasicConsoleUI;
import com.xceptance.xlt.mastercontroller.MasterController;
import com.xceptance.xlt.mastercontroller.PingResult;
import com.xceptance.xlt.util.AgentControllerInfo;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class InteractiveUI
extends BasicConsoleUI {
    private static final List<String> OPERATION_NAMES = Arrays.asList("Upload test suite", "Start test", "Report test status", "Download test results", "Create test report", "Abort test", "Ping agent controllers", "Show agent controller information", "Quit");
    private static final List<String> OPERATION_KEYS = Arrays.asList("u", "s", "r", "d", "c", "a", "p", "i", "q");
    private static final String STOP_STATUS_PRINTING_MSG;
    private static final DateFormat iso8601Format;
    private final boolean generateReport;

    public InteractiveUI(MasterController masterController, boolean generateReport) {
        super(masterController);
        this.generateReport = generateReport;
    }

    @Override
    public void run() {
        while (true) {
            String option = ConsoleUiUtils.selectItem("\n-----------------------------------------------\n What do you want to do?\n-----------------------------------------------", OPERATION_KEYS, OPERATION_NAMES, OPERATION_KEYS);
            System.out.println();
            if (option.equals("u")) {
                if (!this.checkAlive() || this.isLoadTestRunning()) continue;
                this.uploadAgentFiles();
                continue;
            }
            if (option.equals("s")) {
                if (!this.checkAlive() || this.isLoadTestRunning()) continue;
                this.startAgents(null, true);
                this.printLoadTestSettings();
                continue;
            }
            if (option.equals("a")) {
                if (!ConsoleUiUtils.confirm("Do you really want to abort the running test?")) continue;
                System.out.println();
                this.stopAgents();
                continue;
            }
            if (option.equals("d")) {
                boolean ok = this.downloadTestResults(null);
                if (!ok || !this.generateReport) continue;
                this.generateReport();
                continue;
            }
            if (option.equals("r")) {
                System.out.println(STOP_STATUS_PRINTING_MSG);
                this.printLoadTestSettings();
                System.out.println();
                System.out.println();
                this.printInfoUntilCanceled();
                continue;
            }
            if (option.equals("c")) {
                this.generateReport();
                continue;
            }
            if (option.equals("p")) {
                this.pingAgentControllers();
                continue;
            }
            if (option.equals("i")) {
                this.showAgentControllerInfo();
                this.printLoadTestSettings();
                continue;
            }
            if (!option.equals("q")) continue;
            this.masterController.shutdown();
            System.exit(0);
        }
    }

    @Override
    protected void handleTestComment() {
        String prompt;
        String testCommentProp = this.masterController.getTestCommentPropertyValue();
        if (testCommentProp != null && !testCommentProp.isBlank()) {
            System.out.println("Preconfigured test comment: \"" + testCommentProp + "\"");
            System.out.println();
            prompt = "Add another comment about the test";
        } else {
            prompt = "Add a comment about the test";
        }
        String comment = ConsoleUiUtils.readLine(prompt);
        if (comment.trim().length() > 0) {
            this.masterController.setTestComment(comment);
        } else {
            this.masterController.setTestComment(null);
        }
        super.handleTestComment();
    }

    private void printInfoUntilCanceled() {
        this.masterController.startAgentStatusList();
        this.printAgentStatusList();
        while (!this.sleepUntilCanceled()) {
            this.printAgentStatusList();
            if (this.masterController.isAnyAgentRunning_SAFE()) continue;
        }
        this.masterController.stopAgentStatusList();
    }

    private boolean sleepUntilCanceled() {
        long sleepTime = 100L;
        for (long remainingTime = Math.max(0L, (long)this.getStatusListUpdateInterval() * 1000L); remainingTime > 0L; remainingTime -= 100L) {
            ThreadUtils.sleep(100L);
            if (!ConsoleUiUtils.wasEnterKeyPressed()) continue;
            return true;
        }
        return false;
    }

    public void pingAgentControllers() {
        System.out.println("Pinging agent controllers...\n");
        Map<String, PingResult> pingResults = this.masterController.pingAgentControllers();
        if (pingResults.isEmpty()) {
            System.out.println(" -> No agent controller has been pinged.");
        }
        StringBuilder sb = new StringBuilder();
        boolean isTimeout = false;
        for (Map.Entry<String, PingResult> entry : pingResults.entrySet()) {
            sb.append(" -> ").append(entry.getKey()).append(" - ");
            PingResult pingResult = entry.getValue();
            Exception ex = pingResult.getException();
            if (ex == null) {
                sb.append(pingResult.getPingTime()).append(" ms");
            } else {
                sb.append(this.getUserFriendlyExceptionMessage(ex));
                isTimeout = true;
            }
            sb.append("\n");
        }
        System.out.println(sb.toString());
        if (isTimeout) {
            System.out.println("WARNING: At least one agent controller could not be pinged.\n");
        }
    }

    public void showAgentControllerInfo() {
        System.out.println("Requesting agent controller information...\n");
        AgentControllersInformation agentControllersInfos = this.masterController.getAgentControllerInformation();
        if (agentControllersInfos.getAgentControllerInformation().isEmpty()) {
            System.out.println(" -> No agent controller information available.");
        } else {
            StringBuilder sb = new StringBuilder();
            for (AgentControllerInfo agentControllerInfo : agentControllersInfos.getAgentControllerInformation()) {
                sb.append(" -> ").append(agentControllerInfo.getName()).append(": ");
                if (agentControllerInfo.getAgentControllerSystemInfo() != null) {
                    sb.append(agentControllerInfo.getAgentControllerSystemInfo().getXltVersion());
                    sb.append(", Java ").append(agentControllerInfo.getAgentControllerSystemInfo().getJavaVersion());
                    sb.append(", ").append(agentControllerInfo.getAgentControllerSystemInfo().getOsInfo());
                    long acTime = agentControllerInfo.getAgentControllerSystemInfo().getTime();
                    sb.append(", ").append(iso8601Format.format(new Date(acTime)));
                    sb.append(" (diff: ").append(NumberFormat.getInstance().format(agentControllerInfo.getTimeDifference())).append("ms)");
                    sb.append(", status: ").append(agentControllerInfo.getAgentControllerSystemInfo().getStatus());
                } else {
                    sb.append(this.getUserFriendlyExceptionMessage(agentControllerInfo.getException()));
                }
                sb.append("\n");
            }
            System.out.print(sb.toString());
            if (agentControllersInfos.hasErrors()) {
                System.out.println("\nWARNING: At least one agent controller could not be queried.");
            } else {
                if (agentControllersInfos.hasXltVersionConflict()) {
                    System.out.printf("\nWARNING: Master controller and agent controllers run different XLT versions.\n         Master controller version: %s\n", ProductInformation.getProductInformation().getCondensedProductIdentifier());
                }
                if (agentControllersInfos.hasJavaConflict()) {
                    System.out.println("\nWARNING: Your agent controllers probably run different Java versions.");
                }
                if (agentControllersInfos.hasHighTimeDifference()) {
                    System.out.printf("\nWARNING: At least one agent controller has a time difference to the master controller of %ss or higher.\n", agentControllersInfos.getTimeDiffThreshold());
                }
            }
        }
        System.out.println();
    }

    static {
        iso8601Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS z");
        iso8601Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        StringBuilder sb = new StringBuilder(130);
        sb.append(" +").append(StringUtils.repeat((String)"-", (int)40)).append("+\n");
        sb.append(" |").append(StringUtils.center((String)"Press ENTER to return to menu", (int)40)).append("|\n");
        sb.append(" +").append(StringUtils.repeat((String)"-", (int)40)).append("+\n");
        STOP_STATUS_PRINTING_MSG = sb.toString();
    }
}

