/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report;

import com.xceptance.common.util.StringMatcher;
import com.xceptance.common.util.concurrent.DaemonThreadFactory;
import com.xceptance.xlt.api.report.ReportProvider;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.report.DataParserThread;
import com.xceptance.xlt.report.DataReaderThread;
import com.xceptance.xlt.report.DataRecordFactory;
import com.xceptance.xlt.report.Dispatcher;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.StatisticsProcessor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataProcessor {
    private static final Logger log = LoggerFactory.getLogger(DataProcessor.class);
    private final ExecutorService dataParserExecutor;
    private final StatisticsProcessor statisticsProcessor;
    private final ExecutorService dataReaderExecutor;
    private final Dispatcher dispatcher;
    private final FileObject inputDir;
    private final AtomicLong totalLinesCounter = new AtomicLong();
    private final StringMatcher testCaseFilter;
    private final StringMatcher agentFilter;

    public DataProcessor(ReportGeneratorConfiguration config, FileObject inputDir, DataRecordFactory dataRecordFactory, long fromTime, long toTime, List<ReportProvider> reportProviders, String testCaseIncludePatternList, String testCaseExcludePatternList, String agentIncludePatternList, String agentExcludePatternList) {
        this.inputDir = inputDir;
        this.testCaseFilter = new StringMatcher(testCaseIncludePatternList, testCaseExcludePatternList, true);
        this.agentFilter = new StringMatcher(agentIncludePatternList, agentExcludePatternList, true);
        this.statisticsProcessor = new StatisticsProcessor(reportProviders);
        this.dataReaderExecutor = Executors.newFixedThreadPool(config.readerThreadCount, new DaemonThreadFactory(i -> "DataReader-" + i, 10));
        this.dataParserExecutor = Executors.newFixedThreadPool(config.parserThreadCount, new DaemonThreadFactory(i -> "DataParser-" + i));
        this.dispatcher = new Dispatcher(config, this.statisticsProcessor);
        for (int i2 = 0; i2 < config.parserThreadCount; ++i2) {
            this.dataParserExecutor.execute(new DataParserThread(this.dispatcher, dataRecordFactory, fromTime, toTime, config));
        }
        XltLogger.reportLogger.info(String.format("Input directory: %s", inputDir));
    }

    public final long getMaximumTime() {
        return this.statisticsProcessor.getMaximumTime();
    }

    public final long getMinimumTime() {
        return this.statisticsProcessor.getMinimumTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDataRecords() {
        try {
            this.dispatcher.startProgress();
            long start = TimerUtils.get().getStartTime();
            for (FileObject file : this.inputDir.getChildren()) {
                String directoryName;
                if (file.getType() != FileType.FOLDER || !this.agentFilter.isAccepted(directoryName = file.getName().getBaseName())) continue;
                this.readDataRecordsFromAgentDir(file);
            }
            this.dispatcher.waitForDataRecordProcessingToComplete();
            long duration = TimerUtils.get().getElapsedTime(start);
            long linesPerSecond = Math.round((double)this.totalLinesCounter.get() / (double)duration * 1000.0);
            XltLogger.reportLogger.info(String.format("%,d records read - %,d ms - %,d lines/s", this.totalLinesCounter.get(), duration, linesPerSecond));
        }
        catch (Exception e) {
            XltLogger.reportLogger.error("Failed to read data records", (Throwable)e);
        }
        finally {
            this.dataParserExecutor.shutdownNow();
            this.dataReaderExecutor.shutdownNow();
        }
    }

    private void readDataRecordsFromAgentDir(FileObject agentDir) throws Exception {
        for (FileObject file : agentDir.getChildren()) {
            String directoryName;
            if (file.getType() != FileType.FOLDER || !this.isSpecialDirectory(directoryName = file.getName().getBaseName()) && !this.testCaseFilter.isAccepted(directoryName)) continue;
            this.readDataRecordsFromTestCaseDir(file, agentDir.getName().getBaseName());
        }
    }

    private void readDataRecordsFromTestCaseDir(FileObject testCaseDir, String agentName) throws Exception {
        String testCaseName = testCaseDir.getName().getBaseName();
        for (FileObject file : testCaseDir.getChildren()) {
            if (file.getType() != FileType.FOLDER) continue;
            this.readDataRecordsFromTestUserDir(file, agentName, testCaseName);
        }
    }

    private void readDataRecordsFromTestUserDir(FileObject testUserDir, String agentName, String testCaseName) throws Exception {
        this.dispatcher.incremementDirectoryCount();
        String userNumber = testUserDir.getName().getBaseName();
        DataReaderThread reader = new DataReaderThread(testUserDir, agentName, testCaseName, userNumber, this.totalLinesCounter, this.dispatcher);
        this.dataReaderExecutor.execute(reader);
    }

    private boolean isSpecialDirectory(String directoryName) {
        return "CustomSampler".equals(directoryName) || "Agent-JVM-Monitor".equals(directoryName);
    }
}

