/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.collection.LRUFastHashMap;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractPatternRequestFilter
extends AbstractRequestFilter {
    private ThreadLocal<LRUFastHashMap<CharSequence, Matcher>> cache = new ThreadLocal<LRUFastHashMap<CharSequence, Matcher>>(){

        @Override
        protected LRUFastHashMap<CharSequence, Matcher> initialValue() {
            return new LRUFastHashMap<CharSequence, Matcher>(AbstractPatternRequestFilter.this.cacheSize);
        }
    };
    private final int cacheSize;
    private static final Matcher NULL = Pattern.compile(".*").matcher("null");
    private final Pattern pattern;
    private final boolean isExclude;

    public AbstractPatternRequestFilter(String typeCode, String regex) {
        this(typeCode, regex, false, 100);
    }

    public AbstractPatternRequestFilter(String typeCode, String regex, boolean exclude, int cacheSize) {
        super(typeCode);
        this.pattern = StringUtils.isBlank((CharSequence)regex) ? null : RegExUtils.getPattern(regex, 0);
        this.isExclude = exclude;
        this.cacheSize = cacheSize;
    }

    protected abstract CharSequence getText(RequestData var1);

    @Override
    public Object appliesTo(RequestData requestData) {
        if (this.pattern == null) {
            return Boolean.TRUE;
        }
        CharSequence text = this.getText(requestData);
        if (this.cacheSize == 0) {
            Matcher matcher = this.pattern.matcher(text);
            return matcher.find() ^ this.isExclude ? matcher : null;
        }
        LRUFastHashMap<CharSequence, Matcher> cache = this.cache.get();
        Matcher result = cache.get(text);
        if (result == null) {
            Matcher matcher = this.pattern.matcher(text);
            result = matcher.find() ^ this.isExclude ? matcher : NULL;
            cache.put(text, result);
        }
        if (result == NULL) {
            return null;
        }
        return result.toMatchResult();
    }

    @Override
    public CharSequence getReplacementText(RequestData requestData, int capturingGroupIndex, Object filterState) {
        if (this.isExclude || this.pattern == null || capturingGroupIndex == -1) {
            return this.getText(requestData);
        }
        try {
            return ((MatchResult)filterState).group(capturingGroupIndex);
        }
        catch (IndexOutOfBoundsException ioobe) {
            String format = "No matching group %d for input string '%s' and pattern '%s'";
            ThrowableUtils.setMessage(ioobe, String.format("No matching group %d for input string '%s' and pattern '%s'", capturingGroupIndex, this.getText(requestData), this.getPattern()));
            throw ioobe;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ type: '");
        sb.append(this.getTypeCode()).append("', ");
        sb.append("pattern: '").append(this.getPattern()).append("', ");
        sb.append("isExclude: ").append(this.isExclude).append(" }");
        return sb.toString();
    }

    public String getPattern() {
        return this.pattern == null ? "" : this.pattern.pattern();
    }

    public boolean isEmpty() {
        return this.pattern == null;
    }

    public boolean isExclude() {
        return this.isExclude;
    }
}

