/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.mergerules;

import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.report.mergerules.AbstractPatternRequestFilter;
import com.xceptance.xlt.report.mergerules.AbstractRequestFilter;
import com.xceptance.xlt.report.mergerules.AgentNameRequestFilter;
import com.xceptance.xlt.report.mergerules.ContentTypeRequestFilter;
import com.xceptance.xlt.report.mergerules.HttpMethodRequestFilter;
import com.xceptance.xlt.report.mergerules.InvalidRequestProcessingRuleException;
import com.xceptance.xlt.report.mergerules.PlaceholderPosition;
import com.xceptance.xlt.report.mergerules.RequestNameRequestFilter;
import com.xceptance.xlt.report.mergerules.ResponseTimeRequestFilter;
import com.xceptance.xlt.report.mergerules.StatusCodeRequestFilter;
import com.xceptance.xlt.report.mergerules.TransactionNameRequestFilter;
import com.xceptance.xlt.report.mergerules.UrlRequestFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;

public class RequestProcessingRule {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([acmnrstu])(?::([0-9]+))?\\}");
    private final String newName;
    private final boolean stopOnMatch;
    private final boolean dropOnMatch;
    private final AbstractRequestFilter[] requestFilters;
    private final PlaceholderPosition[] newNamePlaceholders;

    public RequestProcessingRule(String newName, String requestNamePattern, String urlPattern, String contentTypePattern, String statusCodePattern, String agentNamePattern, String transactionNamePattern, String httpMethodPattern, String responseTimeRanges, boolean stopOnMatch, String requestNameExcludePattern, String urlExcludePattern, String contentTypeExcludePattern, String statusCodeExcludePattern, String agentNameExcludePattern, String transactionNameExcludePattern, String httpMethodExcludePattern, boolean dropOnMatch) throws InvalidRequestProcessingRuleException {
        this.newName = newName;
        this.stopOnMatch = stopOnMatch;
        this.dropOnMatch = dropOnMatch;
        ArrayList<AbstractRequestFilter> requestFilters = new ArrayList<AbstractRequestFilter>(20);
        this.newNamePlaceholders = RequestProcessingRule.parsePlaceholderPositions(newName);
        try {
            this.addIfTypeCodeInNewName(requestFilters, new RequestNameRequestFilter(requestNamePattern), requestNamePattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new UrlRequestFilter(urlPattern), urlPattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new ContentTypeRequestFilter(contentTypePattern), contentTypePattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new StatusCodeRequestFilter(statusCodePattern), statusCodePattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new AgentNameRequestFilter(agentNamePattern), agentNamePattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new TransactionNameRequestFilter(transactionNamePattern), transactionNamePattern, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new ResponseTimeRequestFilter(responseTimeRanges), responseTimeRanges, this.newNamePlaceholders);
            this.addIfTypeCodeInNewName(requestFilters, new HttpMethodRequestFilter(httpMethodPattern), httpMethodPattern, this.newNamePlaceholders);
            if (StringUtils.isNotBlank((CharSequence)requestNameExcludePattern)) {
                requestFilters.add(new RequestNameRequestFilter(requestNameExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)urlExcludePattern)) {
                requestFilters.add(new UrlRequestFilter(urlExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)contentTypeExcludePattern)) {
                requestFilters.add(new ContentTypeRequestFilter(contentTypeExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)statusCodeExcludePattern)) {
                requestFilters.add(new StatusCodeRequestFilter(statusCodeExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)agentNameExcludePattern)) {
                requestFilters.add(new AgentNameRequestFilter(agentNameExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)transactionNameExcludePattern)) {
                requestFilters.add(new TransactionNameRequestFilter(transactionNameExcludePattern, true));
            }
            if (StringUtils.isNotBlank((CharSequence)httpMethodExcludePattern)) {
                requestFilters.add(new HttpMethodRequestFilter(httpMethodExcludePattern, true));
            }
        }
        catch (PatternSyntaxException pse) {
            throw new InvalidRequestProcessingRuleException("Invalid regular expression: " + pse.getPattern());
        }
        this.requestFilters = requestFilters.toArray(new AbstractRequestFilter[requestFilters.size()]);
        this.validateRule();
    }

    private void addIfTypeCodeInNewName(List<AbstractRequestFilter> filters, AbstractRequestFilter filter, String pattern, PlaceholderPosition[] newNamePlaceholders) {
        String typeCode = filter.getTypeCode();
        if (pattern == null || "".equals(pattern)) {
            for (PlaceholderPosition p : newNamePlaceholders) {
                if (!p.typeCode.equals(typeCode)) continue;
                filters.add(filter);
                return;
            }
        } else {
            filters.add(filter);
        }
    }

    private static PlaceholderPosition[] parsePlaceholderPositions(String newNameWithPlaceholders) throws InvalidRequestProcessingRuleException {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(newNameWithPlaceholders);
        ArrayList<PlaceholderPosition> positions = new ArrayList<PlaceholderPosition>();
        while (matcher.find()) {
            int matchingGroupIndex = -1;
            String matchingGroupIndexString = matcher.group(2);
            if (matchingGroupIndexString != null) {
                try {
                    matchingGroupIndex = Integer.valueOf(matchingGroupIndexString);
                }
                catch (NumberFormatException e) {
                    throw new InvalidRequestProcessingRuleException("Failed to parse the matching group index '" + matchingGroupIndexString + "' as integer");
                }
            }
            PlaceholderPosition position = new PlaceholderPosition(matcher.group(1), matchingGroupIndex, matcher.start(), matcher.end(), matcher.group().length());
            positions.add(position);
        }
        return positions.toArray(new PlaceholderPosition[positions.size()]);
    }

    public ReturnState process(RequestData requestData) {
        int requestFiltersSize = this.requestFilters.length;
        Object[] filterStates = new Object[requestFiltersSize];
        for (int i = 0; i < requestFiltersSize; ++i) {
            AbstractRequestFilter filter = this.requestFilters[i];
            filterStates[i] = filter.appliesTo(requestData);
            if (filterStates[i] != null) continue;
            return ReturnState.CONTINUE;
        }
        if (this.dropOnMatch) {
            return ReturnState.DROP;
        }
        if (this.newNamePlaceholders.length > 0) {
            StringBuilder result = new StringBuilder(this.newName);
            int displacement = 0;
            block1: for (PlaceholderPosition placeholder : this.newNamePlaceholders) {
                for (int i = 0; i < requestFiltersSize; ++i) {
                    AbstractRequestFilter requestFilter = this.requestFilters[i];
                    if (!requestFilter.isSameTypeCode(placeholder.typeCode, placeholder.typeCodeHashCode)) continue;
                    int capturingGroupIndex = placeholder.index;
                    Object filterState = filterStates[i];
                    CharSequence replacement = requestFilter.getReplacementText(requestData, capturingGroupIndex, filterState);
                    result.delete(placeholder.start + displacement, placeholder.end + displacement);
                    result.insert(placeholder.start + displacement, replacement);
                    displacement += replacement.length() - placeholder.length;
                    continue block1;
                }
            }
            requestData.setName(result.toString());
        } else {
            requestData.setName(this.newName);
        }
        return this.stopOnMatch ? ReturnState.STOP : ReturnState.CONTINUE;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Naming rule: '").append(this.newName).append("', filters:  [");
        boolean appendComma = false;
        for (AbstractRequestFilter requestFilter : this.requestFilters) {
            String typeCode = requestFilter.getTypeCode();
            if (appendComma) {
                sb.append(", ");
            }
            if ("a".equals(typeCode)) {
                sb.append("agentName: ").append(requestFilter.toString());
            } else if ("c".equals(typeCode)) {
                sb.append("contentType: ").append(requestFilter.toString());
            } else if ("n".equals(typeCode)) {
                sb.append("requestName: ").append(requestFilter.toString());
            } else if ("r".equals(typeCode)) {
                sb.append("responseTime:").append(requestFilter.toString());
            } else if ("s".equals(typeCode)) {
                sb.append("statusCode:").append(requestFilter.toString());
            } else if ("t".equals(typeCode)) {
                sb.append("txnName: ").append(requestFilter.toString());
            } else if ("u".equals(typeCode)) {
                sb.append("requestURL: ").append(requestFilter.toString());
            } else {
                sb.append("unknown");
            }
            appendComma = true;
        }
        sb.append("]");
        return sb.toString();
    }

    private void validateRule() throws InvalidRequestProcessingRuleException {
        block0: for (PlaceholderPosition placeholderPosition : this.newNamePlaceholders) {
            for (AbstractRequestFilter filter : this.requestFilters) {
                String pattern;
                int nbCaptureGroups;
                if (!filter.getTypeCode().equals(placeholderPosition.typeCode)) continue;
                if (!(filter instanceof AbstractPatternRequestFilter)) continue block0;
                AbstractPatternRequestFilter patternFilter = (AbstractPatternRequestFilter)filter;
                if (placeholderPosition.index <= 0 || placeholderPosition.index <= (nbCaptureGroups = RegExUtils.getCaptureGroupCount(pattern = patternFilter.getPattern()))) continue block0;
                throw new InvalidRequestProcessingRuleException(String.format("Pattern '%s' has no matching group '%d'", pattern, placeholderPosition.index));
            }
        }
    }

    public static enum ReturnState {
        STOP,
        DROP,
        CONTINUE;

    }
}

