/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.cookie.CookieOrigin;
import org.htmlunit.util.Cookie;
import org.htmlunit.util.UrlUtils;

public class CookieManager
implements Serializable {
    private boolean cookiesEnabled_ = true;
    private final Set<Cookie> cookies_ = new LinkedHashSet<Cookie>();

    public synchronized void setCookiesEnabled(boolean enabled) {
        this.cookiesEnabled_ = enabled;
    }

    public synchronized boolean isCookiesEnabled() {
        return this.cookiesEnabled_;
    }

    public synchronized Set<Cookie> getCookies() {
        if (!this.isCookiesEnabled()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Cookie> copy = new LinkedHashSet<Cookie>(this.cookies_);
        return Collections.unmodifiableSet(copy);
    }

    public CookieOrigin buildCookieOrigin(URL url) {
        URL normalizedUrl = this.replaceForCookieIfNecessary(url);
        return new CookieOrigin(normalizedUrl.getHost(), this.getPort(normalizedUrl), normalizedUrl.getPath(), "https".equals(normalizedUrl.getProtocol()));
    }

    public synchronized boolean clearExpired(Date date) {
        if (!this.isCookiesEnabled()) {
            return false;
        }
        if (date == null) {
            return false;
        }
        boolean foundExpired = false;
        Iterator<Cookie> iter = this.cookies_.iterator();
        while (iter.hasNext()) {
            Cookie cookie = iter.next();
            if (cookie.getExpires() == null || !date.after(cookie.getExpires())) continue;
            iter.remove();
            foundExpired = true;
        }
        return foundExpired;
    }

    protected int getPort(URL url) {
        if (url.getPort() != -1) {
            return url.getPort();
        }
        return url.getDefaultPort();
    }

    public URL replaceForCookieIfNecessary(URL url) {
        String protocol = url.getProtocol();
        boolean file = "file".equals(protocol);
        if (file) {
            try {
                url = UrlUtils.getUrlWithNewHostAndPort(url, "LOCAL_FILESYSTEM", 0);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return url;
    }

    public synchronized Cookie getCookie(String name) {
        if (!this.isCookiesEnabled()) {
            return null;
        }
        for (Cookie cookie : this.cookies_) {
            if (!StringUtils.equals((CharSequence)cookie.getName(), (CharSequence)name)) continue;
            return cookie;
        }
        return null;
    }

    public synchronized void addCookie(Cookie cookie) {
        if (!this.isCookiesEnabled()) {
            return;
        }
        this.cookies_.remove(cookie);
        if (cookie.getExpires() == null || cookie.getExpires().after(new Date())) {
            this.cookies_.add(cookie);
        }
    }

    public synchronized void removeCookie(Cookie cookie) {
        if (!this.isCookiesEnabled()) {
            return;
        }
        this.cookies_.remove(cookie);
    }

    public synchronized void clearCookies() {
        if (!this.isCookiesEnabled()) {
            return;
        }
        this.cookies_.clear();
    }
}

