/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.History;
import org.htmlunit.Page;
import org.htmlunit.Screen;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.css.ElementCssStyleDeclaration;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import org.htmlunit.javascript.background.JavaScriptJobManager;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.css.CSSStyleSheet;
import org.htmlunit.javascript.host.css.StyleSheetList;
import org.htmlunit.javascript.host.html.HTMLDocument;

public abstract class WebWindowImpl
implements WebWindow {
    private static final Log LOG = LogFactory.getLog(WebWindowImpl.class);
    private final WebClient webClient_;
    private final Screen screen_;
    private Page enclosedPage_;
    private transient Object scriptObject_;
    private JavaScriptJobManager jobManager_;
    private final List<WebWindowImpl> childWindows_ = new ArrayList<WebWindowImpl>();
    private String name_ = "";
    private final History history_ = new History(this);
    private boolean closed_;
    private int innerHeight_;
    private int outerHeight_;
    private int innerWidth_;
    private int outerWidth_;

    public WebWindowImpl(WebClient webClient) {
        WebAssert.notNull("webClient", webClient);
        this.webClient_ = webClient;
        this.jobManager_ = BackgroundJavaScriptFactory.theFactory().createJavaScriptJobManager(this);
        this.screen_ = new Screen(webClient);
        this.innerHeight_ = 605;
        this.innerWidth_ = 1256;
        if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_86)) {
            this.outerHeight_ = this.innerHeight_ + 86;
            this.outerWidth_ = this.innerWidth_ + 16;
        } else if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_91)) {
            this.outerHeight_ = this.innerHeight_ + 91;
            this.outerWidth_ = this.innerWidth_ + 12;
        } else if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_131)) {
            this.outerHeight_ = this.innerHeight_ + 131;
            this.outerWidth_ = this.innerWidth_ + 63;
        } else if (webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_OUTER_INNER_HEIGHT_DIFF_133)) {
            this.outerHeight_ = this.innerHeight_ + 133;
            this.outerWidth_ = this.innerWidth_ + 16;
        } else {
            this.outerHeight_ = this.innerHeight_ + 115;
            this.outerWidth_ = this.innerWidth_ + 14;
        }
    }

    protected void performRegistration() {
        this.webClient_.registerWebWindow(this);
    }

    @Override
    public WebClient getWebClient() {
        return this.webClient_;
    }

    @Override
    public Screen getScreen() {
        return this.screen_;
    }

    @Override
    public Page getEnclosedPage() {
        return this.enclosedPage_;
    }

    @Override
    public void setEnclosedPage(Page page) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setEnclosedPage: " + page));
        }
        if (page == this.enclosedPage_) {
            return;
        }
        this.destroyChildren();
        if (this.isJavaScriptInitializationNeeded(page)) {
            this.webClient_.initialize(this, page);
        }
        if (this.webClient_.isJavaScriptEngineEnabled()) {
            Window window = (Window)this.getScriptableObject();
            window.initialize(page);
        }
        this.enclosedPage_ = page;
        this.history_.addPage(page);
    }

    protected abstract boolean isJavaScriptInitializationNeeded(Page var1);

    @Override
    public <T> void setScriptableObject(T scriptObject) {
        this.scriptObject_ = scriptObject;
    }

    @Override
    public <T> T getScriptableObject() {
        return (T)this.scriptObject_;
    }

    @Override
    public JavaScriptJobManager getJobManager() {
        return this.jobManager_;
    }

    public void setJobManager(JavaScriptJobManager jobManager) {
        this.jobManager_ = jobManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildWindow(FrameWindow child) {
        List<WebWindowImpl> list = this.childWindows_;
        synchronized (list) {
            this.childWindows_.add(child);
        }
    }

    protected void destroyChildren() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"destroyChildren");
        }
        this.getJobManager().removeAllJobs();
        while (!this.childWindows_.isEmpty()) {
            WebWindowImpl window = this.childWindows_.get(0);
            this.removeChildWindow(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChildWindow(WebWindowImpl window) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("closing child window: " + window));
        }
        window.setClosed();
        window.getJobManager().shutdown();
        Page page = window.getEnclosedPage();
        if (page != null) {
            page.cleanUp();
        }
        window.destroyChildren();
        List<WebWindowImpl> list = this.childWindows_;
        synchronized (list) {
            this.childWindows_.remove(window);
        }
    }

    @Override
    public String getName() {
        return this.name_;
    }

    @Override
    public void setName(String name) {
        this.name_ = name;
    }

    @Override
    public History getHistory() {
        return this.history_;
    }

    @Override
    public boolean isClosed() {
        return this.closed_;
    }

    protected void setClosed() {
        this.closed_ = true;
    }

    @Override
    public int getInnerWidth() {
        return this.innerWidth_;
    }

    @Override
    public void setInnerWidth(int innerWidth) {
        this.innerWidth_ = innerWidth;
    }

    @Override
    public int getOuterWidth() {
        return this.outerWidth_;
    }

    @Override
    public void setOuterWidth(int outerWidth) {
        this.outerWidth_ = outerWidth;
    }

    @Override
    public int getInnerHeight() {
        return this.innerHeight_;
    }

    @Override
    public void setInnerHeight(int innerHeight) {
        this.innerHeight_ = innerHeight;
    }

    @Override
    public int getOuterHeight() {
        return this.outerHeight_;
    }

    @Override
    public void setOuterHeight(int outerHeight) {
        this.outerHeight_ = outerHeight;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.scriptObject_ instanceof Scriptable ? this.scriptObject_ : null);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.scriptObject_ = ois.readObject();
    }

    @Override
    public ComputedCssStyleDeclaration getComputedStyle(DomElement element, String pseudoElement) {
        ComputedCssStyleDeclaration styleFromCache;
        SgmlPage sgmlPage;
        Object normalizedPseudo = pseudoElement;
        if (normalizedPseudo != null) {
            if (((String)normalizedPseudo).startsWith("::")) {
                normalizedPseudo = ((String)normalizedPseudo).substring(1);
            } else if (this.getWebClient().getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_COMPUTED_STYLE_PSEUDO_ACCEPT_WITHOUT_COLON) && ((String)normalizedPseudo).length() > 0 && ((String)normalizedPseudo).charAt(0) != ':') {
                normalizedPseudo = ":" + (String)normalizedPseudo;
            }
        }
        if ((sgmlPage = element.getPage()) instanceof HtmlPage && (styleFromCache = ((HtmlPage)sgmlPage).getStyleFromCache(element, (String)normalizedPseudo)) != null) {
            return styleFromCache;
        }
        Element e = (Element)element.getScriptableObject();
        ComputedCssStyleDeclaration computedsStyleDeclaration = new ComputedCssStyleDeclaration(new ElementCssStyleDeclaration(element));
        Object ownerDocument = e.getOwnerDocument();
        if (ownerDocument instanceof HTMLDocument) {
            StyleSheetList sheets = ((HTMLDocument)ownerDocument).getStyleSheets();
            boolean trace = LOG.isTraceEnabled();
            for (int i = 0; i < sheets.getLength(); ++i) {
                CSSStyleSheet sheet = (CSSStyleSheet)sheets.item(i);
                if (!sheet.getCssStyleSheet().isActive() || !sheet.getCssStyleSheet().isEnabled()) continue;
                if (trace) {
                    LOG.trace((Object)("modifyIfNecessary: " + sheet + ", " + computedsStyleDeclaration + ", " + e));
                }
                sheet.getCssStyleSheet().modifyIfNecessary(computedsStyleDeclaration, element, (String)normalizedPseudo);
            }
            ((HtmlPage)element.getPage()).putStyleIntoCache(element, (String)normalizedPseudo, computedsStyleDeclaration);
        }
        return computedsStyleDeclaration;
    }
}

