/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;
import org.htmlunit.html.impl.Color;

public class HtmlColorInput
extends HtmlInput
implements LabelableElement {
    HtmlColorInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        if (this.getValueAttribute() == ATTRIBUTE_NOT_DEFINED && !this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
            this.setValue("#000000");
        }
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void setValue(String newValue) {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_TYPE_COLOR_NOT_SUPPORTED)) {
            super.setValue(newValue);
            return;
        }
        if (StringUtils.isEmpty((CharSequence)newValue)) {
            super.setValue("#000000");
            return;
        }
        if (HtmlColorInput.isValid(newValue)) {
            super.setValue(newValue);
        }
    }

    private static boolean isValid(String value) {
        boolean valid = false;
        if (value.length() == 7 && value.charAt(0) == '#') {
            try {
                new Color(Integer.valueOf(value.substring(1, 3), 16), Integer.valueOf(value.substring(3, 5), 16), Integer.valueOf(value.substring(5, 7), 16));
                valid = true;
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return valid;
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }
}

