/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import javax.imageio.ImageReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlArea;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlMap;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.Node;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.MouseEvent;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.platform.Platform;
import org.htmlunit.platform.geom.IntDimension2D;
import org.htmlunit.platform.image.ImageData;
import org.htmlunit.platform.image.ImageIOImageData;
import org.htmlunit.util.UrlUtils;

public class HtmlImage
extends HtmlElement {
    private static final Log LOG = LogFactory.getLog(HtmlImage.class);
    public static final String TAG_NAME = "img";
    public static final String TAG_NAME2 = "image";
    private final String originalQualifiedName_;
    private int lastClickX_;
    private int lastClickY_;
    private WebResponse imageWebResponse_;
    private transient ImageData imageData_;
    private int width_;
    private int height_;
    private boolean downloaded_;
    private boolean isComplete_;
    private boolean onloadProcessed_;
    private boolean createdByJavascript_;
    private boolean downloadSucceeded_;

    HtmlImage(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        block3: {
            super(HtmlImage.unifyLocalName(qualifiedName), page, attributes);
            this.lastClickX_ = -1;
            this.lastClickY_ = -1;
            this.width_ = -1;
            this.height_ = -1;
            this.originalQualifiedName_ = qualifiedName;
            if (page.getWebClient().getOptions().isDownloadImages()) {
                try {
                    this.downloadImageIfNeeded();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block3;
                    LOG.debug((Object)("Unable to download image for element " + this));
                }
            }
        }
    }

    private static String unifyLocalName(String qualifiedName) {
        if (qualifiedName != null && qualifiedName.endsWith(TAG_NAME2)) {
            int pos = qualifiedName.lastIndexOf(TAG_NAME2);
            return qualifiedName.substring(0, pos) + TAG_NAME;
        }
        return qualifiedName;
    }

    @Override
    protected void onAddedToPage() {
        this.doOnLoad();
        super.onAddedToPage();
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String value, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        String oldValue;
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if ("src".equals(qualifiedName) && value != ATTRIBUTE_NOT_DEFINED && htmlPage != null && !(oldValue = this.getAttributeNS(namespaceURI, qualifiedName)).equals(value)) {
            super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
            this.onloadProcessed_ = false;
            this.downloaded_ = false;
            this.downloadSucceeded_ = false;
            this.isComplete_ = false;
            this.width_ = -1;
            this.height_ = -1;
            try {
                this.closeImageData();
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            String readyState = htmlPage.getReadyState();
            if ("loading".equals(readyState)) {
                PostponedAction action = new PostponedAction(this.getPage(), "HtmlImage.setAttributeNS"){

                    @Override
                    public void execute() throws Exception {
                        HtmlImage.this.doOnLoad();
                    }
                };
                htmlPage.addAfterLoadAction(action);
                return;
            }
            this.doOnLoad();
            return;
        }
        super.setAttributeNS(namespaceURI, qualifiedName, value, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public void processImportNode(Document doc) {
        block11: {
            URL oldUrl = null;
            String src = this.getSrcAttribute();
            HtmlPage htmlPage = this.getHtmlPageOrNull();
            try {
                if (htmlPage != null) {
                    oldUrl = htmlPage.getFullyQualifiedUrl(src);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            super.processImportNode(doc);
            URL url = null;
            htmlPage = this.getHtmlPageOrNull();
            try {
                if (htmlPage != null) {
                    url = htmlPage.getFullyQualifiedUrl(src);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (oldUrl == null || !UrlUtils.sameFile(oldUrl, url)) {
                this.lastClickX_ = -1;
                this.lastClickY_ = -1;
                this.imageWebResponse_ = null;
                this.imageData_ = null;
                this.width_ = -1;
                this.height_ = -1;
                this.downloaded_ = false;
                this.isComplete_ = false;
                this.onloadProcessed_ = false;
                this.createdByJavascript_ = true;
            }
            if (htmlPage == null) {
                return;
            }
            if (htmlPage.getWebClient().getOptions().isDownloadImages()) {
                try {
                    this.downloadImageIfNeeded();
                }
                catch (IOException e) {
                    if (!LOG.isDebugEnabled()) break block11;
                    LOG.debug((Object)("Unable to download image for element " + this));
                }
            }
        }
    }

    public void doOnLoad() {
        if (this.onloadProcessed_) {
            return;
        }
        HtmlPage htmlPage = this.getHtmlPageOrNull();
        if (htmlPage == null) {
            return;
        }
        WebClient client = htmlPage.getWebClient();
        if (this.getSrcAttribute().length() > 0 && client.isLoadStaticContent()) {
            boolean ok;
            try {
                this.downloadImageIfNeeded();
                int i = this.imageWebResponse_.getStatusCode();
                ok = i >= 200 && i < 300 || i == 305;
            }
            catch (IOException e) {
                ok = false;
            }
            this.downloadSucceeded_ = ok;
            this.onload();
        }
    }

    public final String getSrcAttribute() {
        return this.getSrcAttributeNormalized();
    }

    public String getSrc() {
        String src = this.getSrcAttribute();
        if ("".equals(src)) {
            return src;
        }
        try {
            HtmlPage page = (HtmlPage)this.getPage();
            return page.getFullyQualifiedUrl(src).toExternalForm();
        }
        catch (MalformedURLException e) {
            String msg = "Unable to create fully qualified URL for src attribute of image " + e.getMessage();
            throw new RuntimeException(msg, e);
        }
    }

    public final String getAltAttribute() {
        return this.getAttributeDirect("alt");
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getLongDescAttribute() {
        return this.getAttributeDirect("longdesc");
    }

    public final String getHeightAttribute() {
        return this.getAttributeDirect("height");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getUseMapAttribute() {
        return this.getAttributeDirect("usemap");
    }

    public final String getIsmapAttribute() {
        return this.getAttributeDirect("ismap");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getBorderAttribute() {
        return this.getAttributeDirect("border");
    }

    public final String getHspaceAttribute() {
        return this.getAttributeDirect("hspace");
    }

    public final String getVspaceAttribute() {
        return this.getAttributeDirect("vspace");
    }

    public int getHeight() throws IOException {
        if (this.height_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.height_;
    }

    public int getHeightOrDefault() {
        String src;
        String height = this.getHeightAttribute();
        if (ATTRIBUTE_NOT_DEFINED != height) {
            try {
                return Integer.parseInt(height);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ATTRIBUTE_NOT_DEFINED == (src = this.getSrcAttribute())) {
            BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 30;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_24x24_0x0)) {
                return 0;
            }
            return 24;
        }
        WebClient webClient = this.getPage().getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_EMPTY_SOURCE_RETURNS_0x0) && StringUtils.isEmpty((CharSequence)src)) {
            return 0;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) && StringUtils.isBlank((CharSequence)src)) {
            return 0;
        }
        try {
            return this.getHeight();
        }
        catch (IOException e) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 30;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0)) {
                return 16;
            }
            return 24;
        }
    }

    public int getWidth() throws IOException {
        if (this.width_ < 0) {
            this.determineWidthAndHeight();
        }
        return this.width_;
    }

    public int getWidthOrDefault() {
        String src;
        String widthAttrib = this.getWidthAttribute();
        if (ATTRIBUTE_NOT_DEFINED != widthAttrib) {
            try {
                return Integer.parseInt(widthAttrib);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (ATTRIBUTE_NOT_DEFINED == (src = this.getSrcAttribute())) {
            BrowserVersion browserVersion = this.getPage().getWebClient().getBrowserVersion();
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 28;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) || browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_24x24_0x0)) {
                return 0;
            }
            return 24;
        }
        WebClient webClient = this.getPage().getWebClient();
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_EMPTY_SOURCE_RETURNS_0x0) && StringUtils.isEmpty((CharSequence)src)) {
            return 0;
        }
        if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0) && StringUtils.isBlank((CharSequence)src)) {
            return 0;
        }
        try {
            return this.getWidth();
        }
        catch (IOException e) {
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_28x30_28x30)) {
                return 28;
            }
            if (browserVersion.hasFeature(BrowserVersionFeatures.JS_IMAGE_WIDTH_HEIGHT_RETURNS_16x16_0x0)) {
                return 16;
            }
            return 24;
        }
    }

    @Deprecated
    public ImageReader getImageReader() throws IOException {
        return ((ImageIOImageData)this.getImageData()).getImageReader();
    }

    public ImageData getImageData() throws IOException {
        this.readImageIfNeeded();
        return this.imageData_;
    }

    private void determineWidthAndHeight() throws IOException {
        this.readImageIfNeeded();
        IntDimension2D dim = this.imageData_.getWidthHeight();
        this.width_ = dim.getWidth();
        this.height_ = dim.getHeight();
        this.closeImageData();
    }

    private void closeImageData() throws IOException {
        if (this.imageData_ != null) {
            try {
                this.imageData_.close();
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new IOException("Exception during close()", ex);
            }
            this.imageData_ = null;
        }
    }

    public WebResponse getWebResponse(boolean downloadIfNeeded) throws IOException {
        if (downloadIfNeeded) {
            this.downloadImageIfNeeded();
        }
        return this.imageWebResponse_;
    }

    private void downloadImageIfNeeded() throws IOException {
        if (!this.downloaded_) {
            HtmlPage page;
            WebClient webClient;
            BrowserVersion browser;
            String src = this.getSrcAttribute();
            if (!("".equals(src) || (browser = (webClient = (page = (HtmlPage)this.getPage()).getWebClient()).getBrowserVersion()).hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank((CharSequence)src))) {
                URL url = page.getFullyQualifiedUrl(src);
                WebRequest request = new WebRequest(url, browser.getImgAcceptHeader(), browser.getAcceptEncodingHeader());
                request.setCharset(page.getCharset());
                request.setRefererlHeader(page.getUrl());
                this.imageWebResponse_ = webClient.loadWebResponse(request);
            }
            this.closeImageData();
            this.downloaded_ = true;
            this.isComplete_ = this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) || this.imageWebResponse_ != null && this.imageWebResponse_.getContentType().contains(TAG_NAME2);
            this.width_ = -1;
            this.height_ = -1;
        }
    }

    private void readImageIfNeeded() throws IOException {
        this.downloadImageIfNeeded();
        if (this.imageData_ == null) {
            if (null == this.imageWebResponse_) {
                throw new IOException("No image response available (src='" + this.getSrcAttribute() + "')");
            }
            this.imageData_ = Platform.buildImageData(this.imageWebResponse_.getContentAsStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page click(int x, int y) throws IOException {
        this.lastClickX_ = x;
        this.lastClickY_ = y;
        try {
            Object p = super.click();
            return p;
        }
        finally {
            this.lastClickX_ = -1;
            this.lastClickY_ = -1;
        }
    }

    public Page click() throws IOException {
        return this.click(0, 0);
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlAnchor anchor;
        if (ATTRIBUTE_NOT_DEFINED != this.getUseMapAttribute()) {
            String mapName = this.getUseMapAttribute().substring(1);
            HtmlElement doc = ((HtmlPage)this.getPage()).getDocumentElement();
            HtmlMap map = (HtmlMap)doc.getOneHtmlElementByAttribute("map", "name", mapName);
            for (DomElement element : map.getChildElements()) {
                HtmlArea area;
                if (!(element instanceof HtmlArea) || !(area = (HtmlArea)element).containsPoint(Math.max(this.lastClickX_, 0), Math.max(this.lastClickY_, 0))) continue;
                area.doClickStateUpdate(shiftKey, ctrlKey);
                return false;
            }
        }
        if ((anchor = (HtmlAnchor)this.getEnclosingElement("a")) == null) {
            return false;
        }
        if (ATTRIBUTE_NOT_DEFINED != this.getIsmapAttribute()) {
            String suffix = "?" + Math.max(this.lastClickX_, 0) + "," + Math.max(this.lastClickY_, 0);
            anchor.doClickStateUpdate(false, false, suffix);
            return false;
        }
        anchor.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    public void saveAs(File file) throws IOException {
        this.downloadImageIfNeeded();
        if (null != this.imageWebResponse_) {
            try (OutputStream fos = Files.newOutputStream(file.toPath(), new OpenOption[0]);
                 InputStream inputStream = this.imageWebResponse_.getContentAsStream();){
                IOUtils.copy((InputStream)inputStream, (OutputStream)fos);
            }
        }
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    public void onload() {
        if (this.downloadSucceeded_ && !this.onloadProcessed_ && this.hasEventHandlers("onload")) {
            this.onloadProcessed_ = true;
            final Event event = new Event(this, "load");
            final Node scriptObject = (Node)this.getScriptableObject();
            HtmlPage htmlPage = (HtmlPage)this.getPage();
            String readyState = htmlPage.getReadyState();
            PostponedAction action = new PostponedAction(this.getPage(), null){

                @Override
                public void execute() throws Exception {
                    scriptObject.executeEventLocally(event);
                }
            };
            if ("loading".equals(readyState)) {
                htmlPage.addAfterLoadAction(action);
            } else {
                try {
                    action.execute();
                }
                catch (Exception e) {
                    LOG.error((Object)e);
                }
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unable to download image for tag " + this + "; not firing onload event."));
        }
    }

    public boolean isComplete() {
        return this.isComplete_ || (this.hasFeature(BrowserVersionFeatures.JS_IMAGE_COMPLETE_RETURNS_TRUE_FOR_NO_REQUEST) ? ATTRIBUTE_NOT_DEFINED == this.getSrcAttribute() : this.imageData_ != null);
    }

    @Override
    public boolean isDisplayed() {
        String src = this.getSrcAttribute();
        if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_INVISIBLE_NO_SRC)) {
            if (ATTRIBUTE_NOT_DEFINED == src) {
                return false;
            }
            if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_BLANK_SRC_AS_EMPTY) && StringUtils.isBlank((CharSequence)src)) {
                return false;
            }
            if (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_EMPTY_SRC_DISPLAY_FALSE) && StringUtils.isEmpty((CharSequence)src)) {
                return false;
            }
        }
        return super.isDisplayed();
    }

    public void markAsCreatedByJavascript() {
        this.createdByJavascript_ = true;
    }

    public boolean wasCreatedByJavascript() {
        return this.createdByJavascript_;
    }

    public String getOriginalQualifiedName() {
        return this.originalQualifiedName_;
    }

    @Override
    public String getLocalName() {
        if (this.wasCreatedByJavascript() && (this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLELEMENT) || this.hasFeature(BrowserVersionFeatures.HTMLIMAGE_HTMLUNKNOWNELEMENT))) {
            return this.originalQualifiedName_;
        }
        return super.getLocalName();
    }

    @Override
    public ScriptResult fireEvent(Event event) {
        if (event instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)event;
            HTMLElement scriptableObject = (HTMLElement)this.getScriptableObject();
            if (this.lastClickX_ >= 0) {
                mouseEvent.setClientX(scriptableObject.getPosX() + this.lastClickX_);
            }
            if (this.lastClickY_ >= 0) {
                mouseEvent.setClientY(scriptableObject.getPosX() + this.lastClickY_);
            }
        }
        return super.fireEvent(event);
    }
}

