/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;

public class HtmlMap
extends HtmlElement {
    public static final String TAG_NAME = "map";

    HtmlMap(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE;
    }

    @Override
    public boolean isDisplayed() {
        HtmlImage image = this.findReferencingImage();
        if (null != image) {
            return image.isDisplayed();
        }
        return false;
    }

    private HtmlImage findReferencingImage() {
        HtmlPage page = this.getHtmlPageOrNull();
        Object name = this.getNameAttribute();
        if (null != page && StringUtils.isNotBlank((CharSequence)name)) {
            name = "#" + ((String)name).trim();
            Iterator iterator = page.getDocumentElement().getElementsByTagName("img").iterator();
            while (iterator.hasNext()) {
                HtmlElement elem = (HtmlElement)iterator.next();
                HtmlImage image = (HtmlImage)elem;
                if (!((String)name).equals(image.getUseMapAttribute())) continue;
                return image;
            }
        }
        return null;
    }
}

