/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.io.IOException;
import java.util.Map;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.LabelableElement;

public class HtmlResetInput
extends HtmlInput
implements LabelableElement {
    public static final String DEFAULT_VALUE = "Reset";

    HtmlResetInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        BrowserVersion browserVersion;
        if (this.getAttributeDirect("value") == ATTRIBUTE_NOT_DEFINED && (browserVersion = page.getWebClient().getBrowserVersion()).hasFeature(BrowserVersionFeatures.RESETINPUT_DEFAULT_VALUE_IF_VALUE_NOT_DEFINED)) {
            this.setValue(DEFAULT_VALUE);
        }
    }

    @Override
    protected boolean doClickStateUpdate(boolean shiftKey, boolean ctrlKey) throws IOException {
        HtmlForm form;
        if (!this.isDisabled() && (form = this.getEnclosingForm()) != null) {
            form.reset();
            return false;
        }
        super.doClickStateUpdate(shiftKey, ctrlKey);
        return false;
    }

    @Override
    public void setValue(String newValue) {
        super.setValue(newValue);
        this.setDefaultValue(newValue);
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public void reset() {
    }

    @Override
    protected boolean propagateClickStateUpdateToParent() {
        return true;
    }

    @Override
    protected boolean isRequiredSupported() {
        return false;
    }

    @Override
    public boolean willValidate() {
        return false;
    }
}

