/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.css;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.css.CssStyleSheet;
import org.htmlunit.cssparser.dom.MediaListImpl;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlLink;
import org.htmlunit.html.HtmlStyle;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLLinkElement;
import org.htmlunit.javascript.host.html.HTMLStyleElement;

@JsxClass
public class StyleSheetList
extends HtmlUnitScriptable {
    private HTMLCollection nodes_;

    boolean isActiveStyleSheetLink(DomNode domNode) {
        HtmlLink link;
        if (domNode instanceof HtmlLink && (link = (HtmlLink)domNode).isStyleSheetLink()) {
            String media = link.getMediaAttribute();
            if (StringUtils.isBlank((CharSequence)media)) {
                return true;
            }
            WebWindow webWindow = this.getWindow().getWebWindow();
            MediaListImpl mediaList = CssStyleSheet.parseMedia(webWindow.getWebClient().getCssErrorHandler(), media);
            return CssStyleSheet.isActive(mediaList, webWindow);
        }
        return false;
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public StyleSheetList() {
    }

    public StyleSheetList(Document document) {
        this.setParentScope((Scriptable)document);
        this.setPrototype(this.getPrototype(this.getClass()));
        WebClient webClient = this.getWindow().getWebWindow().getWebClient();
        if (webClient.getOptions().isCssEnabled()) {
            boolean onlyActive = webClient.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_STYLESHEETLIST_ACTIVE_ONLY);
            this.nodes_ = new HTMLCollection(document.getDomNodeOrDie(), true);
            this.nodes_.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
                HtmlElement node = event.getHtmlElement();
                if (node instanceof HtmlLink && "rel".equalsIgnoreCase(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            });
            this.nodes_.setIsMatchingPredicate((Predicate<DomNode> & Serializable)node -> {
                if (node instanceof HtmlStyle) {
                    return true;
                }
                if (onlyActive) {
                    return this.isActiveStyleSheetLink((DomNode)node);
                }
                return node instanceof HtmlLink && ((HtmlLink)node).isStyleSheetLink();
            });
        } else {
            this.nodes_ = HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
    }

    @JsxGetter
    public int getLength() {
        return this.nodes_.getLength();
    }

    @JsxFunction
    public Object item(int index) {
        if (this.nodes_ == null || index < 0 || index >= this.nodes_.getLength()) {
            return Undefined.instance;
        }
        HTMLElement element = (HTMLElement)this.nodes_.item(index);
        if (element instanceof HTMLStyleElement) {
            return ((HTMLStyleElement)element).getSheet();
        }
        return ((HTMLLinkElement)element).getSheet();
    }

    public Object get(int index, Scriptable start) {
        if (this == start) {
            return this.item(index);
        }
        return super.get(index, start);
    }

    @Override
    protected Object equivalentValues(Object value) {
        return value != null && this.getClass() == value.getClass() && this.getDomNodeOrNull() == ((StyleSheetList)value).getDomNodeOrNull();
    }
}

