/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.WebClient;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.ES6Iterator;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.NativeArrayIterator;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.AbstractList;

@JsxClass
public class NodeList
extends AbstractList
implements Callable {
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public NodeList() {
    }

    public NodeList(DomNode domNode, boolean attributeChangeSensitive) {
        super(domNode, attributeChangeSensitive, null);
    }

    public NodeList(DomNode domNode, List<DomNode> initialElements) {
        super(domNode, true, new ArrayList<DomNode>(initialElements));
    }

    NodeList(ScriptableObject parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
        this.setExternalArrayData(this);
    }

    public static NodeList staticNodeList(HtmlUnitScriptable parentScope, final List<DomNode> elements) {
        return new NodeList(parentScope){

            @Override
            public List<DomNode> getElements() {
                return elements;
            }
        };
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator keys() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.KEYS);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator values() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.VALUES);
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator entries() {
        return new NativeArrayIterator(this.getParentScope(), (Scriptable)this, NativeArrayIterator.ARRAY_ITERATOR_TYPE.ENTRIES);
    }

    @JsxSymbol(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public ES6Iterator iterator() {
        return this.values();
    }

    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void forEach(Object callback) {
        List<DomNode> nodes = this.getElements();
        WebClient client = this.getWindow().getWebWindow().getWebClient();
        HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
        ContextAction contextAction = cx -> {
            Function function = (Function)callback;
            Scriptable scope = this.getParentScope();
            for (int i = 0; i < nodes.size(); ++i) {
                function.call(cx, scope, (Scriptable)this, new Object[]{((DomNode)nodes.get(i)).getScriptableObject(), i, this});
            }
            return null;
        };
        cf.call(contextAction);
    }

    @Override
    @JsxGetter
    public final int getLength() {
        return super.getLength();
    }

    @JsxFunction
    public Object item(Object index) {
        Object object = this.getIt(index);
        if (object == NOT_FOUND) {
            return null;
        }
        return object;
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args.length == 0) {
            throw Context.reportRuntimeError((String)"Zero arguments; need an index or a key.");
        }
        Object object = this.getIt(args[0]);
        if (object == NOT_FOUND) {
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLCOLLECTION_NULL_IF_NOT_FOUND)) {
                return null;
            }
            return Undefined.instance;
        }
        return object;
    }

    @Override
    protected AbstractList create(DomNode parentScope, List<DomNode> initialElements) {
        return new NodeList(parentScope, new ArrayList<DomNode>(initialElements));
    }
}

