/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.List;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
public class XPathResult
extends HtmlUnitScriptable {
    @JsxConstant
    public static final int ANY_TYPE = 0;
    @JsxConstant
    public static final int NUMBER_TYPE = 1;
    @JsxConstant
    public static final int STRING_TYPE = 2;
    @JsxConstant
    public static final int BOOLEAN_TYPE = 3;
    @JsxConstant
    public static final int UNORDERED_NODE_ITERATOR_TYPE = 4;
    @JsxConstant
    public static final int ORDERED_NODE_ITERATOR_TYPE = 5;
    @JsxConstant
    public static final int UNORDERED_NODE_SNAPSHOT_TYPE = 6;
    @JsxConstant
    public static final int ORDERED_NODE_SNAPSHOT_TYPE = 7;
    @JsxConstant
    public static final int ANY_UNORDERED_NODE_TYPE = 8;
    @JsxConstant
    public static final int FIRST_ORDERED_NODE_TYPE = 9;
    private List<?> result_;
    private int resultType_;
    private int iteratorIndex_;

    @JsxConstructor
    public void jsConstructor() {
        throw Context.reportRuntimeError((String)"Illegal constructor.");
    }

    void init(List<?> result, int type) {
        this.result_ = result;
        this.resultType_ = type;
        if (type == 0) {
            this.resultType_ = 4;
            if (this.result_.size() == 1) {
                Object o = this.result_.get(0);
                if (o instanceof Number) {
                    this.resultType_ = 1;
                } else if (o instanceof String) {
                    this.resultType_ = 2;
                } else if (o instanceof Boolean) {
                    this.resultType_ = 3;
                }
            }
        }
        this.iteratorIndex_ = 0;
    }

    @JsxGetter
    public int getResultType() {
        return this.resultType_;
    }

    @JsxGetter
    public int getSnapshotLength() {
        if (this.resultType_ != 6 && this.resultType_ != 7) {
            throw Context.reportRuntimeError((String)("Cannot get snapshotLength for type: " + this.resultType_));
        }
        return this.result_.size();
    }

    @JsxGetter
    public Node getSingleNodeValue() {
        if (this.resultType_ != 8 && this.resultType_ != 9) {
            throw Context.reportRuntimeError((String)("Cannot get singleNodeValue for type: " + this.resultType_));
        }
        if (!this.result_.isEmpty()) {
            return (Node)((DomNode)this.result_.get(0)).getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public boolean getInvalidIteratorState() {
        return false;
    }

    @JsxFunction
    public Node iterateNext() {
        if (this.resultType_ != 4 && this.resultType_ != 5) {
            throw Context.reportRuntimeError((String)("Cannot get iterateNext for type: " + this.resultType_));
        }
        if (this.iteratorIndex_ < this.result_.size()) {
            return (Node)((DomNode)this.result_.get(this.iteratorIndex_++)).getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Node snapshotItem(int index) {
        if (this.resultType_ != 6 && this.resultType_ != 7) {
            throw Context.reportRuntimeError((String)("Cannot get snapshotLength for type: " + this.resultType_));
        }
        if (index >= 0 && index < this.result_.size()) {
            return (Node)((DomNode)this.result_.get(index)).getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public double getNumberValue() {
        double answer;
        if (this.resultType_ != 1) {
            throw Context.reportRuntimeError((String)("Cannot get numberValue for type: " + this.resultType_));
        }
        if (this.result_.size() == 1) {
            Object o = this.result_.get(0);
            if (o instanceof Number) {
                return (Double)o;
            }
            if (o instanceof Boolean) {
                return (Boolean)o != false ? 1.0 : 0.0;
            }
        }
        String asString = this.asString();
        try {
            answer = Double.parseDouble(asString);
        }
        catch (NumberFormatException e) {
            answer = Double.NaN;
        }
        return answer;
    }

    @JsxGetter
    public boolean getBooleanValue() {
        if (this.resultType_ != 3) {
            throw Context.reportRuntimeError((String)("Cannot get booleanValue for type: " + this.resultType_));
        }
        if (this.result_.size() == 1) {
            Object o = this.result_.get(0);
            if (o instanceof Number) {
                double d = (Double)o;
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    return true;
                }
                return 0.0 != d;
            }
            if (o instanceof String) {
                return !((String)o).isEmpty();
            }
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        return this.result_.size() > 0;
    }

    @JsxGetter
    public String getStringValue() {
        if (this.resultType_ != 2) {
            throw Context.reportRuntimeError((String)("Cannot get stringValue for type: " + this.resultType_));
        }
        return this.asString();
    }

    private String asString() {
        if (this.result_.size() < 1) {
            return "";
        }
        Object resultObj = this.result_.get(0);
        if (resultObj instanceof DomAttr) {
            return ((DomAttr)resultObj).getValue();
        }
        if (resultObj instanceof DomNode) {
            return ((DomNode)resultObj).asNormalizedText();
        }
        return resultObj.toString();
    }
}

