/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.applet.Applet;
import java.lang.reflect.Method;
import org.htmlunit.corejs.javascript.BaseFunction;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlApplet;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlApplet.class, value={SupportedBrowser.IE})
public class HTMLAppletElement
extends HTMLElement {
    @Override
    public void setDomNode(DomNode domNode) {
        super.setDomNode(domNode);
        if (domNode.getPage().getWebClient().getOptions().isAppletEnabled()) {
            try {
                this.createAppletMethodAndProperties();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void createAppletMethodAndProperties() throws Exception {
        HtmlApplet appletNode = (HtmlApplet)this.getDomNodeOrDie();
        final Applet applet = appletNode.getApplet();
        if (applet == null) {
            return;
        }
        for (final Method method : applet.getClass().getMethods()) {
            BaseFunction f = new BaseFunction(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    Object[] realArgs = new Object[method.getParameterTypes().length];
                    for (int i = 0; i < realArgs.length; ++i) {
                        Object arg = i > args.length ? null : Context.jsToJava((Object)args[i], method.getParameterTypes()[i]);
                        realArgs[i] = arg;
                    }
                    try {
                        return method.invoke((Object)applet, realArgs);
                    }
                    catch (Exception e) {
                        throw Context.throwAsScriptRuntimeEx((Throwable)e);
                    }
                }
            };
            ScriptableObject.defineProperty((Scriptable)this, (String)method.getName(), (Object)f, (int)1);
        }
    }

    @JsxGetter
    public String getAlt() {
        return this.getDomNodeOrDie().getAttributeDirect("alt");
    }

    @JsxSetter
    public void setAlt(String alt) {
        this.getDomNodeOrDie().setAttribute("alt", alt);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getBorder() {
        return this.getDomNodeOrDie().getAttributeDirect("border");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setBorder(String border) {
        this.getDomNodeOrDie().setAttribute("border", border);
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClassid() {
        return this.getDomNodeOrDie().getAttributeDirect("classid");
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClassid(String classid) {
        this.getDomNodeOrDie().setAttribute("classid", classid);
    }

    @JsxGetter(propertyName="width")
    public String getWidth_js() {
        return this.getWidthOrHeight("width", Boolean.TRUE);
    }

    @JsxSetter(propertyName="width")
    public void setWidth_js(String width) {
        this.setWidthOrHeight("width", width, true);
    }

    @JsxGetter(propertyName="height")
    public String getHeight_js() {
        return this.getWidthOrHeight("height", Boolean.TRUE);
    }

    @JsxSetter(propertyName="height")
    public void setHeight_js(String height) {
        this.setWidthOrHeight("height", height, true);
    }
}

